package app.raybritton.tokenstorage.keyCrypto

import java.security.MessageDigest
import kotlin.experimental.and

/**
 * This hashes the key instead of encrypting it.
 * This means that the keys() method on TokenStorage will return the hashes as it can't
 * reverse the hashing.
 */
class HashKeyCrypto : KeyCrypto {
    override fun verify() {}

    override fun encrypt(plaintext: String): String {
        val md = MessageDigest.getInstance("SHA1")
        md.reset()
        val buffer: ByteArray = (plaintext + "_token_key").toByteArray()
        md.update(buffer)
        val digest = md.digest()
        val hexStr = StringBuilder()
        for (byt in digest) {
            hexStr.append(Integer.toString((byt.and(0xff.toByte())) + 0x100, 16).substring(1))
        }
        return hexStr.toString()
    }

    override fun decrypt(encrypted: String) = encrypted
}