/*
 * Decompiled with CFR 0.152.
 */
package app.futured.donut;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import app.futured.donut.DonutDirection;
import app.futured.donut.DonutProgressLine;
import app.futured.donut.DonutSection;
import app.futured.donut.DonutStrokeCap;
import app.futured.donut.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 z2\u00020\u0001:\u0001zB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020%2\n\b\u0002\u0010S\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010TJ*\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020\u001e2\u0006\u0010X\u001a\u00020%2\u0010\b\u0002\u0010Y\u001a\n\u0012\u0004\u0012\u00020O\u0018\u00010ZH\u0002J\u0016\u0010[\u001a\u00020O2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0\\H\u0002J\u0006\u0010]\u001a\u00020OJ\u0010\u0010^\u001a\u00020%2\u0006\u0010_\u001a\u00020%H\u0002J\u0010\u0010`\u001a\u00020%2\u0006\u0010P\u001a\u00020QH\u0002J\f\u0010a\u001a\b\u0012\u0004\u0012\u00020/0\\J\u001e\u0010b\u001a\u00020%2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020%0\\2\u0006\u0010d\u001a\u00020\u0007H\u0002J\u0010\u0010e\u001a\u00020\n2\u0006\u0010f\u001a\u00020QH\u0002J\b\u0010g\u001a\u00020OH\u0003J\u0010\u0010h\u001a\u00020O2\u0006\u0010i\u001a\u00020jH\u0014J\u0018\u0010k\u001a\u00020O2\u0006\u0010l\u001a\u00020\u00072\u0006\u0010m\u001a\u00020\u0007H\u0014J(\u0010n\u001a\u00020O2\u0006\u0010K\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u00072\u0006\u0010o\u001a\u00020\u00072\u0006\u0010p\u001a\u00020\u0007H\u0014J\u0016\u0010q\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020%J\u0010\u0010r\u001a\u00020O2\u0006\u0010W\u001a\u00020\u001eH\u0002J\b\u0010s\u001a\u00020OH\u0002J\u0016\u0010t\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020%J\u0014\u0010u\u001a\u00020O2\f\u0010v\u001a\b\u0012\u0004\u0012\u00020/0\\J\b\u0010w\u001a\u00020OH\u0002J\u0016\u0010x\u001a\u00020O2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020Q0ZH\u0002R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010 \u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R$\u0010&\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00101\u001a\u0002002\u0006\u0010\u001f\u001a\u000200@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00106\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010(\"\u0004\b8\u0010*R$\u00109\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010(\"\u0004\b;\u0010*R\u000e\u0010<\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001e0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010>\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010(\"\u0004\b@\u0010*R\u000e\u0010A\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010C\u001a\u00020B2\u0006\u0010\u001f\u001a\u00020B@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR$\u0010H\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010(\"\u0004\bJ\u0010*R\u000e\u0010K\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lapp/futured/donut/DonutProgressView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animateChanges", "", "getAnimateChanges", "()Z", "setAnimateChanges", "(Z)V", "animationDurationMs", "", "getAnimationDurationMs", "()J", "setAnimationDurationMs", "(J)V", "animationInterpolator", "Landroid/view/animation/Interpolator;", "getAnimationInterpolator", "()Landroid/view/animation/Interpolator;", "setAnimationInterpolator", "(Landroid/view/animation/Interpolator;)V", "animatorSet", "Landroid/animation/AnimatorSet;", "bgLine", "Lapp/futured/donut/DonutProgressLine;", "value", "bgLineColor", "getBgLineColor", "()I", "setBgLineColor", "(I)V", "", "cap", "getCap", "()F", "setCap", "(F)V", "centerX", "centerY", "data", "", "Lapp/futured/donut/DonutSection;", "Lapp/futured/donut/DonutDirection;", "direction", "getDirection", "()Lapp/futured/donut/DonutDirection;", "setDirection", "(Lapp/futured/donut/DonutDirection;)V", "gapAngleDegrees", "getGapAngleDegrees", "setGapAngleDegrees", "gapWidthDegrees", "getGapWidthDegrees", "setGapWidthDegrees", "h", "lines", "masterProgress", "getMasterProgress", "setMasterProgress", "radius", "Lapp/futured/donut/DonutStrokeCap;", "strokeCap", "getStrokeCap", "()Lapp/futured/donut/DonutStrokeCap;", "setStrokeCap", "(Lapp/futured/donut/DonutStrokeCap;)V", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "w", "xPadd", "yPadd", "addAmount", "", "sectionName", "", "amount", "color", "(Ljava/lang/String;FLjava/lang/Integer;)V", "animateLine", "Landroid/animation/ValueAnimator;", "line", "to", "animationEnded", "Lkotlin/Function0;", "assertDataConsistency", "", "clear", "dpToPx", "dp", "getAmountForSection", "getData", "getDrawAmountForLine", "amounts", "index", "hasEntriesForSection", "section", "obtainAttributes", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "oldw", "oldh", "removeAmount", "removeLine", "resolveState", "setAmount", "submitData", "sections", "updateLinesRadius", "warn", "text", "Companion", "library_release"})
public final class DonutProgressView
extends View {
    private int w;
    private int h;
    private float xPadd;
    private float yPadd;
    private float radius;
    private float centerX;
    private float centerY;
    private float masterProgress;
    private float strokeWidth;
    @NotNull
    private DonutStrokeCap strokeCap;
    private float cap;
    @ColorInt
    private int bgLineColor;
    private float gapWidthDegrees;
    private float gapAngleDegrees;
    @NotNull
    private DonutDirection direction;
    private boolean animateChanges;
    @NotNull
    private Interpolator animationInterpolator;
    private long animationDurationMs;
    private final List<DonutSection> data;
    private final List<DonutProgressLine> lines;
    private AnimatorSet animatorSet;
    private final DonutProgressLine bgLine;
    private final AttributeSet attrs;
    private final int defStyleAttr;
    private static final String TAG = "DonutProgressView";
    private static final float DEFAULT_MASTER_PROGRESS = 1.0f;
    private static final float DEFAULT_STROKE_WIDTH_DP = 12.0f;
    private static final float DEFAULT_GAP_WIDTH = 45.0f;
    private static final float DEFAULT_GAP_ANGLE = 90.0f;
    private static final float DEFAULT_CAP = 1.0f;
    private static final DonutDirection DEFAULT_DIRECTION;
    private static final int DEFAULT_BG_COLOR_RES;
    private static final boolean DEFAULT_ANIM_ENABLED = true;
    private static final DecelerateInterpolator DEFAULT_INTERPOLATOR;
    private static final int DEFAULT_ANIM_DURATION_MS = 1000;
    public static final Companion Companion;

    public final float getMasterProgress() {
        return this.masterProgress;
    }

    public final void setMasterProgress(float value) {
        float f = value;
        if (!(f >= 0.0f) || !(f <= 1.0f)) {
            return;
        }
        this.masterProgress = value;
        this.bgLine.setMMasterProgress(value);
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DonutProgressLine it = (DonutProgressLine)element$iv;
            boolean bl = false;
            it.setMMasterProgress(value);
        }
        this.invalidate();
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(float value) {
        this.strokeWidth = value;
        this.bgLine.setMLineStrokeWidth(value);
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DonutProgressLine it = (DonutProgressLine)element$iv;
            boolean bl = false;
            it.setMLineStrokeWidth(value);
        }
        this.updateLinesRadius();
        this.invalidate();
    }

    @NotNull
    public final DonutStrokeCap getStrokeCap() {
        return this.strokeCap;
    }

    public final void setStrokeCap(@NotNull DonutStrokeCap value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.strokeCap = value;
        this.bgLine.setMLineStrokeCap(value);
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DonutProgressLine it = (DonutProgressLine)element$iv;
            boolean bl = false;
            it.setMLineStrokeCap(value);
        }
        this.invalidate();
    }

    public final float getCap() {
        return this.cap;
    }

    public final void setCap(float value) {
        this.cap = value;
        this.resolveState();
    }

    public final int getBgLineColor() {
        return this.bgLineColor;
    }

    public final void setBgLineColor(int value) {
        this.bgLineColor = value;
        this.bgLine.setMLineColor(value);
        this.invalidate();
    }

    public final float getGapWidthDegrees() {
        return this.gapWidthDegrees;
    }

    public final void setGapWidthDegrees(float value) {
        this.gapWidthDegrees = value;
        this.bgLine.setMGapWidthDegrees(value);
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DonutProgressLine it = (DonutProgressLine)element$iv;
            boolean bl = false;
            it.setMGapWidthDegrees(value);
        }
        this.invalidate();
    }

    public final float getGapAngleDegrees() {
        return this.gapAngleDegrees;
    }

    public final void setGapAngleDegrees(float value) {
        this.gapAngleDegrees = value;
        this.bgLine.setMGapAngleDegrees(value);
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DonutProgressLine it = (DonutProgressLine)element$iv;
            boolean bl = false;
            it.setMGapAngleDegrees(value);
        }
        this.invalidate();
    }

    @NotNull
    public final DonutDirection getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull DonutDirection value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.direction = value;
        this.bgLine.setMDirection(value);
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DonutProgressLine it = (DonutProgressLine)element$iv;
            boolean bl = false;
            it.setMDirection(value);
        }
        this.invalidate();
    }

    public final boolean getAnimateChanges() {
        return this.animateChanges;
    }

    public final void setAnimateChanges(boolean bl) {
        this.animateChanges = bl;
    }

    @NotNull
    public final Interpolator getAnimationInterpolator() {
        return this.animationInterpolator;
    }

    public final void setAnimationInterpolator(@NotNull Interpolator interpolator) {
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"<set-?>");
        this.animationInterpolator = interpolator;
    }

    public final long getAnimationDurationMs() {
        return this.animationDurationMs;
    }

    public final void setAnimationDurationMs(long l) {
        this.animationDurationMs = l;
    }

    @SuppressLint(value={"Recycle"})
    private final void obtainAttributes() {
        Interpolator interpolator;
        Interpolator interpolator2;
        DonutStrokeCap donutStrokeCap;
        boolean bl;
        Object object;
        int strokeCapInt;
        TypedArray it;
        TypedArray $this$use$iv;
        block4: {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(this.attrs, R.styleable.DonutProgressView, this.defStyleAttr, 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"context.obtainStyledAttr\u2026,\n            0\n        )");
            $this$use$iv = typedArray;
            boolean $i$f$use = false;
            it = $this$use$iv;
            boolean bl2 = false;
            this.setStrokeWidth(it.getDimensionPixelSize(R.styleable.DonutProgressView_donut_strokeWidth, (int)this.dpToPx(12.0f)));
            strokeCapInt = it.getInt(R.styleable.DonutProgressView_donut_strokeCap, DonutStrokeCap.ROUND.getIndex());
            object = DonutStrokeCap.values();
            bl = false;
            DonutStrokeCap[] donutStrokeCapArray = object;
            boolean bl3 = false;
            DonutStrokeCap[] donutStrokeCapArray2 = donutStrokeCapArray;
            int n = donutStrokeCapArray2.length;
            for (int i = 0; i < n; ++i) {
                DonutStrokeCap donutStrokeCap2;
                DonutStrokeCap donutStrokeCap3 = donutStrokeCap2 = donutStrokeCapArray2[i];
                boolean bl4 = false;
                if (!(donutStrokeCap3.getIndex() == strokeCapInt)) continue;
                donutStrokeCap = donutStrokeCap2;
                break block4;
            }
            donutStrokeCap = null;
        }
        DonutStrokeCap strokeCapNullable = donutStrokeCap;
        DonutProgressView donutProgressView = this;
        DonutStrokeCap donutStrokeCap4 = strokeCapNullable;
        if (donutStrokeCap4 == null) {
            object = "Unexpected value " + strokeCapInt;
            DonutProgressView donutProgressView2 = donutProgressView;
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        donutProgressView.setStrokeCap(donutStrokeCap4);
        this.setBgLineColor(it.getColor(R.styleable.DonutProgressView_donut_bgLineColor, ContextCompat.getColor((Context)this.getContext(), (int)DEFAULT_BG_COLOR_RES)));
        this.setGapWidthDegrees(it.getFloat(R.styleable.DonutProgressView_donut_gapWidth, 45.0f));
        this.setGapAngleDegrees(it.getFloat(R.styleable.DonutProgressView_donut_gapAngle, 90.0f));
        this.setDirection(DonutDirection.values()[it.getInt(R.styleable.DonutProgressView_donut_direction, 0)]);
        this.animateChanges = it.getBoolean(R.styleable.DonutProgressView_donut_animateChanges, true);
        this.animationDurationMs = it.getInt(R.styleable.DonutProgressView_donut_animationDuration, 1000);
        int n = it.getResourceId(R.styleable.DonutProgressView_donut_animationInterpolator, 0);
        DonutProgressView donutProgressView3 = this;
        bl = false;
        boolean bl5 = false;
        int id = n;
        boolean bl6 = false;
        if (id != 0) {
            Interpolator interpolator3 = AnimationUtils.loadInterpolator((Context)this.getContext(), (int)id);
            interpolator2 = interpolator3;
            Intrinsics.checkExpressionValueIsNotNull((Object)interpolator3, (String)"AnimationUtils.loadInterpolator(context, id)");
        } else {
            interpolator2 = (Interpolator)DEFAULT_INTERPOLATOR;
        }
        donutProgressView3.animationInterpolator = interpolator = interpolator2;
        this.setCap(it.getFloat(R.styleable.DonutProgressView_donut_cap, 1.0f));
        Unit unit = Unit.INSTANCE;
        boolean bl7 = false;
        boolean bl8 = false;
        Unit it$iv = unit;
        boolean bl9 = false;
        $this$use$iv.recycle();
    }

    @NotNull
    public final List<DonutSection> getData() {
        return CollectionsKt.toList((Iterable)this.data);
    }

    /*
     * WARNING - void declaration
     */
    public final void submitData(@NotNull List<DonutSection> sections) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(sections, (String)"sections");
        this.assertDataConsistency(sections);
        Iterable $this$filter$iv = sections;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DonutSection it = (DonutSection)element$iv$iv;
            boolean bl = false;
            if (!(it.getAmount() >= 0.0f)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv2;
            DonutSection section = (DonutSection)element$iv;
            boolean bl = false;
            int newLineColor = section.getColor();
            if (!this.hasEntriesForSection(section.getName())) {
                this.lines.add(0, new DonutProgressLine(section.getName(), this.radius, newLineColor, this.strokeWidth, this.strokeCap, this.masterProgress, 0.0f, this.gapWidthDegrees, this.gapAngleDegrees, this.direction));
                continue;
            }
            Iterable $this$filter$iv2 = this.lines;
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                DonutProgressLine it = (DonutProgressLine)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)section.getName())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$forEach$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DonutProgressLine it = (DonutProgressLine)element$iv2;
                boolean bl3 = false;
                it.setMLineColor(newLineColor);
            }
        }
        List<DonutSection> list = this.data;
        boolean bl = false;
        boolean bl4 = false;
        List<DonutSection> $this$apply = list;
        boolean bl5 = false;
        ArrayList copy = new ArrayList(sections);
        $this$apply.clear();
        $this$apply.addAll(copy);
        this.resolveState();
    }

    /*
     * WARNING - void declaration
     */
    public final void addAmount(@NotNull String sectionName, float amount, @Nullable Integer color) {
        Intrinsics.checkParameterIsNotNull((Object)sectionName, (String)"sectionName");
        int n = 0;
        int n2 = this.data.size();
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual((Object)this.data.get((int)i).getName(), (Object)sectionName)) {
                this.data.set((int)i, DonutSection.copy$default(this.data.get((int)i), null, 0, this.data.get((int)i).getAmount() + amount, 3, null));
                this.submitData(this.data);
                return;
            }
            ++i;
        }
        Integer n3 = color;
        if (n3 != null) {
            Integer n4 = n3;
            n2 = 0;
            boolean bl = false;
            int it = ((Number)n4).intValue();
            boolean bl2 = false;
            this.submitData(CollectionsKt.plus((Collection)this.data, (Object)new DonutSection(sectionName, it, amount)));
        } else {
            this.warn((Function0<String>)((Function0)new Function0<String>(sectionName){
                final /* synthetic */ String $sectionName;

                @NotNull
                public final String invoke() {
                    return "Adding amount to non-existent section: " + this.$sectionName + ". " + "Please specify color, if you want to have section created automatically.";
                }
                {
                    this.$sectionName = string;
                    super(0);
                }
            }));
        }
    }

    public static /* synthetic */ void addAmount$default(DonutProgressView donutProgressView, String string, float f, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        donutProgressView.addAmount(string, f, n);
    }

    /*
     * WARNING - void declaration
     */
    public final void setAmount(@NotNull String sectionName, float amount) {
        Intrinsics.checkParameterIsNotNull((Object)sectionName, (String)"sectionName");
        int n = 0;
        int n2 = this.data.size();
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual((Object)this.data.get((int)i).getName(), (Object)sectionName)) {
                if (amount > 0.0f) {
                    this.data.set((int)i, DonutSection.copy$default(this.data.get((int)i), null, 0, amount, 3, null));
                } else {
                    this.data.remove((int)i);
                }
                this.submitData(this.data);
                return;
            }
            ++i;
        }
        this.warn((Function0<String>)((Function0)new Function0<String>(sectionName){
            final /* synthetic */ String $sectionName;

            @NotNull
            public final String invoke() {
                return "Setting amount for non-existent section: " + this.$sectionName;
            }
            {
                this.$sectionName = string;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void removeAmount(@NotNull String sectionName, float amount) {
        Intrinsics.checkParameterIsNotNull((Object)sectionName, (String)"sectionName");
        int n = 0;
        int n2 = this.data.size();
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual((Object)this.data.get((int)i).getName(), (Object)sectionName)) {
                float resultAmount = this.data.get((int)i).getAmount() - amount;
                if (resultAmount > 0.0f) {
                    this.data.set((int)i, DonutSection.copy$default(this.data.get((int)i), null, 0, resultAmount, 3, null));
                } else {
                    this.data.remove((int)i);
                }
                this.submitData(this.data);
                return;
            }
            ++i;
        }
        this.warn((Function0<String>)((Function0)new Function0<String>(sectionName){
            final /* synthetic */ String $sectionName;

            @NotNull
            public final String invoke() {
                return "Removing amount from non-existent section: " + this.$sectionName;
            }
            {
                this.$sectionName = string;
                super(0);
            }
        }));
    }

    public final void clear() {
        DonutProgressView donutProgressView = this;
        boolean bl = false;
        List list = CollectionsKt.emptyList();
        donutProgressView.submitData(list);
    }

    private final void assertDataConsistency(List<DonutSection> data) {
        boolean bl;
        block3: {
            Iterable $this$hasDuplicatesBy$iv = data;
            boolean $i$f$hasDuplicatesBy = false;
            boolean bl2 = false;
            List registry$iv = new ArrayList();
            Iterable $this$forEach$iv$iv = $this$hasDuplicatesBy$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object it$iv = element$iv$iv = iterator.next();
                boolean bl3 = false;
                DonutSection it = (DonutSection)it$iv;
                boolean bl4 = false;
                String sel$iv = it.getName();
                if (registry$iv.contains(sel$iv)) {
                    bl = true;
                    break block3;
                }
                registry$iv.add(sel$iv);
            }
            bl = false;
        }
        if (bl) {
            throw (Throwable)new IllegalStateException("Multiple sections with same name found");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveState() {
        block7: {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapTo$iv$iv;
            AnimatorSet animatorSet = this.animatorSet;
            if (animatorSet != null) {
                animatorSet.cancel();
            }
            this.animatorSet = new AnimatorSet();
            Iterable $this$map$iv = this.lines;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DonutProgressLine donutProgressLine = (DonutProgressLine)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Float f = Float.valueOf(this.getAmountForSection(it.getName()));
                collection.add(f);
            }
            List sectionAmounts = (List)destination$iv$iv;
            Iterable $this$sumByFloat$iv = sectionAmounts;
            boolean $i$f$sumByFloat = false;
            float sum$iv = 0.0f;
            for (Object element$iv : $this$sumByFloat$iv) {
                void it;
                float item$iv$iv = ((Number)element$iv).floatValue();
                float f = sum$iv;
                boolean bl = false;
                void var20_19 = it;
                sum$iv = f + var20_19;
            }
            float totalAmount = sum$iv;
            Iterable $this$mapIndexed$iv = sectionAmounts;
            boolean $i$f$mapIndexed = false;
            Iterable $i$f$mapTo22 = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                int n = index$iv$iv++;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                float f = ((Number)item$iv$iv).floatValue();
                int n3 = n2;
                Collection collection2 = collection;
                boolean bl2 = false;
                Float f2 = Float.valueOf(totalAmount > this.cap ? this.getDrawAmountForLine(sectionAmounts, (int)index) / totalAmount : this.getDrawAmountForLine(sectionAmounts, (int)index) / this.cap);
                collection2.add(f2);
            }
            List drawPercentages = (List)destination$iv$iv2;
            Iterable $this$forEachIndexed$iv = drawPercentages;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void newPercentage;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n4 = n;
                float f = ((Number)item$iv).floatValue();
                int index = n4;
                boolean bl3 = false;
                DonutProgressLine line = this.lines.get(index);
                ValueAnimator animator = this.animateLine(line, (float)newPercentage, (Function0<Unit>)((Function0)new Function0<Unit>(line, this){
                    final /* synthetic */ DonutProgressLine $line;
                    final /* synthetic */ DonutProgressView this$0;
                    {
                        this.$line = donutProgressLine;
                        this.this$0 = donutProgressView;
                        super(0);
                    }

                    public final void invoke() {
                        if (!DonutProgressView.access$hasEntriesForSection(this.this$0, this.$line.getName())) {
                            DonutProgressView.access$removeLine(this.this$0, this.$line);
                        }
                    }
                }));
                AnimatorSet animatorSet2 = this.animatorSet;
                if (animatorSet2 == null) continue;
                animatorSet2.play((Animator)animator);
            }
            AnimatorSet animatorSet3 = this.animatorSet;
            if (animatorSet3 == null) break block7;
            animatorSet3.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final float getAmountForSection(String sectionName) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.data;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DonutSection it = (DonutSection)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)sectionName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sumByFloat$iv = (List)destination$iv$iv;
        boolean $i$f$sumByFloat = false;
        float sum$iv = 0.0f;
        for (Object element$iv : $this$sumByFloat$iv) {
            void it;
            DonutSection donutSection = (DonutSection)element$iv;
            float f = sum$iv;
            boolean bl = false;
            float f2 = it.getAmount();
            sum$iv = f + f2;
        }
        return sum$iv;
    }

    private final float getDrawAmountForLine(List<Float> amounts, int index) {
        if (index >= amounts.size()) {
            return 0.0f;
        }
        float thisLine = ((Number)amounts.get(index)).floatValue();
        float previousLine = this.getDrawAmountForLine(amounts, index + 1);
        return thisLine + previousLine;
    }

    private final boolean hasEntriesForSection(String section) {
        int n;
        block2: {
            List<DonutSection> $this$indexOfFirst$iv = this.data;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<DonutSection> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                DonutSection item$iv;
                DonutSection it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getName(), (Object)section)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n > -1;
    }

    private final ValueAnimator animateLine(DonutProgressLine line, float to, Function0<Unit> animationEnded) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{line.getMLength(), to});
        boolean bl = false;
        boolean bl2 = false;
        ValueAnimator $this$apply = valueAnimator;
        boolean bl3 = false;
        $this$apply.setDuration(this.animateChanges ? this.animationDurationMs : 0L);
        $this$apply.setInterpolator((TimeInterpolator)this.animationInterpolator);
        $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, line, animationEnded){
            final /* synthetic */ DonutProgressView this$0;
            final /* synthetic */ DonutProgressLine $line$inlined;
            final /* synthetic */ Function0 $animationEnded$inlined;
            {
                this.this$0 = donutProgressView;
                this.$line$inlined = donutProgressLine;
                this.$animationEnded$inlined = function0;
            }

            public final void onAnimationUpdate(ValueAnimator it) {
                ValueAnimator valueAnimator = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                Object object = valueAnimator.getAnimatedValue();
                if (!(object instanceof Float)) {
                    object = null;
                }
                Float f = (Float)object;
                if (f != null) {
                    Float f2 = f;
                    boolean bl = false;
                    boolean bl2 = false;
                    float animValue = ((Number)f2).floatValue();
                    boolean bl3 = false;
                    this.$line$inlined.setMLength(animValue);
                }
                this.this$0.invalidate();
            }
        });
        Animator $this$doOnEnd$iv = (Animator)$this$apply;
        boolean $i$f$doOnEnd = false;
        Animator $this$addListener$iv$iv = $this$doOnEnd$iv;
        boolean $i$f$addListener = false;
        Animator.AnimatorListener listener$iv$iv = new Animator.AnimatorListener(this, line, animationEnded){
            final /* synthetic */ DonutProgressView this$0;
            final /* synthetic */ DonutProgressLine $line$inlined;
            final /* synthetic */ Function0 $animationEnded$inlined;
            {
                this.this$0 = donutProgressView;
                this.$line$inlined = donutProgressLine;
                this.$animationEnded$inlined = function0;
            }

            public void onAnimationRepeat(@NotNull Animator animator) {
                Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                Animator it = animator;
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                    Animator it = animator;
                    boolean bl = false;
                    Function0 function0 = this.$animationEnded$inlined;
                    if (function0 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
            }

            public void onAnimationCancel(@NotNull Animator animator) {
                Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                Animator it = animator;
            }

            public void onAnimationStart(@NotNull Animator animator) {
                Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                Animator it = animator;
            }
        };
        $this$addListener$iv$iv.addListener(listener$iv$iv);
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"ValueAnimator.ofFloat(li\u2026)\n            }\n        }");
        return valueAnimator2;
    }

    static /* synthetic */ ValueAnimator animateLine$default(DonutProgressView donutProgressView, DonutProgressLine donutProgressLine, float f, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        return donutProgressView.animateLine(donutProgressLine, f, (Function0<Unit>)function0);
    }

    private final void removeLine(DonutProgressLine line) {
        this.lines.remove(line);
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.w = w;
        this.h = h;
        this.xPadd = this.getPaddingLeft() + this.getPaddingRight();
        this.yPadd = this.getPaddingTop() + this.getPaddingBottom();
        this.centerX = (float)w / 2.0f;
        this.centerY = (float)h / 2.0f;
        this.updateLinesRadius();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int originalWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)originalWidth, (int)0x40000000));
    }

    private final void updateLinesRadius() {
        float ww = (float)this.w - this.xPadd;
        float hh = (float)this.h - this.yPadd;
        this.radius = Math.min(ww, hh) / 2.0f - this.strokeWidth / 2.0f;
        this.bgLine.setMRadius(this.radius);
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DonutProgressLine it = (DonutProgressLine)element$iv;
            boolean bl = false;
            it.setMRadius(this.radius);
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.translate(this.centerX, this.centerY);
        this.bgLine.draw(canvas);
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DonutProgressLine it = (DonutProgressLine)element$iv;
            boolean bl = false;
            it.draw(canvas);
        }
    }

    private final float dpToPx(float dp) {
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    private final void warn(Function0<String> text) {
        Log.w((String)TAG, (String)((String)text.invoke()));
    }

    @JvmOverloads
    public DonutProgressView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.attrs = attrs;
        this.defStyleAttr = defStyleAttr;
        this.masterProgress = 1.0f;
        this.strokeWidth = this.dpToPx(12.0f);
        this.strokeCap = DonutStrokeCap.ROUND;
        this.cap = 1.0f;
        this.bgLineColor = ContextCompat.getColor((Context)context, (int)DEFAULT_BG_COLOR_RES);
        this.gapWidthDegrees = 45.0f;
        this.gapAngleDegrees = 90.0f;
        this.direction = DEFAULT_DIRECTION;
        this.animateChanges = true;
        this.animationInterpolator = (Interpolator)DEFAULT_INTERPOLATOR;
        this.animationDurationMs = 1000;
        DonutProgressView donutProgressView = this;
        boolean bl = false;
        donutProgressView.data = list = (List)new ArrayList();
        donutProgressView = this;
        bl = false;
        donutProgressView.lines = list = (List)new ArrayList();
        this.bgLine = new DonutProgressLine("_bg", this.radius, this.bgLineColor, this.strokeWidth, this.strokeCap, this.masterProgress, 1.0f, this.gapWidthDegrees, this.gapAngleDegrees, this.direction);
        this.obtainAttributes();
    }

    public /* synthetic */ DonutProgressView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public DonutProgressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DonutProgressView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_DIRECTION = DonutDirection.CLOCKWISE;
        DEFAULT_BG_COLOR_RES = R.color.grey;
        DEFAULT_INTERPOLATOR = new DecelerateInterpolator(1.5f);
    }

    public static final /* synthetic */ boolean access$hasEntriesForSection(DonutProgressView $this, String section) {
        return $this.hasEntriesForSection(section);
    }

    public static final /* synthetic */ void access$removeLine(DonutProgressView $this, DonutProgressLine line) {
        $this.removeLine(line);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapp/futured/donut/DonutProgressView$Companion;", "", "()V", "DEFAULT_ANIM_DURATION_MS", "", "DEFAULT_ANIM_ENABLED", "", "DEFAULT_BG_COLOR_RES", "DEFAULT_CAP", "", "DEFAULT_DIRECTION", "Lapp/futured/donut/DonutDirection;", "DEFAULT_GAP_ANGLE", "DEFAULT_GAP_WIDTH", "DEFAULT_INTERPOLATOR", "Landroid/view/animation/DecelerateInterpolator;", "DEFAULT_MASTER_PROGRESS", "DEFAULT_STROKE_WIDTH_DP", "TAG", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

