/*
 * Decompiled with CFR 0.152.
 */
package app.eccweizhi.onscreenlog;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import app.eccweizhi.onscreenlog.LogActivity;
import app.eccweizhi.onscreenlog.Message;
import app.eccweizhi.onscreenlog.R;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.BehaviorSubject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lapp/eccweizhi/onscreenlog/NotificationController;", "", "context", "Landroid/content/Context;", "notificationId", "", "subject", "Lio/reactivex/subjects/BehaviorSubject;", "", "Lapp/eccweizhi/onscreenlog/Message;", "(Landroid/content/Context;ILio/reactivex/subjects/BehaviorSubject;)V", "notificationManager", "Landroid/support/v4/app/NotificationManagerCompat;", "buildEmptyNotification", "Landroid/app/Notification;", "buildInboxStyleNotification", "Landroid/support/v4/app/NotificationCompat$InboxStyle;", "messageList", "buildNotification", "createNotificationChannel", "", "getNotificationContentIntent", "Landroid/app/PendingIntent;", "Companion", "library_release"})
public final class NotificationController {
    private final NotificationManagerCompat notificationManager;
    private final Context context;
    private final int notificationId;
    private static final String CHANNEL_ID = "onScreenLog";
    private static final String CHANNEL_NAME = "on-screen-log";
    private static final String CHANNEL_DESCRIPTION = "Notification for on-screen-log";
    private static final String CONTENT_TITLE = "Displaying logs";
    private static final int NOTIFICATION_MAX_MESSAGE = 10;
    private static final String EMPTY_MESSAGE = "No logs yet";
    private static final long SAMPLE_DURATION_MS = 200L;
    public static final Companion Companion = new Companion(null);

    private final void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_NAME, 2);
            channel.setDescription(CHANNEL_DESCRIPTION);
            NotificationManager notificationManager = (NotificationManager)this.context.getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
        }
    }

    private final PendingIntent getNotificationContentIntent() {
        Intent intent = new Intent(this.context, LogActivity.class);
        intent.setFlags(0x30000000);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)pendingIntent, (String)"PendingIntent.getActivity(context, 0, intent, 0)");
        return pendingIntent;
    }

    private final Notification buildEmptyNotification() {
        Notification notification = new NotificationCompat.Builder(this.context, CHANNEL_ID).setSmallIcon(R.drawable.ic_notification).setContentTitle((CharSequence)CONTENT_TITLE).setContentText((CharSequence)EMPTY_MESSAGE).setPriority(-1).setOngoing(true).setContentIntent(this.getNotificationContentIntent()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)notification, (String)"NotificationCompat.Build\u2026\n                .build()");
        return notification;
    }

    private final Notification buildNotification(List<Message> messageList) {
        Notification notification = new NotificationCompat.Builder(this.context, CHANNEL_ID).setSmallIcon(R.drawable.ic_notification).setContentTitle((CharSequence)CONTENT_TITLE).setContentText((CharSequence)((Message)CollectionsKt.last(messageList)).getContent()).setStyle((NotificationCompat.Style)this.buildInboxStyleNotification(messageList)).setPriority(-1).setOngoing(true).setContentIntent(this.getNotificationContentIntent()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)notification, (String)"NotificationCompat.Build\u2026\n                .build()");
        return notification;
    }

    /*
     * WARNING - void declaration
     */
    private final NotificationCompat.InboxStyle buildInboxStyleNotification(List<Message> messageList) {
        void i;
        int currentIndex;
        NotificationCompat.InboxStyle style = new NotificationCompat.InboxStyle();
        int lastIndex = CollectionsKt.getLastIndex(messageList);
        int n = 0;
        int n2 = 10;
        while (n < n2 && (currentIndex = lastIndex - i) >= 0) {
            style.addLine((CharSequence)messageList.get(currentIndex).getContent());
            ++i;
        }
        return style;
    }

    public NotificationController(@NotNull Context context, int notificationId, @NotNull BehaviorSubject<List<Message>> subject) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(subject, (String)"subject");
        this.context = context;
        this.notificationId = notificationId;
        this.notificationManager = NotificationManagerCompat.from((Context)this.context);
        this.createNotificationChannel();
        subject.sample(200L, TimeUnit.MILLISECONDS, true).subscribe((Consumer)new Consumer<List<? extends Message>>(){

            public final void accept(@NotNull List<Message> newList) {
                Intrinsics.checkParameterIsNotNull(newList, (String)"newList");
                if (newList.isEmpty()) {
                    Notification notification = this.buildEmptyNotification();
                    notificationManager.notify(notificationId, notification);
                } else {
                    Notification notification = this.buildNotification(newList);
                    notificationManager.notify(notificationId, notification);
                }
            }
        });
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lapp/eccweizhi/onscreenlog/NotificationController$Companion;", "", "()V", "CHANNEL_DESCRIPTION", "", "CHANNEL_ID", "CHANNEL_NAME", "CONTENT_TITLE", "EMPTY_MESSAGE", "NOTIFICATION_MAX_MESSAGE", "", "SAMPLE_DURATION_MS", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

