/*
 * Decompiled with CFR 0.152.
 */
package app.eccweizhi.onscreenlog;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.support.v7.util.DiffUtil;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import app.eccweizhi.onscreenlog.Message;
import app.eccweizhi.onscreenlog.R;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.BehaviorSubject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001a\u001b\u001cB\u001b\b\u0000\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lapp/eccweizhi/onscreenlog/LogAdapter;", "Landroid/support/v7/widget/RecyclerView$Adapter;", "Landroid/support/v7/widget/RecyclerView$ViewHolder;", "subject", "Lio/reactivex/subjects/BehaviorSubject;", "", "Lapp/eccweizhi/onscreenlog/Message;", "(Lio/reactivex/subjects/BehaviorSubject;)V", "attachedRecyclerViewCount", "", "disposable", "Lio/reactivex/disposables/Disposable;", "messageList", "getItemCount", "onAttachedToRecyclerView", "", "recyclerView", "Landroid/support/v7/widget/RecyclerView;", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onDetachedFromRecyclerView", "Companion", "MessageDiffUtilCallback", "ViewHolder", "library_release"})
public final class LogAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private List<Message> messageList;
    private Disposable disposable;
    private int attachedRecyclerViewCount;
    private final BehaviorSubject<List<Message>> subject;
    private static final long SAMPLE_DURATION_MS = 400L;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        super.onAttachedToRecyclerView(recyclerView);
        int n = this.attachedRecyclerViewCount;
        this.attachedRecyclerViewCount = n + 1;
        if (this.disposable == null) {
            this.disposable = this.subject.sample(400L, TimeUnit.MILLISECONDS, true).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<List<? extends Message>>(this){
                final /* synthetic */ LogAdapter this$0;

                public final void accept(@NotNull List<Message> newList) {
                    Intrinsics.checkParameterIsNotNull(newList, (String)"newList");
                    MessageDiffUtilCallback diffUtilCb = new MessageDiffUtilCallback(LogAdapter.access$getMessageList$p(this.this$0), newList);
                    DiffUtil.DiffResult result = DiffUtil.calculateDiff((DiffUtil.Callback)diffUtilCb, (boolean)false);
                    LogAdapter.access$setMessageList$p(this.this$0, newList);
                    result.dispatchUpdatesTo((RecyclerView.Adapter)this.this$0);
                }
                {
                    this.this$0 = logAdapter;
                }
            });
        }
    }

    public void onDetachedFromRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        int n = this.attachedRecyclerViewCount;
        this.attachedRecyclerViewCount = n + -1;
        if (this.attachedRecyclerViewCount <= 0) {
            Disposable disposable = this.disposable;
            if (disposable != null) {
                disposable.dispose();
            }
            this.disposable = null;
        }
        super.onDetachedFromRecyclerView(recyclerView);
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View v;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        View view = v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_default, parent, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"v");
        return new ViewHolder(view);
    }

    public int getItemCount() {
        return this.messageList.size();
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Message message = this.messageList.get(position);
        ((ViewHolder)holder).bindView(message);
    }

    public LogAdapter(@NotNull BehaviorSubject<List<Message>> subject) {
        List list;
        Intrinsics.checkParameterIsNotNull(subject, (String)"subject");
        this.subject = subject;
        LogAdapter logAdapter = this;
        logAdapter.messageList = list = CollectionsKt.emptyList();
    }

    @NotNull
    public static final /* synthetic */ List access$getMessageList$p(LogAdapter $this) {
        return $this.messageList;
    }

    public static final /* synthetic */ void access$setMessageList$p(LogAdapter $this, @NotNull List list) {
        $this.messageList = list;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0003R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapp/eccweizhi/onscreenlog/LogAdapter$ViewHolder;", "Landroid/support/v7/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "context", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "messageTextView", "Landroid/widget/TextView;", "tagTextView", "bindView", "", "message", "Lapp/eccweizhi/onscreenlog/Message;", "getFontColor", "", "priority", "library_release"})
    private static final class ViewHolder
    extends RecyclerView.ViewHolder {
        private final Context context;
        private final TextView tagTextView;
        private final TextView messageTextView;

        public final void bindView(@NotNull Message message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.tagTextView.setText((CharSequence)message.getTag());
            this.messageTextView.setText((CharSequence)message.getContent());
            this.tagTextView.setTextColor(this.getFontColor(message.getPriority()));
            this.messageTextView.setTextColor(this.getFontColor(message.getPriority()));
        }

        @ColorInt
        private final int getFontColor(int priority) {
            int n;
            switch (priority) {
                case 2: {
                    n = R.color.text_color_verbose;
                    break;
                }
                case 3: {
                    n = R.color.text_color_debug;
                    break;
                }
                case 4: {
                    n = R.color.text_color_info;
                    break;
                }
                case 5: {
                    n = R.color.text_color_warn;
                    break;
                }
                case 6: {
                    n = R.color.text_color_error;
                    break;
                }
                case 7: {
                    n = R.color.text_color_wtf;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unknown priority");
                }
            }
            int colorRes = n;
            return ContextCompat.getColor((Context)this.context, (int)colorRes);
        }

        public ViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            this.context = itemView.getContext();
            View view = itemView.findViewById(R.id.tagTextView);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.id.tagTextView)");
            this.tagTextView = (TextView)view;
            View view2 = itemView.findViewById(R.id.messageTextView);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView.findViewById(R.id.messageTextView)");
            this.messageTextView = (TextView)view2;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lapp/eccweizhi/onscreenlog/LogAdapter$MessageDiffUtilCallback;", "Landroid/support/v7/util/DiffUtil$Callback;", "oldList", "", "Lapp/eccweizhi/onscreenlog/Message;", "newList", "(Ljava/util/List;Ljava/util/List;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "library_release"})
    private static final class MessageDiffUtilCallback
    extends DiffUtil.Callback {
        private final List<Message> oldList;
        private final List<Message> newList;

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            Message oldItem = this.oldList.get(oldItemPosition);
            Message newItem = this.newList.get(newItemPosition);
            return oldItem.getId() == newItem.getId();
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            Message oldItem = this.oldList.get(oldItemPosition);
            Message newItem = this.newList.get(newItemPosition);
            return Intrinsics.areEqual((Object)oldItem, (Object)newItem);
        }

        public MessageDiffUtilCallback(@NotNull List<Message> oldList, @NotNull List<Message> newList) {
            Intrinsics.checkParameterIsNotNull(oldList, (String)"oldList");
            Intrinsics.checkParameterIsNotNull(newList, (String)"newList");
            this.oldList = oldList;
            this.newList = newList;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lapp/eccweizhi/onscreenlog/LogAdapter$Companion;", "", "()V", "SAMPLE_DURATION_MS", "", "library_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

