/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore;

import org.jetbrains.mvstore.MVStore;
import org.jetbrains.mvstore.Page;

final class RootReference<K, V> {
    public final Page<K, V> root;
    public final long version;
    private final byte holdCount;
    private final long ownerId;
    volatile RootReference<K, V> previous;
    final long updateCounter;
    final long updateAttemptCounter;
    private final byte appendCounter;

    RootReference(Page<K, V> root, long version) {
        this.root = root;
        this.version = version;
        this.previous = null;
        this.updateCounter = 1L;
        this.updateAttemptCounter = 1L;
        this.holdCount = 0;
        this.ownerId = 0L;
        this.appendCounter = 0;
    }

    private RootReference(RootReference<K, V> r, Page<K, V> root, long updateAttemptCounter) {
        this.root = root;
        this.version = r.version;
        this.previous = r.previous;
        this.updateCounter = r.updateCounter + 1L;
        this.updateAttemptCounter = r.updateAttemptCounter + updateAttemptCounter;
        this.holdCount = 0;
        this.ownerId = 0L;
        this.appendCounter = r.appendCounter;
    }

    private RootReference(RootReference<K, V> r, int attempt) {
        this.root = r.root;
        this.version = r.version;
        this.previous = r.previous;
        this.updateCounter = r.updateCounter + 1L;
        this.updateAttemptCounter = r.updateAttemptCounter + (long)attempt;
        assert (r.holdCount == 0 || r.ownerId == Thread.currentThread().getId()) : Thread.currentThread().getId() + " " + r;
        this.holdCount = (byte)(r.holdCount + 1);
        this.ownerId = Thread.currentThread().getId();
        this.appendCounter = r.appendCounter;
    }

    private RootReference(RootReference<K, V> r, Page<K, V> root, boolean keepLocked, int appendCounter) {
        this.root = root;
        this.version = r.version;
        this.previous = r.previous;
        this.updateCounter = r.updateCounter;
        this.updateAttemptCounter = r.updateAttemptCounter;
        assert (r.holdCount > 0 && r.ownerId == Thread.currentThread().getId()) : Thread.currentThread().getId() + " " + r;
        this.holdCount = (byte)(r.holdCount - (keepLocked ? (byte)0 : 1));
        this.ownerId = this.holdCount == 0 ? 0L : Thread.currentThread().getId();
        this.appendCounter = (byte)appendCounter;
    }

    private RootReference(RootReference<K, V> r, long version, int attempt) {
        RootReference<K, V> tmp;
        RootReference<K, V> previous = r;
        while ((tmp = previous.previous) != null && tmp.root == r.root) {
            previous = tmp;
        }
        this.root = r.root;
        this.version = version;
        this.previous = previous;
        this.updateCounter = r.updateCounter + 1L;
        this.updateAttemptCounter = r.updateAttemptCounter + (long)attempt;
        this.holdCount = r.holdCount == 0 ? (byte)0 : (byte)(r.holdCount - 1);
        long l = this.ownerId = this.holdCount == 0 ? 0L : r.ownerId;
        assert (r.appendCounter == 0);
        this.appendCounter = 0;
    }

    RootReference<K, V> updateRootPage(Page<K, V> newRootPage, long attemptCounter) {
        return this.isFree() ? this.tryUpdate(new RootReference<K, V>(this, newRootPage, attemptCounter)) : null;
    }

    RootReference<K, V> tryLock(int attemptCounter) {
        return this.canUpdate() ? this.tryUpdate(new RootReference<K, V>(this, attemptCounter)) : null;
    }

    RootReference<K, V> tryUnlockAndUpdateVersion(long version, int attempt) {
        return this.canUpdate() ? this.tryUpdate(new RootReference<K, V>(this, version, attempt)) : null;
    }

    RootReference<K, V> updatePageAndLockedStatus(Page<K, V> page2, boolean keepLocked, int appendCounter) {
        return this.canUpdate() ? this.tryUpdate(new RootReference<K, V>(this, page2, keepLocked, appendCounter)) : null;
    }

    void removeUnusedOldVersions(long oldestVersionToKeep) {
        RootReference<K, V> rootRef = this;
        while (rootRef != null) {
            if (rootRef.version < oldestVersionToKeep) {
                RootReference<K, V> previous;
                if (MVStore.ASSERT_MODE && (previous = rootRef.previous) != null && previous.getAppendCounter() != 0) {
                    throw new AssertionError((Object)(oldestVersionToKeep + " " + rootRef.previous));
                }
                rootRef.previous = null;
            }
            rootRef = rootRef.previous;
        }
    }

    boolean isLocked() {
        return this.holdCount != 0;
    }

    private boolean isFree() {
        return this.holdCount == 0;
    }

    private boolean canUpdate() {
        return this.isFree() || this.ownerId == Thread.currentThread().getId();
    }

    public boolean isLockedByCurrentThread() {
        return this.holdCount != 0 && this.ownerId == Thread.currentThread().getId();
    }

    private RootReference<K, V> tryUpdate(RootReference<K, V> updatedRootReference) {
        assert (this.canUpdate());
        return this.root.map.compareAndSetRoot(this, updatedRootReference) ? updatedRootReference : null;
    }

    long getVersion() {
        RootReference<K, V> prev = this.previous;
        return prev == null || prev.root != this.root || prev.appendCounter != this.appendCounter ? this.version : prev.getVersion();
    }

    boolean hasChangesSince(long version, boolean persistent) {
        return persistent && (!this.root.isSaved() ? this.getTotalCount() > 0L : this.getAppendCounter() > 0) || this.getVersion() > version;
    }

    int getAppendCounter() {
        return this.appendCounter & 0xFF;
    }

    public boolean needFlush() {
        return this.appendCounter != 0;
    }

    public long getTotalCount() {
        return this.root.getTotalCount() + (long)this.getAppendCounter();
    }

    public String toString() {
        return "RootReference(" + System.identityHashCode(this.root) + ", v=" + this.version + ", owner=" + this.ownerId + (this.ownerId == Thread.currentThread().getId() ? "(current)" : "") + ", holdCnt=" + this.holdCount + ", keys=" + this.root.getTotalCount() + ", append=" + this.getAppendCounter() + ")";
    }
}

