/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mvstore.DataUtil;
import org.jetbrains.mvstore.KeyManager;
import org.jetbrains.mvstore.MVMap;
import org.jetbrains.mvstore.type.DataType;
import org.jetbrains.mvstore.type.KeyableDataType;

public final class ObjectKeyManager<K>
implements KeyManager<K> {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final ObjectKeyManager<?> EMPTY = new ObjectKeyManager();
    private final K[] keys;
    private final int serializedDataSize;

    public ObjectKeyManager(K[] keys2, int serializedDataSize) {
        this.keys = keys2;
        this.serializedDataSize = serializedDataSize;
    }

    public ObjectKeyManager(DataType<K> dataType, ByteBuf buf, int count2) {
        this.keys = dataType.createStorage(count2);
        int readableBytesBefore = buf.readableBytes();
        dataType.read(buf, this.keys, count2);
        this.serializedDataSize = readableBytesBefore - buf.readableBytes();
    }

    private ObjectKeyManager() {
        this.keys = EMPTY_OBJECT_ARRAY;
        this.serializedDataSize = 0;
    }

    ObjectKeyManager(@NotNull MVMap<K, ?> map2, K[] keysBuffer, int available, int keyCount) {
        if (map2 == null) {
            ObjectKeyManager.$$$reportNull$$$0(0);
        }
        KeyableDataType<K> keyType = map2.getKeyType();
        this.keys = keyType.createStorage(keyCount);
        System.arraycopy(keysBuffer, available, this.keys, 0, keyCount);
        this.serializedDataSize = keyType.getMemory(this.keys);
    }

    public ObjectKeyManager(@NotNull MVMap<K, ?> map2, @NotNull K singleKey) {
        if (map2 == null) {
            ObjectKeyManager.$$$reportNull$$$0(1);
        }
        if (singleKey == null) {
            ObjectKeyManager.$$$reportNull$$$0(2);
        }
        this.keys = map2.getKeyType().createStorage(1);
        this.keys[0] = singleKey;
        this.serializedDataSize = map2.getKeyType().getMemory(singleKey);
    }

    @Override
    public int getKeyCount() {
        return this.keys.length;
    }

    @Override
    public K getKey(int index) {
        return this.keys[index];
    }

    @Override
    public int binarySearch(K key, MVMap<K, ?> map2, int cachedCompare) {
        int length = this.keys.length;
        return length == 0 ? -1 : ObjectKeyManager.binarySearch(key, this.keys, length, cachedCompare, map2.getKeyType());
    }

    private static <T> int binarySearch(T key, T[] storage, int size, int initialGuess, KeyableDataType<T> keyType) {
        int low = 0;
        int high = size - 1;
        int x = initialGuess - 1;
        if (x < 0 || x > high) {
            x = high >>> 1;
        }
        while (low <= high) {
            int compare = keyType.compare(key, storage[x]);
            if (compare > 0) {
                low = x + 1;
            } else if (compare < 0) {
                high = x - 1;
            } else {
                return x;
            }
            x = low + high >>> 1;
        }
        return ~low;
    }

    @Override
    public ObjectKeyManager<K> expandKeys(int extraKeyCount, K[] extraKeys, MVMap<K, ?> map2) {
        int keyCount = this.keys.length;
        KeyableDataType<K> keyType = map2.getKeyType();
        T[] newKeys = keyType.createStorage(keyCount + extraKeyCount);
        System.arraycopy(this.keys, 0, newKeys, 0, keyCount);
        System.arraycopy(extraKeys, 0, newKeys, keyCount, extraKeyCount);
        return new ObjectKeyManager(newKeys, this.serializedDataSize + keyType.getMemory(extraKeys));
    }

    @Override
    public KeyManager<K> copy(int startIndex, int endIndex, MVMap<K, ?> map2) {
        KeyableDataType<K> keyType = map2.getKeyType();
        int count2 = endIndex - startIndex;
        T[] newKeys = keyType.createStorage(count2);
        System.arraycopy(this.keys, startIndex, newKeys, 0, count2);
        return new ObjectKeyManager(newKeys, keyType.getMemory(newKeys));
    }

    @Override
    public ObjectKeyManager<K> insertKey(int index, K key, MVMap<K, ?> map2) {
        int keyCount = this.keys.length;
        KeyableDataType<K> keyType = map2.getKeyType();
        assert (index <= keyCount) : index + " > " + keyCount;
        T[] newKeys = keyType.createStorage(keyCount + 1);
        DataUtil.copyWithGap(this.keys, newKeys, keyCount, index);
        newKeys[index] = key;
        return new ObjectKeyManager(newKeys, this.serializedDataSize + keyType.getMemory(key));
    }

    @Override
    public KeyManager<K> remove(int index, MVMap<K, ?> map2) {
        int keyCount = this.keys.length;
        if (keyCount == 1) {
            return EMPTY;
        }
        KeyableDataType<K> keyType = map2.getKeyType();
        int freedMemory = keyType.getMemory(this.keys[index]);
        T[] newKeys = keyType.createStorage(keyCount - 1);
        DataUtil.copyExcept(this.keys, newKeys, keyCount, index);
        return new ObjectKeyManager(newKeys, this.serializedDataSize - freedMemory);
    }

    @Override
    public void write(int count2, MVMap<K, ?> map2, ByteBuf buf) {
        map2.getKeyType().write(buf, this.keys, count2);
    }

    @Override
    public int getSerializedDataSize() {
        return this.serializedDataSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "map";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "singleKey";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/mvstore/ObjectKeyManager";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

