/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore;

import java.util.BitSet;
import org.jetbrains.mvstore.DataUtil;
import org.jetbrains.mvstore.MVStoreException;

final class FreeSpaceBitSet {
    private static final boolean DETAILED_INFO = false;
    private final int firstFreeBlock;
    private final int blockSize;
    private final BitSet set = new BitSet();
    private int failureFlags;

    FreeSpaceBitSet(int firstFreeBlock, int blockSize) {
        this.firstFreeBlock = firstFreeBlock;
        this.blockSize = blockSize;
        this.clear();
    }

    public void clear() {
        this.set.clear();
        this.set.set(0, this.firstFreeBlock);
    }

    public boolean isUsed(long pos, int length) {
        int start2 = this.getBlock(pos);
        int blocks = this.getBlockCount(length);
        for (int i = start2; i < start2 + blocks; ++i) {
            if (this.set.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isFree(long pos, int length) {
        int start2 = this.getBlock(pos);
        int blocks = this.getBlockCount(length);
        for (int i = start2; i < start2 + blocks; ++i) {
            if (!this.set.get(i)) continue;
            return false;
        }
        return true;
    }

    public long allocate(int length) {
        return this.allocate(length, 0L, 0L);
    }

    long allocate(int length, long reservedLow, long reservedHigh) {
        return this.getPos(this.allocate(this.getBlockCount(length), (int)reservedLow, (int)reservedHigh, true));
    }

    long predictAllocation(int blocks, long reservedLow, long reservedHigh) {
        return this.allocate(blocks, (int)reservedLow, (int)reservedHigh, false);
    }

    boolean isFragmented() {
        return Integer.bitCount(this.failureFlags & 0xF) > 1;
    }

    private int allocate(int blocks, int reservedLow, int reservedHigh, boolean allocate) {
        int freeBlocksTotal = 0;
        int i = 0;
        while (true) {
            int start2 = this.set.nextClearBit(i);
            int end = this.set.nextSetBit(start2 + 1);
            int freeBlocks = end - start2;
            if (end < 0 || freeBlocks >= blocks) {
                if ((reservedHigh < 0 || start2 < reservedHigh) && start2 + blocks > reservedLow) {
                    if (reservedHigh < 0) {
                        start2 = this.getAfterLastBlock();
                        end = -1;
                    } else {
                        i = reservedHigh;
                        continue;
                    }
                }
                assert (this.set.nextSetBit(start2) == -1 || this.set.nextSetBit(start2) >= start2 + blocks) : "Double alloc: " + Integer.toHexString(start2) + "/" + Integer.toHexString(blocks) + " " + this;
                if (allocate) {
                    this.set.set(start2, start2 + blocks);
                } else {
                    this.failureFlags <<= 1;
                    if (end < 0 && freeBlocksTotal > 4 * blocks) {
                        this.failureFlags |= 1;
                    }
                }
                return start2;
            }
            freeBlocksTotal += freeBlocks;
            i = end;
        }
    }

    public void markUsed(long pos, int length) {
        int start2 = this.getBlock(pos);
        int blocks = this.getBlockCount(length);
        if (this.set.nextSetBit(start2) != -1 && this.set.nextSetBit(start2) < start2 + blocks) {
            throw new MVStoreException(6, "Double mark: " + Integer.toHexString(start2) + "/" + Integer.toHexString(blocks) + " " + this);
        }
        this.set.set(start2, start2 + blocks);
    }

    public void free(long pos, int length) {
        int start2 = this.getBlock(pos);
        int blocks = this.getBlockCount(length);
        assert (this.set.nextClearBit(start2) >= start2 + blocks) : "Double free: " + Integer.toHexString(start2) + "/" + Integer.toHexString(blocks) + " " + this;
        this.set.clear(start2, start2 + blocks);
    }

    private long getPos(int block) {
        return (long)block * (long)this.blockSize;
    }

    private int getBlock(long pos) {
        return (int)(pos / (long)this.blockSize);
    }

    private int getBlockCount(int length) {
        return DataUtil.roundUpInt(length, this.blockSize) / this.blockSize;
    }

    int getFillRate() {
        return this.getProjectedFillRate(0);
    }

    int getProjectedFillRate(int vacatedBlocks) {
        int totalBlocks;
        int usedBlocks;
        int cnt = 3;
        do {
            if (--cnt == 0) {
                return 100;
            }
            totalBlocks = this.set.length();
        } while ((usedBlocks = this.set.cardinality()) > totalBlocks);
        return (usedBlocks -= this.firstFreeBlock + vacatedBlocks) == 0 ? 0 : (int)((100L * (long)usedBlocks + (long)(totalBlocks -= this.firstFreeBlock) - 1L) / (long)totalBlocks);
    }

    int getFreeBlockCount() {
        return this.set.length() - this.set.cardinality();
    }

    long getFirstFree() {
        return this.getPos(this.set.nextClearBit(0));
    }

    long getLastFree() {
        return this.getPos(this.getAfterLastBlock());
    }

    int getAfterLastBlock() {
        return this.set.previousSetBit(this.set.size() - 1) + 1;
    }

    int getMovePriority(int block) {
        int freeSize;
        int prevEnd = this.set.previousClearBit(block);
        if (prevEnd < 0) {
            prevEnd = this.firstFreeBlock;
            freeSize = 0;
        } else {
            freeSize = prevEnd - this.set.previousSetBit(prevEnd);
        }
        int nextStart = this.set.nextClearBit(block);
        int nextEnd = this.set.nextSetBit(nextStart);
        if (nextEnd >= 0) {
            freeSize += nextEnd - nextStart;
        }
        return (nextStart - prevEnd - 1) * 1000 / (freeSize + 1);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append('[');
        int i = 0;
        while (true) {
            if (i > 0) {
                buff.append(", ");
            }
            int start2 = this.set.nextClearBit(i);
            buff.append(Integer.toHexString(start2)).append('-');
            int end = this.set.nextSetBit(start2 + 1);
            if (end < 0) break;
            buff.append(Integer.toHexString(end - 1));
            i = end + 1;
        }
        buff.append(']');
        return buff.toString();
    }
}

