/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore;

import org.jetbrains.mvstore.Page;

public final class CursorPos<K, V> {
    public Page<K, V> page;
    public int index;
    public CursorPos<K, V> parent;

    public CursorPos(Page<K, V> page2, int index, CursorPos<K, V> parent) {
        this.page = page2;
        this.index = index;
        this.parent = parent;
    }

    static <K, V> CursorPos<K, V> traverseDown(Page<K, V> page2, K key) {
        CursorPos<K, V> cursorPos = null;
        while (!page2.isLeaf()) {
            int index = page2.binarySearch(key) + 1;
            if (index < 0) {
                index = -index;
            }
            cursorPos = new CursorPos<K, V>(page2, index, cursorPos);
            page2 = page2.getChildPage(index);
        }
        return new CursorPos<K, V>(page2, page2.binarySearch(key), cursorPos);
    }

    int processRemovalInfo(long version) {
        int unsavedMemory = 0;
        CursorPos<K, V> head = this;
        while (head != null) {
            unsavedMemory += head.page.removePage(version);
            head = head.parent;
        }
        return unsavedMemory;
    }

    public String toString() {
        return "CursorPos{page=" + this.page + ", index=" + this.index + ", parent=" + this.parent + "}";
    }
}

