/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class NamespaceUriFunction
implements Function {
    public Object call(Context context2, List args2) throws FunctionCallException {
        if (args2.size() == 0) {
            return NamespaceUriFunction.evaluate(context2.getNodeSet(), context2.getNavigator());
        }
        if (args2.size() == 1) {
            return NamespaceUriFunction.evaluate(args2, context2.getNavigator());
        }
        throw new FunctionCallException("namespace-uri() requires zero or one argument.");
    }

    public static String evaluate(List list2, Navigator nav) throws FunctionCallException {
        if (!list2.isEmpty()) {
            Object first2 = list2.get(0);
            if (first2 instanceof List) {
                return NamespaceUriFunction.evaluate((List)first2, nav);
            }
            if (nav.isElement(first2)) {
                return nav.getElementNamespaceUri(first2);
            }
            if (nav.isAttribute(first2)) {
                String uri = nav.getAttributeNamespaceUri(first2);
                if (uri == null) {
                    return "";
                }
                return uri;
            }
            if (nav.isProcessingInstruction(first2)) {
                return "";
            }
            if (nav.isNamespace(first2)) {
                return "";
            }
            if (nav.isDocument(first2)) {
                return "";
            }
            if (nav.isComment(first2)) {
                return "";
            }
            if (nav.isText(first2)) {
                return "";
            }
            throw new FunctionCallException("The argument to the namespace-uri function must be a node-set");
        }
        return "";
    }
}

