/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatProcedure;
import gnu.trove.TPrimitiveHash;

public abstract class TFloatHash
extends TPrimitiveHash
implements TFloatHashingStrategy {
    protected transient float[] _set;
    protected final TFloatHashingStrategy _hashingStrategy;

    public TFloatHash() {
        this._hashingStrategy = this;
    }

    public TFloatHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TFloatHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TFloatHash(TFloatHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TFloatHash(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TFloatHash(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    public Object clone() {
        TFloatHash h = (TFloatHash)super.clone();
        h._set = this._set == null ? null : (float[])this._set.clone();
        return h;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = initialCapacity == -1 ? null : new float[capacity];
        return capacity;
    }

    public boolean contains(float val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TFloatProcedure procedure) {
        byte[] states = this._states;
        float[] set2 = this._set;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(set2[i])) continue;
                return false;
            }
        }
        return true;
    }

    protected void removeAt(int index) {
        this._set[index] = 0.0f;
        super.removeAt(index);
    }

    protected int index(float val) {
        byte[] states = this._states;
        if (states == null) {
            return -1;
        }
        float[] set2 = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set2[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set2[index] != val));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(float val) {
        if (this._set == null) {
            this.setUp(6);
        }
        byte[] states = this._states;
        float[] set2 = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set2[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index -= probe) >= 0) continue;
            index += length;
        } while (states[index] == 1 && set2[index] != val);
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set2[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }

    public final int computeHashCode(float val) {
        return HashFunctions.hash(val);
    }
}

