/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TByteHash;
import gnu.trove.TByteHashingStrategy;
import gnu.trove.TByteIterator;
import gnu.trove.TByteProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class TByteHashSet
extends TByteHash {
    public TByteHashSet() {
    }

    public TByteHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TByteHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TByteHashSet(byte[] array) {
        this(array.length);
        this.addAll(array);
    }

    public TByteHashSet(TByteHashingStrategy strategy) {
        super(strategy);
    }

    public TByteHashSet(int initialCapacity, TByteHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TByteHashSet(int initialCapacity, float loadFactor, TByteHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TByteHashSet(byte[] array, TByteHashingStrategy strategy) {
        this(array.length, strategy);
        this.addAll(array);
    }

    public TByteIterator iterator() {
        return new TByteIterator(this);
    }

    public boolean add(byte val) {
        int index = this.insertionIndex(val);
        if (index < 0) {
            return false;
        }
        byte previousState = this._states[index];
        this._set[index] = val;
        this._states[index] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        byte[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new byte[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            byte o = oldSet[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._states[index] = 1;
        }
    }

    public byte[] toArray() {
        byte[] result2 = new byte[this.size()];
        byte[] set2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                result2[j++] = set2[i];
            }
        }
        return result2;
    }

    public void clear() {
        super.clear();
        byte[] set2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = set2.length;
            while (i-- > 0) {
                set2[i] = 0;
                states[i] = 0;
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TByteHashSet)) {
            return false;
        }
        final TByteHashSet that = (TByteHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TByteProcedure(){

            public final boolean execute(byte value) {
                return that.contains(value);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(byte val) {
        int index = this.index(val);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsAll(byte[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(byte[] array) {
        boolean changed2 = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed2 = true;
        }
        return changed2;
    }

    public boolean removeAll(byte[] array) {
        boolean changed2 = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed2 = true;
        }
        return changed2;
    }

    public boolean retainAll(byte[] array) {
        Arrays.sort(array);
        byte[] set2 = this._set;
        byte[] states = this._states;
        boolean changed2 = false;
        if (set2 != null) {
            int i = set2.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array, set2[i]) >= 0) continue;
                this.remove(set2[i]);
                changed2 = true;
            }
        }
        return changed2;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            byte val = stream.readByte();
            this.add(val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEach(new TByteProcedure(){

            public boolean execute(byte value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(value);
                return true;
            }
        });
        sb.append(']');
        sb.insert(0, '[');
        return sb.toString();
    }

    private final class HashProcedure
    implements TByteProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(byte key) {
            this.h += TByteHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

