/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TByteHashingStrategy;
import gnu.trove.TByteProcedure;
import gnu.trove.TPrimitiveHash;

public abstract class TByteHash
extends TPrimitiveHash
implements TByteHashingStrategy {
    protected transient byte[] _set;
    protected final TByteHashingStrategy _hashingStrategy;

    public TByteHash() {
        this._hashingStrategy = this;
    }

    public TByteHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TByteHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TByteHash(TByteHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TByteHash(int initialCapacity, TByteHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TByteHash(int initialCapacity, float loadFactor, TByteHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    public Object clone() {
        TByteHash h = (TByteHash)super.clone();
        h._set = this._set == null ? null : (byte[])this._set.clone();
        return h;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = initialCapacity == -1 ? null : new byte[capacity];
        return capacity;
    }

    public boolean contains(byte val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TByteProcedure procedure) {
        byte[] states = this._states;
        byte[] set2 = this._set;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(set2[i])) continue;
                return false;
            }
        }
        return true;
    }

    protected void removeAt(int index) {
        this._set[index] = 0;
        super.removeAt(index);
    }

    protected int index(byte val) {
        byte[] states = this._states;
        if (states == null) {
            return -1;
        }
        byte[] set2 = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set2[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set2[index] != val));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(byte val) {
        if (this._set == null) {
            this.setUp(6);
        }
        byte[] states = this._states;
        byte[] set2 = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set2[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index -= probe) >= 0) continue;
            index += length;
        } while (states[index] == 1 && set2[index] != val);
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set2[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }

    public final int computeHashCode(byte val) {
        return HashFunctions.hash(val);
    }
}

