/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.workspaceModel.ide.JpsEntitySourcesKt;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.JpsImportedEntitySource;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocation;
import com.intellij.workspaceModel.ide.NonPersistentEntitySource;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ \u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0015"}, d2={"Lcom/intellij/workspaceModel/ide/impl/JpsEntitySourceFactory;", "", "()V", "createEntitySourceForArtifact", "Lcom/intellij/workspaceModel/storage/EntitySource;", "project", "Lcom/intellij/openapi/project/Project;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "createEntitySourceForModule", "baseModuleDir", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "createEntitySourceForProjectLibrary", "createJpsEntitySource", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource;", "configLocation", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "directoryLocation", "", "createJpsEntitySourceForArtifact", "createJpsEntitySourceForProjectLibrary", "intellij.platform.projectModel.impl"})
public final class JpsEntitySourceFactory {
    @NotNull
    public static final JpsEntitySourceFactory INSTANCE;

    @NotNull
    public final EntitySource createEntitySourceForModule(@NotNull Project project2, @NotNull VirtualFileUrl baseModuleDir, @Nullable ProjectModelExternalSource externalSource) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseModuleDir, (String)"baseModuleDir");
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsEntitySourcesKt.getJpsProjectConfigLocation(project2);
        if (jpsProjectConfigLocation == null) {
            return NonPersistentEntitySource.INSTANCE;
        }
        JpsProjectConfigLocation location = jpsProjectConfigLocation;
        JpsFileEntitySource.FileInDirectory internalFile = new JpsFileEntitySource.FileInDirectory(baseModuleDir, location);
        if (externalSource == null) {
            return internalFile;
        }
        JpsFileEntitySource jpsFileEntitySource = internalFile;
        String string2 = externalSource.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"externalSource.id");
        return new JpsImportedEntitySource(jpsFileEntitySource, string2, ProjectUtilCore.isExternalStorageEnabled(project2));
    }

    @NotNull
    public final EntitySource createEntitySourceForProjectLibrary(@NotNull Project project2, @Nullable ProjectModelExternalSource externalSource) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsEntitySourcesKt.getJpsProjectConfigLocation(project2);
        if (jpsProjectConfigLocation == null) {
            return NonPersistentEntitySource.INSTANCE;
        }
        JpsProjectConfigLocation location = jpsProjectConfigLocation;
        JpsFileEntitySource internalFile = this.createJpsEntitySourceForProjectLibrary(location);
        if (externalSource == null) {
            return internalFile;
        }
        String string2 = externalSource.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"externalSource.id");
        return new JpsImportedEntitySource(internalFile, string2, ProjectUtilCore.isExternalStorageEnabled(project2));
    }

    @NotNull
    public final EntitySource createEntitySourceForArtifact(@NotNull Project project2, @Nullable ProjectModelExternalSource externalSource) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsEntitySourcesKt.getJpsProjectConfigLocation(project2);
        if (jpsProjectConfigLocation == null) {
            return NonPersistentEntitySource.INSTANCE;
        }
        JpsProjectConfigLocation location = jpsProjectConfigLocation;
        JpsFileEntitySource internalFile = this.createJpsEntitySourceForArtifact(location);
        if (externalSource == null) {
            return internalFile;
        }
        String string2 = externalSource.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"externalSource.id");
        return new JpsImportedEntitySource(internalFile, string2, ProjectUtilCore.isExternalStorageEnabled(project2));
    }

    @NotNull
    public final JpsFileEntitySource createJpsEntitySourceForProjectLibrary(@NotNull JpsProjectConfigLocation configLocation) {
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        return this.createJpsEntitySource(configLocation, "libraries");
    }

    @NotNull
    public final JpsFileEntitySource createJpsEntitySourceForArtifact(@NotNull JpsProjectConfigLocation configLocation) {
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        return this.createJpsEntitySource(configLocation, "artifacts");
    }

    private final JpsFileEntitySource createJpsEntitySource(JpsProjectConfigLocation configLocation, String directoryLocation) {
        JpsFileEntitySource jpsFileEntitySource;
        JpsProjectConfigLocation jpsProjectConfigLocation = configLocation;
        if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            VirtualFileUrl virtualFileUrl = ((JpsProjectConfigLocation.DirectoryBased)configLocation).getIdeaFolder().append(directoryLocation);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"configLocation.ideaFolde\u2026append(directoryLocation)");
            jpsFileEntitySource = new JpsFileEntitySource.FileInDirectory(virtualFileUrl, configLocation);
        } else if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.FileBased) {
            jpsFileEntitySource = new JpsFileEntitySource.ExactFile(((JpsProjectConfigLocation.FileBased)configLocation).getIprFile(), configLocation);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jpsFileEntitySource;
    }

    private JpsEntitySourceFactory() {
    }

    static {
        JpsEntitySourceFactory jpsEntitySourceFactory;
        INSTANCE = jpsEntitySourceFactory = new JpsEntitySourceFactory();
    }
}

