/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OptionTagBinding
extends BasePrimitiveBinding {
    private final String myTagName;
    private final String myNameAttribute;
    private final String myValueAttribute;

    OptionTagBinding(@NotNull MutableAccessor accessor, @Nullable OptionTag optionTag) {
        if (accessor == null) {
            OptionTagBinding.$$$reportNull$$$0(0);
        }
        super(accessor, optionTag == null ? null : optionTag.value(), optionTag == null ? null : optionTag.converter());
        if (optionTag == null) {
            this.myTagName = "option";
            this.myNameAttribute = "name";
            this.myValueAttribute = "value";
        } else {
            this.myNameAttribute = StringUtil.internEmptyString(optionTag.nameAttribute());
            this.myValueAttribute = StringUtil.internEmptyString(optionTag.valueAttribute());
            String tagName = optionTag.tag();
            if (StringUtil.isEmpty(this.myNameAttribute) && "option".equals(tagName)) {
                tagName = this.myAccessor.getName();
            }
            this.myTagName = tagName;
        }
    }

    @Override
    @NotNull
    public Object serialize(@NotNull Object o, @Nullable SerializationFilter filter2) {
        if (o == null) {
            OptionTagBinding.$$$reportNull$$$0(1);
        }
        Object value = this.myAccessor.read(o);
        Element targetElement = new Element(this.myTagName);
        if (!StringUtil.isEmpty(this.myNameAttribute)) {
            targetElement.setAttribute(this.myNameAttribute, this.name);
        }
        if (value == null) {
            Element element2 = targetElement;
            if (element2 == null) {
                OptionTagBinding.$$$reportNull$$$0(2);
            }
            return element2;
        }
        Converter<Object> converter = this.getConverter();
        if (converter == null) {
            if (this.myBinding == null) {
                targetElement.setAttribute(this.myValueAttribute, JDOMUtil.removeControlChars(XmlSerializerImpl.convertToString(value)));
            } else if (this.myBinding instanceof BeanBinding && this.myValueAttribute.isEmpty()) {
                ((BeanBinding)this.myBinding).serializeInto(value, targetElement, filter2);
            } else {
                Object node2 = this.myBinding.serialize(value, targetElement, filter2);
                if (node2 != null && targetElement != node2) {
                    Binding.addContent(targetElement, node2);
                }
            }
        } else {
            String text2 = converter.toString(value);
            if (text2 != null) {
                targetElement.setAttribute(this.myValueAttribute, JDOMUtil.removeControlChars(text2));
            }
        }
        Element element3 = targetElement;
        if (element3 == null) {
            OptionTagBinding.$$$reportNull$$$0(3);
        }
        return element3;
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context2, @NotNull Element element2) {
        Attribute valueAttribute;
        if (context2 == null) {
            OptionTagBinding.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            OptionTagBinding.$$$reportNull$$$0(5);
        }
        if ((valueAttribute = element2.getAttribute(this.myValueAttribute)) == null) {
            if (this.myValueAttribute.isEmpty()) {
                assert (this.myBinding != null);
                this.myAccessor.set(context2, this.myBinding.deserializeUnsafe(context2, element2));
            } else {
                List<Element> children2 = element2.getChildren();
                if (children2.isEmpty()) {
                    if (this.myBinding instanceof CollectionBinding || this.myBinding instanceof MapBinding) {
                        Object newValue;
                        Object oldValue = this.myAccessor.read(context2);
                        if (oldValue != null && oldValue != (newValue = ((MultiNodeBinding)this.myBinding).deserializeList(oldValue, children2))) {
                            this.myAccessor.set(context2, newValue);
                        }
                    } else {
                        this.myAccessor.set(context2, null);
                    }
                } else {
                    Object newValue;
                    assert (this.myBinding != null);
                    Object oldValue = this.myAccessor.read(context2);
                    if (oldValue != (newValue = Binding.deserializeList(this.myBinding, oldValue, children2))) {
                        this.myAccessor.set(context2, newValue);
                    }
                }
            }
        } else {
            String value = valueAttribute.getValue();
            if (this.myConverter == null) {
                try {
                    XmlSerializerImpl.doSet(context2, value, this.myAccessor, ClassUtil.typeToClass(this.myAccessor.getGenericType()));
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot set value for field " + this.name, e);
                }
            } else {
                this.myAccessor.set(context2, this.myConverter.fromString(value));
            }
        }
        Object object = context2;
        if (object == null) {
            OptionTagBinding.$$$reportNull$$$0(6);
        }
        return object;
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context2, @NotNull XmlElement element2) {
        String value;
        if (context2 == null) {
            OptionTagBinding.$$$reportNull$$$0(7);
        }
        if (element2 == null) {
            OptionTagBinding.$$$reportNull$$$0(8);
        }
        if ((value = element2.getAttributeValue(this.myValueAttribute)) == null) {
            if (this.myValueAttribute.isEmpty()) {
                assert (this.myBinding != null);
                this.myAccessor.set(context2, this.myBinding.deserializeUnsafe(context2, element2));
            } else {
                List children2 = element2.children;
                if (children2.isEmpty()) {
                    if (this.myBinding instanceof CollectionBinding || this.myBinding instanceof MapBinding) {
                        Object newValue;
                        Object oldValue = this.myAccessor.read(context2);
                        if (oldValue != null && oldValue != (newValue = ((MultiNodeBinding)this.myBinding).deserializeList2(oldValue, children2))) {
                            this.myAccessor.set(context2, newValue);
                        }
                    } else {
                        this.myAccessor.set(context2, null);
                    }
                } else {
                    Object newValue;
                    assert (this.myBinding != null);
                    Object oldValue = this.myAccessor.read(context2);
                    if (oldValue != (newValue = Binding.deserializeList2(this.myBinding, oldValue, children2))) {
                        this.myAccessor.set(context2, newValue);
                    }
                }
            }
        } else if (this.myConverter == null) {
            try {
                XmlSerializerImpl.doSet(context2, value, this.myAccessor, ClassUtil.typeToClass(this.myAccessor.getGenericType()));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot set value for field " + this.name, e);
            }
        } else {
            this.myAccessor.set(context2, this.myConverter.fromString(value));
        }
        Object object = context2;
        if (object == null) {
            OptionTagBinding.$$$reportNull$$$0(9);
        }
        return object;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element2) {
        if (element2 == null) {
            OptionTagBinding.$$$reportNull$$$0(10);
        }
        if (!element2.getName().equals(this.myTagName)) {
            return false;
        }
        String name2 = element2.getAttributeValue(this.myNameAttribute);
        if (StringUtil.isEmpty(this.myNameAttribute)) {
            return name2 == null || name2.equals(this.name);
        }
        return name2 != null && name2.equals(this.name);
    }

    @Override
    public boolean isBoundTo(@NotNull XmlElement element2) {
        if (element2 == null) {
            OptionTagBinding.$$$reportNull$$$0(11);
        }
        if (!element2.name.equals(this.myTagName)) {
            return false;
        }
        String name2 = element2.getAttributeValue(this.myNameAttribute);
        if (StringUtil.isEmpty(this.myNameAttribute)) {
            return name2 == null || name2.equals(this.name);
        }
        return name2 != null && name2.equals(this.name);
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.name + ", binding=" + this.myBinding + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/OptionTagBinding";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/OptionTagBinding";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

