/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J`\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0002R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006+"}, d2={"Lcom/intellij/util/ui/WrapLayout;", "Ljava/awt/FlowLayout;", "()V", "align", "", "(I)V", "hgap", "vgap", "(III)V", "fillWidth", "", "getFillWidth", "()Z", "setFillWidth", "(Z)V", "addRow", "", "dim", "Ljava/awt/Dimension;", "rowWidth", "rowHeight", "layoutContainer", "target", "Ljava/awt/Container;", "layoutSize", "preferred", "minimumLayoutSize", "moveComponents", "_x", "y", "width", "_height", "rowStart", "rowEnd", "ltr", "useBaseline", "ascent", "", "descent", "preferredLayoutSize", "preferredSize", "m", "Ljava/awt/Component;", "intellij.platform.util.ui"})
public class WrapLayout
extends FlowLayout {
    private boolean fillWidth;

    public final boolean getFillWidth() {
        return this.fillWidth;
    }

    public final void setFillWidth(boolean bl) {
        this.fillWidth = bl;
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        return this.layoutSize(target2, true);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Dimension minimum = this.layoutSize(target2, false);
        minimum.width -= this.getHgap() + 1;
        return minimum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Dimension layoutSize(Container target2, boolean preferred) {
        Object object;
        Object object2 = target2.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"target.treeLock");
        Object object3 = object = object2;
        synchronized (object3) {
            boolean bl = false;
            Container container = target2;
            while (container.getSize().width == 0 && container.getParent() != null) {
                Intrinsics.checkNotNullExpressionValue((Object)container.getParent(), (String)"container.parent");
            }
            int targetWidth = container.getSize().width;
            if (targetWidth == 0) {
                targetWidth = Integer.MAX_VALUE;
            }
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = target2.getInsets();
            int horizontalInsetsAndGap = insets.left + insets.right + hgap * 2;
            int maxWidth = targetWidth - horizontalInsetsAndGap;
            Dimension dim = new Dimension(0, 0);
            int rowWidth = 0;
            int rowHeight = 0;
            int nmembers = target2.getComponentCount();
            int n = 0;
            int n2 = nmembers;
            while (n < n2) {
                void i;
                Component m;
                Component component2 = m = target2.getComponent((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"m");
                if (component2.isVisible()) {
                    Dimension d;
                    Dimension dimension = d = preferred ? this.preferredSize(m) : m.getMinimumSize();
                    if (rowWidth + hgap + d.width > maxWidth) {
                        this.addRow(dim, rowWidth, rowHeight);
                        rowWidth = 0;
                        rowHeight = 0;
                    }
                    if (rowWidth != 0) {
                        rowWidth += hgap;
                    }
                    rowWidth += d.width;
                    int n3 = d.height;
                    rowHeight = Math.max(rowHeight, n3);
                }
                ++i;
            }
            this.addRow(dim, rowWidth, rowHeight);
            dim.width += horizontalInsetsAndGap;
            dim.height += insets.top + insets.bottom + vgap * 2;
            Container scrollPane = SwingUtilities.getAncestorOfClass(JScrollPane.class, target2);
            if (scrollPane != null && target2.isValid()) {
                dim.width -= hgap + 1;
            }
            n2 = dim.width;
            dim.width = Math.min(n2, maxWidth);
            Dimension dimension = dim;
            return dimension;
        }
    }

    private final void addRow(Dimension dim, int rowWidth, int rowHeight) {
        int n = dim.width;
        dim.width = Math.max(n, rowWidth);
        if (dim.height > 0) {
            dim.height += this.getVgap();
        }
        dim.height += rowHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void layoutContainer(@NotNull Container target2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Object object2 = target2.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"target.treeLock");
        Object object3 = object = object2;
        synchronized (object3) {
            boolean bl = false;
            Insets insets = target2.getInsets();
            int maxwidth = target2.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
            int nmembers = target2.getComponentCount();
            int x = 0;
            int y = insets.top + this.getVgap();
            int rowh = 0;
            int start2 = 0;
            ComponentOrientation componentOrientation = target2.getComponentOrientation();
            Intrinsics.checkNotNullExpressionValue((Object)componentOrientation, (String)"target.componentOrientation");
            boolean ltr = componentOrientation.isLeftToRight();
            boolean useBaseline = this.getAlignOnBaseline();
            int[] ascent = new int[nmembers];
            int[] descent = new int[nmembers];
            int n = 0;
            int n2 = nmembers;
            while (n < n2) {
                void i;
                Component m;
                Component component2 = m = target2.getComponent((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"m");
                if (component2.isVisible()) {
                    Dimension d = this.preferredSize(m);
                    m.setSize(d.width, d.height);
                    if (useBaseline) {
                        int baseline = m.getBaseline(d.width, d.height);
                        if (baseline >= 0) {
                            ascent[i] = baseline;
                            descent[i] = d.height - baseline;
                        } else {
                            ascent[i] = -1;
                        }
                    }
                    if (x == 0 || x + d.width <= maxwidth) {
                        x += d.width + this.getHgap();
                        int n3 = d.height;
                        rowh = Math.max(rowh, n3);
                    } else {
                        rowh = this.moveComponents(target2, insets.left + this.getHgap(), y, maxwidth - x, rowh, start2, (int)i, ltr, useBaseline, ascent, descent);
                        x = d.width + this.getHgap();
                        y += this.getVgap() + rowh;
                        rowh = d.height;
                        start2 = i;
                    }
                }
                ++i;
            }
            int n4 = this.moveComponents(target2, insets.left + this.getHgap(), y, maxwidth - x, rowh, start2, nmembers, ltr, useBaseline, ascent, descent);
        }
    }

    private final Dimension preferredSize(Component m) {
        int n = m.getPreferredSize().width;
        int n2 = m.getMinimumSize().width;
        int n3 = Math.max(n, n2);
        n = m.getPreferredSize().height;
        n2 = m.getMinimumSize().height;
        return new Dimension(n3, Math.max(n, n2));
    }

    /*
     * WARNING - void declaration
     */
    private final int moveComponents(Container target2, int _x, int y, int width, int _height, int rowStart, int rowEnd, boolean ltr, boolean useBaseline, int[] ascent, int[] descent) {
        int n;
        int n2;
        int x = _x;
        int height = _height;
        switch (this.getAlignment()) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                x += width;
            }
        }
        int maxAscent = 0;
        int nonBaselineHeight = 0;
        int baselineOffset = 0;
        if (useBaseline) {
            int maxDescent = 0;
            int n3 = rowStart;
            int n4 = rowEnd;
            while (n3 < n4) {
                void i;
                Component m;
                Component component2 = m = target2.getComponent((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"m");
                if (component2.isVisible()) {
                    if (ascent[i] >= 0) {
                        n2 = ascent[i];
                        maxAscent = Math.max(maxAscent, n2);
                        n2 = descent[i];
                        maxDescent = Math.max(maxDescent, n2);
                    } else {
                        n2 = m.getHeight();
                        nonBaselineHeight = Math.max(n2, nonBaselineHeight);
                    }
                }
                ++i;
            }
            n3 = maxAscent + maxDescent;
            height = Math.max(n3, nonBaselineHeight);
            baselineOffset = (height - maxAscent - maxDescent) / 2;
        }
        double expand = 1.0;
        if (this.fillWidth) {
            double sum = 0.0;
            n2 = rowStart;
            int n5 = rowEnd;
            while (n2 < n5) {
                void i;
                Component m;
                Component component3 = m = target2.getComponent((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"m");
                if (component3.isVisible()) {
                    int n6 = m.getPreferredSize().width;
                    n = m.getMinimumSize().width;
                    sum += (double)Math.max(n6, n);
                }
                ++i;
            }
            expand = (double)target2.getWidth() / sum;
        }
        int sum = rowStart;
        int n7 = rowEnd;
        while (sum < n7) {
            void i;
            Component m;
            Component component4 = m = target2.getComponent((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)component4, (String)"m");
            if (component4.isVisible()) {
                int w;
                int n8;
                int cy;
                int n9 = cy = useBaseline && ascent[i] >= 0 ? y + baselineOffset + maxAscent - ascent[i] : y + (height - m.getHeight()) / 2;
                if (this.fillWidth) {
                    int n10 = m.getPreferredSize().width;
                    n = m.getMinimumSize().width;
                    double d = (double)Math.max(n10, n) * expand;
                    n8 = (int)Math.floor(d);
                } else {
                    n8 = w = m.getWidth();
                }
                if (ltr) {
                    m.setBounds(x, cy, w, m.getHeight());
                } else {
                    m.setBounds(target2.getWidth() - x - w, cy, w, m.getHeight());
                }
                x += m.getWidth() + this.getHgap();
            }
            ++i;
        }
        return height;
    }

    public WrapLayout() {
    }

    public WrapLayout(int align) {
        super(align);
    }

    public WrapLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }
}

