/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.SplitByLetterPolicy;
import com.intellij.util.ui.SplitBySeparatorPolicy;
import java.awt.FontMetrics;
import java.io.File;
import javax.swing.JComponent;

public abstract class FilePathSplittingPolicy {
    public static final FilePathSplittingPolicy SPLIT_BY_LETTER = new SplitByLetterPolicy();
    public static final FilePathSplittingPolicy SPLIT_BY_SEPARATOR = new SplitBySeparatorPolicy();

    @NlsSafe
    public abstract String getPresentableName(File var1, int var2);

    @NlsSafe
    public String getOptimalTextForComponent(String staticPrefix, File file2, JComponent component2, int width) {
        FontMetrics fontMetrics = component2.getFontMetrics(component2.getFont());
        String path2 = file2.getPath();
        for (int i = 1; i <= path2.length(); ++i) {
            String text2 = this.getPresentableName(file2, i);
            if (fontMetrics.stringWidth(staticPrefix + text2) <= width) continue;
            if (i == 1) {
                return text2;
            }
            return this.getPresentableName(file2, i - 1);
        }
        return path2;
    }

    @NlsSafe
    public String getOptimalTextForComponent(File file2, JComponent component2, int width) {
        return this.getOptimalTextForComponent("", file2, component2, width);
    }

    @NlsSafe
    public String getOptimalTextForComponent(File file2, JComponent component2) {
        return this.getOptimalTextForComponent(file2, component2, component2.getWidth());
    }
}

