/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ReflectionUtil;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class EdtInvocationManager {
    private static final AtomicReference<EdtInvocationManager> ourInstance = new AtomicReference();
    private static MethodHandle dispatchEventMethod;

    @TestOnly
    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        assert (EdtInvocationManager.getInstance().isEventDispatchThread()) : Thread.currentThread() + "; EDT: " + EdtInvocationManager.getEventQueueThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        MethodHandle dispatchEventMethod = EdtInvocationManager.dispatchEventMethod;
        if (dispatchEventMethod == null) {
            try {
                Method method2 = EventQueue.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                method2.setAccessible(true);
                dispatchEventMethod = MethodHandles.lookup().unreflect(method2);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException();
            }
            EdtInvocationManager.dispatchEventMethod = dispatchEventMethod;
        }
        boolean threadsDumped = false;
        int i = 1;
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (event instanceof InvocationEvent) {
                    dispatchEventMethod.bindTo(eventQueue).invoke(event);
                }
            }
            catch (Throwable e) {
                ExceptionUtilRt.rethrowUnchecked(e);
                throw new RuntimeException(e);
            }
            if (i % 10000 == 0) {
                System.out.println("Suspiciously many (" + i + ") AWT events, last dispatched " + event);
                if (!threadsDumped) {
                    threadsDumped = true;
                    try {
                        Object application = ReflectionUtil.getMethod(Class.forName("com.intellij.openapi.application.ApplicationManager"), "getApplication", new Class[0]).invoke(null, new Object[0]);
                        System.err.println("Application=" + application + "\n" + ThreadDumper.dumpThreadsToString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ++i;
        }
    }

    @NotNull
    private static Thread getEventQueueThread() {
        Thread thread;
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method2 = ReflectionUtil.getDeclaredMethod(EventQueue.class, "getDispatchThread", new Class[0]);
            thread = (Thread)method2.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (thread == null) {
            EdtInvocationManager.$$$reportNull$$$0(0);
        }
        return thread;
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        EdtInvocationManager edtInvocationManager;
        if (runnable == null) {
            EdtInvocationManager.$$$reportNull$$$0(1);
        }
        if ((edtInvocationManager = EdtInvocationManager.getInstance()).isEventDispatchThread()) {
            runnable.run();
        } else {
            edtInvocationManager.invokeLater(runnable);
        }
    }

    public abstract boolean isEventDispatchThread();

    public abstract void invokeLater(@NotNull Runnable var1);

    public abstract void invokeAndWait(@NotNull Runnable var1) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static EdtInvocationManager getInstance() {
        EdtInvocationManager result2 = ourInstance.get();
        if (result2 == null && !ourInstance.compareAndSet(null, result2 = new SwingEdtInvocationManager())) {
            result2 = ourInstance.get();
        }
        EdtInvocationManager edtInvocationManager = result2;
        if (edtInvocationManager == null) {
            EdtInvocationManager.$$$reportNull$$$0(2);
        }
        return edtInvocationManager;
    }

    @Nullable
    public static EdtInvocationManager setEdtInvocationManager(@NotNull EdtInvocationManager edtInvocationManager) {
        if (edtInvocationManager == null) {
            EdtInvocationManager.$$$reportNull$$$0(3);
        }
        return ourInstance.getAndSet(edtInvocationManager);
    }

    @ApiStatus.Internal
    public static void restoreEdtInvocationManager(@NotNull EdtInvocationManager current, @Nullable EdtInvocationManager old) {
        if (current == null) {
            EdtInvocationManager.$$$reportNull$$$0(4);
        }
        ourInstance.compareAndSet(current, old);
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        EdtInvocationManager manager;
        if (runnable == null) {
            EdtInvocationManager.$$$reportNull$$$0(5);
        }
        if ((manager = EdtInvocationManager.getInstance()).isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                manager.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.getInstance(EdtInvocationManager.class).error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/EdtInvocationManager";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtInvocationManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventQueueThread";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/EdtInvocationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEdtInvocationManager";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreEdtInvocationManager";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        @Override
        public boolean isEventDispatchThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        public void invokeLater(@NotNull Runnable task2) {
            if (task2 == null) {
                SwingEdtInvocationManager.$$$reportNull$$$0(0);
            }
            EventQueue.invokeLater(task2);
        }

        @Override
        public void invokeAndWait(@NotNull Runnable task2) throws InvocationTargetException, InterruptedException {
            if (task2 == null) {
                SwingEdtInvocationManager.$$$reportNull$$$0(1);
            }
            EventQueue.invokeAndWait(task2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "task";
            objectArray2[1] = "com/intellij/util/ui/EdtInvocationManager$SwingEdtInvocationManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeLater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeAndWait";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

