/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;

public abstract class ComboBoxCellEditor
extends DefaultCellEditor {
    public ComboBoxCellEditor() {
        super(new JComboBox());
        this.setClickCountToStart(2);
    }

    protected abstract List<String> getComboBoxItems();

    protected boolean isComboboxEditable() {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        JComboBox comboBox = (JComboBox)this.editorComponent;
        comboBox.removeActionListener(this.delegate);
        boolean result2 = super.stopCellEditing();
        comboBox.addActionListener(this.delegate);
        return result2;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String currentValue = (String)value;
        JComboBox component2 = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        component2.removeActionListener(this.delegate);
        component2.setBorder(null);
        component2.removeAllItems();
        List<String> items = this.getComboBoxItems();
        int selected = -1;
        for (int i = 0; i < items.size(); ++i) {
            String item = items.get(i);
            component2.addItem(item);
            if (!Objects.equals(item, currentValue)) continue;
            selected = i;
        }
        if (selected == -1) {
            component2.setEditable(true);
            component2.setSelectedItem(currentValue);
            component2.setEditable(false);
        } else {
            component2.setSelectedIndex(selected);
        }
        component2.setEditable(this.isComboboxEditable());
        component2.addActionListener(this.delegate);
        return component2;
    }
}

