/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.impl.DirectorySpecBase;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/util/io/impl/ZipSpec;", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "()V", "generate", "", "target", "Ljava/io/File;", "generateInTempDir", "Ljava/nio/file/Path;", "intellij.platform.testFramework"})
public final class ZipSpec
extends DirectorySpecBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@NotNull File target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        File file2 = FileUtil.createTempDirectory("zip-content", null, false);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempDirec\u2026ip-content\", null, false)");
        File contentDir = file2;
        try {
            this.generateInDirectory(contentDir);
            FileUtil.createParentDirs(target2);
            Closeable closeable = new Compressor.Zip(target2);
            Throwable throwable = null;
            try {
                Compressor.Zip it = (Compressor.Zip)closeable;
                boolean bl = false;
                it.addDirectory(contentDir);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        finally {
            FileUtil.delete(contentDir);
        }
    }

    @Override
    @NotNull
    public Path generateInTempDir() {
        File file2 = FileUtil.createTempFile("zip-by-spec", ".zip", true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempFile(\u2026p-by-spec\", \".zip\", true)");
        File target2 = file2;
        this.generate(target2);
        Path path2 = target2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"target.toPath()");
        return path2;
    }

    public ZipSpec() {
        super(null, null);
    }
}

