/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.TestFileSystemBuilder;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class TestFileSystemItem {
    private final boolean myDirectory;
    private final boolean myArchive;
    private final String myName;
    @Nullable
    private final String myContent;
    private final Map<String, TestFileSystemItem> myChildren = new HashMap<String, TestFileSystemItem>();

    TestFileSystemItem(String name2, boolean archive, boolean directory, @Nullable String content2) {
        this.myDirectory = directory;
        this.myArchive = archive;
        this.myName = name2;
        this.myContent = content2;
    }

    TestFileSystemItem(String name2, boolean archive, boolean directory) {
        this(name2, archive, directory, null);
    }

    void addChild(TestFileSystemItem item) {
        Assert.assertFalse((String)(item.myName + " already added"), (boolean)this.myChildren.containsKey(item.myName));
        this.myChildren.put(item.myName, item);
    }

    public void assertDirectoryEqual(File file2) {
        this.assertDirectoryEqual(file2, "/");
    }

    public void assertFileEqual(File file2) {
        TestFileSystemItem fileItem = this.myChildren.values().iterator().next();
        fileItem.assertFileEqual(file2, "/");
    }

    private void assertDirectoryEqual(File file2, String relativePath) {
        File[] actualChildren = file2.listFiles();
        HashSet<String> notFound = new HashSet<String>(this.myChildren.keySet());
        if (actualChildren != null) {
            for (File child : actualChildren) {
                String name2 = child.getName();
                TestFileSystemItem item = this.myChildren.get(name2);
                if (item == null) {
                    throw new AssertionError((Object)("unexpected file: " + relativePath + name2));
                }
                item.assertFileEqual(child, relativePath + name2 + "/");
                notFound.remove(name2);
            }
        }
        Assert.assertTrue((String)("files " + ((Object)notFound).toString() + " not found in " + relativePath), (boolean)notFound.isEmpty());
    }

    private void assertFileEqual(File file2, String relativePath) {
        try {
            Assert.assertEquals((String)("in " + relativePath), (Object)this.myName, (Object)file2.getName());
            if (this.myArchive) {
                File dirForExtracted = FileUtil.createTempDirectory("extracted_archive", null, false);
                ZipUtil.extract(file2, dirForExtracted, null);
                this.assertDirectoryEqual(dirForExtracted, relativePath);
                FileUtil.delete(dirForExtracted);
            } else if (this.myDirectory) {
                Assert.assertTrue((String)(relativePath + file2.getName() + " is not a directory"), (boolean)file2.isDirectory());
                this.assertDirectoryEqual(file2, relativePath);
            } else if (this.myContent != null) {
                String content2 = FileUtil.loadFile(file2);
                Assert.assertEquals((String)("content mismatch for " + relativePath), (Object)this.myContent, (Object)content2);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TestFileSystemBuilder fs() {
        return TestFileSystemBuilder.fs();
    }
}

