/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b\u001a\u0010\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a\u0010\u0010\u0013\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a6\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u00072\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0019\u001a\f\u0010\u001a\u001a\u0004\u0018\u00010\u0012*\u00020\b\u001a\u0012\u0010\u001b\u001a\u00020\b*\u00020\b2\u0006\u0010\u001c\u001a\u00020\b\u001a\u0012\u0010\u001d\u001a\u00020\u001e*\u00020\b2\u0006\u0010\u001c\u001a\u00020\b\u001a\n\u0010\u001f\u001a\u00020\b*\u00020\b\u001a\n\u0010 \u001a\u00020\b*\u00020\b\u001a\u0012\u0010!\u001a\u00020\b*\u00020\b2\u0006\u0010\u001c\u001a\u00020\b\u001a\u0016\u0010\"\u001a\u00020\u001e*\u00020\b2\b\b\u0002\u0010#\u001a\u00020\u0007H\u0007\u001a\u0012\u0010$\u001a\u00020\u001e*\u00020\b2\u0006\u0010%\u001a\u00020\u000b\u001a\u001c\u0010&\u001a\u00020\u0007*\u00020\b2\u0006\u0010'\u001a\u00020\b2\b\b\u0002\u0010(\u001a\u00020\u0007\u001ak\u0010)\u001a\u0004\u0018\u0001H*\"\u0004\b\u0000\u0010**\u00020\b2#\b\b\u0010+\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b-\u0012\b\b\u0015\u0012\u0004\b\b(.\u0012\u0004\u0012\u00020\u00070,2'\u0010/\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\b00\u00a2\u0006\f\b-\u0012\b\b\u0015\u0012\u0004\b\b(1\u0012\u0004\u0012\u0002H*0,H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102\u001aF\u0010)\u001a\u0004\u0018\u0001H*\"\u0004\b\u0000\u0010**\u00020\b2'\u0010/\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\b00\u00a2\u0006\f\b-\u0012\b\b\u0015\u0012\u0004\b\b(1\u0012\u0004\u0012\u0002H*0,H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103\u001a\n\u00104\u001a\u00020\u0007*\u00020\b\u001a\n\u00105\u001a\u000206*\u00020\b\u001a\f\u00107\u001a\u0004\u0018\u000106*\u00020\b\u001a\u0012\u00108\u001a\u00020\u0007*\u00020\b2\u0006\u00109\u001a\u00020\b\u001a\n\u0010\u0010\u001a\u00020\u0007*\u00020\b\u001a\n\u0010(\u001a\u00020\u0007*\u00020\b\u001a\n\u0010:\u001a\u00020\u0007*\u00020\b\u001a\n\u0010;\u001a\u00020<*\u00020\b\u001a\u0012\u0010=\u001a\u00020\b*\u00020\b2\u0006\u0010\u001c\u001a\u00020\b\u001a\u0016\u0010>\u001a\u00020?*\u00020\b2\b\b\u0002\u0010@\u001a\u00020\u0007H\u0007\u001a\n\u0010A\u001a\u00020B*\u00020\b\u001a\n\u0010C\u001a\u00020D*\u00020\b\u001a\n\u0010E\u001a\u00020\u000b*\u00020\b\u001a\n\u0010F\u001a\u00020?*\u00020\b\u001a\n\u0010G\u001a\u00020H*\u00020\b\u001a\n\u0010I\u001a\u00020H*\u00020\b\u001a\u001c\u0010J\u001a\u00020\b*\u00020\b2\u0006\u0010K\u001a\u00020L2\b\b\u0002\u0010M\u001a\u00020\u0007\u001a(\u0010J\u001a\u00020\b*\u00020\b2\u0006\u0010K\u001a\u00020B2\b\b\u0002\u0010N\u001a\u00020O2\b\b\u0002\u0010G\u001a\u00020OH\u0007\u001a(\u0010J\u001a\u00020\b*\u00020\b2\u0006\u0010K\u001a\u00020D2\b\b\u0002\u0010P\u001a\u00020Q2\b\b\u0002\u0010M\u001a\u00020\u0007H\u0007\u001a\u001a\u0010R\u001a\u00020\b*\u00020\b2\u0006\u0010S\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020B\u001a\u001a\u0010R\u001a\u00020\b*\u00020\b2\u0006\u0010S\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\u000b\"\"\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006T"}, d2={"illegalChars", "Ljava/util/HashSet;", "", "kotlin.jvm.PlatformType", "getIllegalChars$annotations", "()V", "isWritable", "", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Z", "systemIndependentPath", "", "getSystemIndependentPath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "generateRandomPath", "parentDirectory", "isDirectory", "attributes", "Ljava/nio/file/attribute/BasicFileAttributes;", "isSymbolicLink", "sanitizeFileName", "name", "replacement", "truncateIfNeeded", "extraIllegalChars", "Ljava/util/function/Predicate;", "basicAttributesIfExists", "copy", "target", "copyRecursively", "", "createDirectories", "createFile", "createSymbolicLink", "delete", "recursively", "deleteChildrenStartingWith", "prefix", "deleteWithParentsIfEmpty", "root", "isFile", "directoryStreamIfExists", "R", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "path", "task", "Ljava/nio/file/DirectoryStream;", "stream", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exists", "inputStream", "Ljava/io/InputStream;", "inputStreamIfExists", "isAncestor", "child", "isHidden", "lastModified", "Ljava/nio/file/attribute/FileTime;", "move", "outputStream", "Ljava/io/OutputStream;", "append", "readBytes", "", "readChars", "", "readText", "safeOutputStream", "size", "", "sizeOrNull", "write", "data", "Ljava/nio/ByteBuffer;", "createParentDirs", "offset", "", "charset", "Ljava/nio/charset/Charset;", "writeChild", "relativePath", "intellij.platform.util.ex"})
public final class PathKt {
    private static final HashSet<Character> illegalChars = new HashSet(List.of(Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('?'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('*'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf(':')));

    public static final boolean exists(@NotNull Path $this$exists) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"$this$exists");
        return Files.exists($this$exists, new LinkOption[0]);
    }

    @NotNull
    public static final Path createDirectories(@NotNull Path $this$createDirectories) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectories, (String)"$this$createDirectories");
        Path path2 = NioFiles.createDirectories($this$createDirectories);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"NioFiles.createDirectories(this)");
        return path2;
    }

    @JvmOverloads
    @NotNull
    public static final OutputStream outputStream(@NotNull Path $this$outputStream, boolean append) {
        Intrinsics.checkNotNullParameter((Object)$this$outputStream, (String)"$this$outputStream");
        Path path2 = $this$outputStream.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        if (append) {
            OutputStream outputStream = Files.newOutputStream($this$outputStream, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"Files.newOutputStream(th\u2026tandardOpenOption.CREATE)");
            return outputStream;
        }
        OutputStream outputStream = Files.newOutputStream($this$outputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"Files.newOutputStream(this)");
        return outputStream;
    }

    public static /* synthetic */ OutputStream outputStream$default(Path path2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return PathKt.outputStream(path2, bl);
    }

    @JvmOverloads
    @NotNull
    public static final OutputStream outputStream(@NotNull Path $this$outputStream) {
        return PathKt.outputStream$default($this$outputStream, false, 1, null);
    }

    @NotNull
    public static final OutputStream safeOutputStream(@NotNull Path $this$safeOutputStream) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$safeOutputStream, (String)"$this$safeOutputStream");
            Path path2 = $this$safeOutputStream.getParent();
            if (path2 == null) break block0;
            PathKt.createDirectories(path2);
        }
        return new SafeFileOutputStream($this$safeOutputStream);
    }

    @NotNull
    public static final InputStream inputStream(@NotNull Path $this$inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$inputStream, (String)"$this$inputStream");
        InputStream inputStream = Files.newInputStream($this$inputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(this)");
        return inputStream;
    }

    @Nullable
    public static final InputStream inputStreamIfExists(@NotNull Path $this$inputStreamIfExists) {
        Intrinsics.checkNotNullParameter((Object)$this$inputStreamIfExists, (String)"$this$inputStreamIfExists");
        try {
            return PathKt.inputStream($this$inputStreamIfExists);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @NotNull
    public static final Path createSymbolicLink(@NotNull Path $this$createSymbolicLink, @NotNull Path target2) {
        Intrinsics.checkNotNullParameter((Object)$this$createSymbolicLink, (String)"$this$createSymbolicLink");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Path path2 = $this$createSymbolicLink.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Files.createSymbolicLink($this$createSymbolicLink, target2, new FileAttribute[0]);
        return $this$createSymbolicLink;
    }

    @JvmOverloads
    public static final void delete(@NotNull Path $this$delete, boolean recursively) {
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$this$delete");
        if (recursively) {
            NioFiles.deleteRecursively($this$delete);
            return;
        }
        Files.delete($this$delete);
    }

    public static /* synthetic */ void delete$default(Path path2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        PathKt.delete(path2, bl);
    }

    @JvmOverloads
    public static final void delete(@NotNull Path $this$delete) {
        PathKt.delete$default($this$delete, false, 1, null);
    }

    public static final boolean deleteWithParentsIfEmpty(@NotNull Path $this$deleteWithParentsIfEmpty, @NotNull Path root, boolean isFile) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteWithParentsIfEmpty, (String)"$this$deleteWithParentsIfEmpty");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        try {
            PathKt.delete$default($this$deleteWithParentsIfEmpty, false, 1, null);
        }
        catch (NoSuchFileException e) {
            return false;
        }
        for (Path parent = isFile ? $this$deleteWithParentsIfEmpty.getParent() : null; parent != null && Intrinsics.areEqual((Object)parent, (Object)root) ^ true; parent = parent.getParent()) {
            try {
                Files.delete(parent);
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean deleteWithParentsIfEmpty$default(Path path2, Path path3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PathKt.deleteWithParentsIfEmpty(path2, path3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void deleteChildrenStartingWith(@NotNull Path $this$deleteChildrenStartingWith, @NotNull String prefix) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)$this$deleteChildrenStartingWith, (String)"$this$deleteChildrenStartingWith");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Path path2 = $this$deleteChildrenStartingWith;
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(prefix){
            final /* synthetic */ String $prefix;

            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)this.$prefix, (boolean)false, (int)2, null);
            }
            {
                this.$prefix = string2;
                super(1);
            }
        };
        boolean $i$f$directoryStreamIfExists = false;
        try {
            void $this$directoryStreamIfExists$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, new DirectoryStream.Filter(filter$iv){
                final /* synthetic */ Function1 $filter;

                public final boolean accept(Path it) {
                    Path path2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path2);
                }
                {
                    this.$filter = function1;
                }
            });
            Throwable throwable = null;
            try {
                Iterable it = (DirectoryStream)closeable;
                boolean bl = false;
                it = CollectionsKt.toList((Iterable)it);
                iterable = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            iterable = null;
        }
        if (iterable != null) {
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Path path3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"it");
                PathKt.delete$default(path3, false, 1, null);
            }
        }
    }

    @NotNull
    public static final FileTime lastModified(@NotNull Path $this$lastModified) {
        Intrinsics.checkNotNullParameter((Object)$this$lastModified, (String)"$this$lastModified");
        FileTime fileTime = Files.getLastModifiedTime($this$lastModified, new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"Files.getLastModifiedTime(this)");
        return fileTime;
    }

    @NotNull
    public static final String getSystemIndependentPath(@NotNull Path $this$systemIndependentPath) {
        Intrinsics.checkNotNullParameter((Object)$this$systemIndependentPath, (String)"$this$systemIndependentPath");
        return StringsKt.replace$default((String)((Object)$this$systemIndependentPath).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Path $this$readBytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"$this$readBytes");
        byte[] byArray = Files.readAllBytes($this$readBytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Files.readAllBytes(this)");
        return byArray;
    }

    @NotNull
    public static final String readText(@NotNull Path $this$readText) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"$this$readText");
        String string2 = Files.readString($this$readText);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Files.readString(this)");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CharSequence readChars(@NotNull Path $this$readChars) {
        Intrinsics.checkNotNullParameter((Object)$this$readChars, (String)"$this$readChars");
        Closeable closeable = Files.newByteChannel($this$readChars, new OpenOption[0]);
        Throwable throwable = null;
        try {
            CharSequence charSequence;
            SeekableByteChannel channel = (SeekableByteChannel)closeable;
            boolean bl = false;
            int size = (int)channel.size();
            Closeable closeable2 = Channels.newReader(channel, Charsets.UTF_8.newDecoder(), size);
            Throwable throwable2 = null;
            try {
                Reader reader = (Reader)closeable2;
                boolean bl2 = false;
                Reader reader2 = reader;
                Intrinsics.checkNotNullExpressionValue((Object)reader2, (String)"reader");
                charSequence = IoKt.readCharSequence(reader2, size);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            CharSequence charSequence2 = charSequence;
            return charSequence2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $this$writeChild, @NotNull String relativePath, @NotNull byte[] data2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$writeChild, (String)"$this$writeChild");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Path path2 = $this$writeChild.resolve(relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(relativePath)");
        return PathKt.write$default(path2, data2, 0, 0, 6, null);
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $this$writeChild, @NotNull String relativePath, @NotNull String data2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$writeChild, (String)"$this$writeChild");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String string2 = data2;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return PathKt.writeChild($this$writeChild, relativePath, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull byte[] data2, int offset, int size) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Closeable closeable = PathKt.outputStream$default($this$write, false, 1, null);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            it.write(data2, offset, size);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return $this$write;
    }

    public static /* synthetic */ Path write$default(Path path2, byte[] byArray, int n, int n2, int n3, Object object) throws IOException {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return PathKt.write(path2, byArray, n, n2);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull byte[] data2, int offset) throws IOException {
        return PathKt.write$default($this$write, data2, offset, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull byte[] data2) throws IOException {
        return PathKt.write$default($this$write, data2, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull CharSequence data2, @NotNull Charset charset, boolean createParentDirs) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (createParentDirs) {
            Path path2 = $this$write.getParent();
            if (path2 != null) {
                PathKt.createDirectories(path2);
            }
        }
        Files.writeString($this$write, data2, charset, new OpenOption[0]);
        return $this$write;
    }

    public static /* synthetic */ Path write$default(Path path2, CharSequence charSequence, Charset charset, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return PathKt.write(path2, charSequence, charset, bl);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull CharSequence data2, @NotNull Charset charset) {
        return PathKt.write$default($this$write, data2, charset, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull CharSequence data2) {
        return PathKt.write$default($this$write, data2, null, false, 6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull ByteBuffer data2, boolean createParentDirs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (createParentDirs) {
            Path path2 = $this$write.getParent();
            if (path2 != null) {
                PathKt.createDirectories(path2);
            }
        }
        Closeable closeable = Files.newByteChannel($this$write, new HashSet(CollectionsKt.listOf((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING})), new FileAttribute[0]);
        Throwable throwable = null;
        try {
            SeekableByteChannel it = (SeekableByteChannel)closeable;
            boolean bl = false;
            int n = it.write(data2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return $this$write;
    }

    public static /* synthetic */ Path write$default(Path path2, ByteBuffer byteBuffer, boolean bl, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PathKt.write(path2, byteBuffer, bl);
    }

    public static final long size(@NotNull Path $this$size) {
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"$this$size");
        return Files.size($this$size);
    }

    @Nullable
    public static final BasicFileAttributes basicAttributesIfExists(@NotNull Path $this$basicAttributesIfExists) {
        Intrinsics.checkNotNullParameter((Object)$this$basicAttributesIfExists, (String)"$this$basicAttributesIfExists");
        try {
            return Files.readAttributes($this$basicAttributesIfExists, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (FileSystemException ignored) {
            return null;
        }
    }

    public static final long sizeOrNull(@NotNull Path $this$sizeOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$sizeOrNull, (String)"$this$sizeOrNull");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists($this$sizeOrNull);
        return basicFileAttributes != null ? basicFileAttributes.size() : -1L;
    }

    public static final boolean isHidden(@NotNull Path $this$isHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$isHidden, (String)"$this$isHidden");
        return Files.isHidden($this$isHidden);
    }

    public static final boolean isDirectory(@NotNull Path $this$isDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectory, (String)"$this$isDirectory");
        return Files.isDirectory($this$isDirectory, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $this$isFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isFile, (String)"$this$isFile");
        return Files.isRegularFile($this$isFile, new LinkOption[0]);
    }

    @NotNull
    public static final Path move(@NotNull Path $this$move, @NotNull Path target2) {
        Intrinsics.checkNotNullParameter((Object)$this$move, (String)"$this$move");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Path path2 = target2.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Path path3 = Files.move($this$move, target2, StandardCopyOption.REPLACE_EXISTING);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Files.move(this, target,\u2026yOption.REPLACE_EXISTING)");
        return path3;
    }

    @NotNull
    public static final Path copy(@NotNull Path $this$copy, @NotNull Path target2) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$this$copy");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Path path2 = target2.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Path path3 = Files.copy($this$copy, target2, StandardCopyOption.REPLACE_EXISTING);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Files.copy(this, target,\u2026yOption.REPLACE_EXISTING)");
        return path3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyRecursively(@NotNull Path $this$copyRecursively, @NotNull Path target2) {
        Intrinsics.checkNotNullParameter((Object)$this$copyRecursively, (String)"$this$copyRecursively");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Path path2 = target2.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        AutoCloseable autoCloseable = Files.walk($this$copyRecursively, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            stream.forEach(new Consumer($this$copyRecursively, target2){
                final /* synthetic */ Path $this_copyRecursively$inlined;
                final /* synthetic */ Path $target$inlined;
                {
                    this.$this_copyRecursively$inlined = path2;
                    this.$target$inlined = path3;
                }

                public final void accept(Path file2) {
                    Files.copy(file2, this.$target$inlined.resolve(this.$this_copyRecursively$inlined.relativize(file2)), new CopyOption[0]);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final Path createFile(@NotNull Path $this$createFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"$this$createFile");
        Path path2 = $this$createFile.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Files.createFile($this$createFile, new FileAttribute[0]);
        return $this$createFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $this$directoryStreamIfExists, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task2) {
        int $i$f$directoryStreamIfExists = 0;
        Intrinsics.checkNotNullParameter((Object)$this$directoryStreamIfExists, (String)"$this$directoryStreamIfExists");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists);
            Throwable throwable = null;
            try {
                object = task2.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $this$directoryStreamIfExists, @NotNull Function1<? super Path, Boolean> filter2, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task2) {
        int $i$f$directoryStreamIfExists = 0;
        Intrinsics.checkNotNullParameter((Object)$this$directoryStreamIfExists, (String)"$this$directoryStreamIfExists");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists, new /* invalid duplicate definition of identical inner class */);
            Throwable throwable = null;
            try {
                object = task2.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    private static /* synthetic */ void getIllegalChars$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeFileName(@NotNull String name2, @Nullable String replacement, boolean truncateIfNeeded, @Nullable Predicate<Character> extraIllegalChars) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        StringBuilder result2 = null;
        int last2 = 0;
        int length = name2.length();
        int n = 0;
        int n2 = length;
        while (n < n2) {
            char c;
            void i;
            char c2 = name2.charAt((int)i);
            if (illegalChars.contains(Character.valueOf(c2)) || Character.isISOControl(c = c2) || extraIllegalChars != null && extraIllegalChars.test(Character.valueOf(c2))) {
                if (result2 == null) {
                    result2 = new StringBuilder();
                }
                if (last2 < i) {
                    result2.append(name2, last2, (int)i);
                }
                if (replacement != null) {
                    result2.append(replacement);
                }
                last2 = i + true;
            }
            ++i;
        }
        var $fun$truncateFileName$1 = new Function1<String, String>(truncateIfNeeded, length){
            final /* synthetic */ boolean $truncateIfNeeded;
            final /* synthetic */ int $length;

            @NotNull
            public final String invoke(@NotNull String s) {
                String string2;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                if (this.$truncateIfNeeded) {
                    String string3 = s;
                    int n = 0;
                    int n2 = this.$length;
                    int n3 = 255;
                    n2 = Math.min(n2, n3);
                    String string4 = string3.substring(n, n2);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    string2 = s;
                }
                return string2;
            }
            {
                this.$truncateIfNeeded = bl;
                this.$length = n;
                super(1);
            }
        };
        if (result2 == null) {
            return $fun$truncateFileName$1.invoke(name2);
        }
        if (last2 < length) {
            result2.append(name2, last2, length);
        }
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.toString()");
        return $fun$truncateFileName$1.invoke(string2);
    }

    public static /* synthetic */ String sanitizeFileName$default(String string2, String string3, boolean bl, Predicate predicate, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "_";
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            predicate = null;
        }
        return PathKt.sanitizeFileName(string2, string3, bl, predicate);
    }

    public static final boolean isWritable(@NotNull Path $this$isWritable) {
        Intrinsics.checkNotNullParameter((Object)$this$isWritable, (String)"$this$isWritable");
        return Files.isWritable($this$isWritable);
    }

    public static final boolean isDirectory(@Nullable BasicFileAttributes attributes) {
        return attributes != null && attributes.isDirectory();
    }

    public static final boolean isSymbolicLink(@Nullable BasicFileAttributes attributes) {
        return attributes != null && attributes.isSymbolicLink();
    }

    public static final boolean isAncestor(@NotNull Path $this$isAncestor, @NotNull Path child) {
        Intrinsics.checkNotNullParameter((Object)$this$isAncestor, (String)"$this$isAncestor");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return child.startsWith($this$isAncestor);
    }

    @NotNull
    public static final Path generateRandomPath(@NotNull Path parentDirectory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)parentDirectory, (String)"parentDirectory");
        Path path2 = parentDirectory.resolve(UUID.randomUUID().toString());
        int i = 0;
        while (true) {
            Path path3 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            if (!PathKt.exists(path3) || i >= 5) break;
            path2 = parentDirectory.resolve(UUID.randomUUID().toString());
            ++i;
        }
        if (PathKt.exists(path2)) {
            throw (Throwable)new IOException("Couldn't generate unique random path.");
        }
        return path2;
    }
}

