/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/io/HttpSecurityUtil;", "", "()V", "AUTHORIZATION_HEADER_NAME", "", "createBasicAuthHeaderValue", "username", "password", "", "createBearerAuthHeaderValue", "token", "intellij.platform.util.ex"})
public final class HttpSecurityUtil {
    @NotNull
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    @NotNull
    public static final HttpSecurityUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final String createBasicAuthHeaderValue(@NotNull String username, @NotNull char[] password) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        String string2 = username + ":";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        stream.write(byArray);
        ByteBuffer byteBuffer = Charsets.UTF_8.encode(CharBuffer.wrap(password));
        stream.write(Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit()));
        Arrays.fill(byteBuffer.array(), (byte)0);
        byte[] encodedCredentials = Base64.getEncoder().encode(stream.toByteArray());
        Intrinsics.checkNotNullExpressionValue((Object)encodedCredentials, (String)"encodedCredentials");
        byte[] byArray2 = encodedCredentials;
        return new String(byArray2, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String createBearerAuthHeaderValue(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return "Bearer " + token;
    }

    private HttpSecurityUtil() {
    }

    static {
        HttpSecurityUtil httpSecurityUtil;
        INSTANCE = httpSecurityUtil = new HttpSecurityUtil();
    }
}

