/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.nio.charset.MalformedInputException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0002\u001aB\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a,\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a&\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a0\u0010\u0007\u001a\u00020\f*\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0007\u00a8\u0006\u0014"}, d2={"appendIndentString", "", "indent", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getDirectoryTree", "dir", "Ljava/nio/file/Path;", "excluded", "", "", "printContent", "", "printRootName", "printFile", "file", "sortedFileList", "", "intellij.platform.testFramework"})
public final class FileTreePrinterKt {
    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded, boolean printContent, boolean printRootName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectoryTree, (String)"$this$getDirectoryTree");
        Intrinsics.checkNotNullParameter(excluded, (String)"excluded");
        StringBuilder sb = new StringBuilder();
        FileTreePrinterKt.getDirectoryTree($this$getDirectoryTree, 0, sb, excluded, printContent, printRootName);
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    public static /* synthetic */ String getDirectoryTree$default(Path path2, Set set2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return FileTreePrinterKt.getDirectoryTree(path2, set2, bl, bl2);
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded, boolean printContent) {
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, excluded, printContent, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded) {
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, excluded, false, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree) {
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, null, false, false, 7, null);
    }

    private static final void getDirectoryTree(Path dir, int indent, StringBuilder sb, Set<String> excluded, boolean printContent, boolean printRootName) {
        List<Path> list2 = UtilKt.nullize(FileTreePrinterKt.sortedFileList(dir, excluded));
        if (list2 == null) {
            return;
        }
        List<Path> fileList = list2;
        FileTreePrinterKt.appendIndentString(indent, sb);
        if (printContent) {
            sb.append("\u251c\u2500\u2500");
        }
        if (printRootName) {
            sb.append(((Object)dir.getFileName()).toString());
        }
        sb.append("/");
        sb.append("\n");
        for (Path file2 : fileList) {
            if (PathKt.isDirectory(file2)) {
                FileTreePrinterKt.getDirectoryTree(file2, indent + 1, sb, excluded, printContent, printRootName);
                continue;
            }
            FileTreePrinterKt.printFile(file2, indent + 1, sb, printContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Path> sortedFileList(Path dir, Set<String> excluded) {
        List list2;
        Path $this$directoryStreamIfExists$iv = dir;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            Throwable throwable = null;
            try {
                DirectoryStream stream = (DirectoryStream)closeable;
                boolean bl = false;
                Sequence sequence = CollectionsKt.asSequence((Iterable)stream);
                Collection collection = excluded;
                if (!collection.isEmpty()) {
                    sequence = SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<Path, Boolean>(excluded){
                        final /* synthetic */ Set $excluded$inlined;
                        {
                            this.$excluded$inlined = set2;
                            super(1);
                        }

                        public final boolean invoke(Path it) {
                            Path path2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"it");
                            return !this.$excluded$inlined.contains(((Object)path2.getFileName()).toString());
                        }
                    }));
                }
                List list3 = SequencesKt.toMutableList((Sequence)sequence);
                CollectionsKt.sort((List)list3);
                List list4 = list3;
                list2 = list4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            list2 = null;
        }
        return list2;
    }

    private static final void printFile(Path file2, int indent, StringBuilder sb, boolean printContent) {
        FileTreePrinterKt.appendIndentString(indent, sb);
        if (printContent) {
            sb.append("\u251c\u2500\u2500");
        }
        String fileName = ((Object)file2.getFileName()).toString();
        sb.append(fileName);
        sb.append("\n");
        if (printContent && !StringsKt.endsWith$default((String)fileName, (String)".zip", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)".jar", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)".class", (boolean)false, (int)2, null)) {
            try {
                sb.append(PathKt.readChars(file2)).append("\n\n");
            }
            catch (MalformedInputException malformedInputException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendIndentString(int indent, StringBuilder sb) {
        int n = 0;
        int n2 = indent;
        while (n < n2) {
            void i;
            sb.append("  ");
            ++i;
        }
    }
}

