/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.io.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class DirectByteBufferAllocator {
    private static final ExecutorService ourAllocator = SystemInfoRt.isLinux && Boolean.parseBoolean(System.getProperty("idea.limit.paged.storage.allocators", "true")) ? ConcurrencyUtil.newSingleThreadExecutor("DirectBufferWrapper allocation thread") : null;
    private static final boolean USE_POOLED_ALLOCATOR = Boolean.getBoolean("idea.index.use.pooled.page.allocator");
    private final ConcurrentSkipListMap<Integer, ArrayBlockingQueue<ByteBuffer>> myPool = new ConcurrentSkipListMap();
    private final AtomicInteger mySize = new AtomicInteger();
    private final int mySizeLimitInBytes;
    private static final boolean dumpStats = false;
    private static volatile int hit;
    private static volatile int miss;
    private static volatile int reused;
    private static volatile int disposed;

    static <E extends Exception> ByteBuffer allocate(ThrowableComputable<? extends ByteBuffer, E> computable) throws E {
        if (ourAllocator != null) {
            try {
                return ourAllocator.submit(computable::compute).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)cause;
                }
                throw new RuntimeException(e);
            }
        }
        return computable.compute();
    }

    private DirectByteBufferAllocator(int sizeLimitInBytes) {
        this.mySizeLimitInBytes = sizeLimitInBytes;
    }

    DirectByteBufferAllocator() {
        this(0x6400000);
    }

    @NotNull
    ByteBuffer allocate(int size) {
        if (USE_POOLED_ALLOCATOR) {
            Map.Entry<Integer, ArrayBlockingQueue<ByteBuffer>> buffers = this.myPool.ceilingEntry(size);
            while (buffers != null) {
                ByteBuffer cachedBuffer = buffers.getValue().poll();
                int capacity = buffers.getKey();
                if (cachedBuffer != null) {
                    cachedBuffer.rewind();
                    cachedBuffer.limit(size);
                    this.mySize.addAndGet(-capacity);
                    ByteBuffer byteBuffer = cachedBuffer;
                    if (byteBuffer == null) {
                        DirectByteBufferAllocator.$$$reportNull$$$0(0);
                    }
                    return byteBuffer;
                }
                buffers = this.myPool.higherEntry(capacity);
            }
        }
        ByteBuffer byteBuffer = DirectByteBufferAllocator.allocateNewBuffer(size);
        if (byteBuffer == null) {
            DirectByteBufferAllocator.$$$reportNull$$$0(1);
        }
        return byteBuffer;
    }

    private static ByteBuffer allocateNewBuffer(int size) {
        return DirectByteBufferAllocator.allocate(() -> ByteBuffer.allocateDirect(size));
    }

    void release(@NotNull ByteBuffer buffer) {
        int capacity;
        if (buffer == null) {
            DirectByteBufferAllocator.$$$reportNull$$$0(2);
        }
        if (USE_POOLED_ALLOCATOR && this.mySize.get() < this.mySizeLimitInBytes && this.myPool.computeIfAbsent(capacity = buffer.capacity(), __ -> new ArrayBlockingQueue(40)).offer(buffer)) {
            this.mySize.addAndGet(capacity);
            return;
        }
        ByteBufferUtil.cleanBuffer(buffer);
    }

    private static /* synthetic */ void lambda$static$0() {
        System.out.println("pooled buffer stats: hits = " + hit + ", miss = " + miss + ", reused = " + reused + ", disposed = " + disposed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/DirectByteBufferAllocator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "allocate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/DirectByteBufferAllocator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

