/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CompressionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.FileChunkKey;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.LimitedInputStream;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class CompressedAppendableFile {
    private final Path myBaseFile;
    private byte[] myNextChunkBuffer;
    private int myBufferPosition;
    private boolean myDirty;
    private short[] myChunkLengthTable;
    private int myChunkTableLength;
    private static final int FACTOR = 32;
    private long[] myChunkOffsetTable;
    private static final boolean doDebug = SystemProperties.getBooleanProperty("idea.compressed.file.self.check", false);
    private final LongArrayList myCompressedChunksFileOffsets = doDebug ? new LongArrayList() : null;
    public static final int PAGE_LENGTH = SystemProperties.getIntProperty("idea.compressed.file.page.length", 32768);
    private static final int MAX_PAGE_LENGTH = 65535;
    private long myFileLength;
    private long myUncompressedFileLength = -1L;
    private final int myAppendBufferLength;
    private static final int myMinAppendBufferLength = 1024;
    private static final String INCOMPLETE_CHUNK_LENGTH_FILE_EXTENSION = ".s";
    private static int ourFilesCount;
    private final int myCount = ourFilesCount++;

    public CompressedAppendableFile(Path file2) throws IOException {
        this(file2, 32768);
    }

    private CompressedAppendableFile(Path file2, int bufferSize) throws IOException {
        this.myBaseFile = file2;
        this.myAppendBufferLength = bufferSize;
        assert (bufferSize <= 65535);
        Path parent = this.getChunksFile().getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    public synchronized <Data> Data read(long addr, KeyDescriptor<Data> descriptor) throws IOException {
        try (DataInputStream stream = this.getStream(addr);){
            Object t = descriptor.read(stream);
            return (Data)t;
        }
    }

    @NotNull
    public synchronized DataInputStream getStream(long addr) throws IOException {
        this.initChunkLengthTable();
        this.loadAppendBuffer();
        return new DataInputStream(new SegmentedChunkInputStream(addr, this.myChunkTableLength, this.myNextChunkBuffer, this.myBufferPosition));
    }

    @NotNull
    protected Path getChunkLengthFile() {
        Path path2 = this.myBaseFile.resolveSibling(this.myBaseFile.getFileName() + INCOMPLETE_CHUNK_LENGTH_FILE_EXTENSION);
        if (path2 == null) {
            CompressedAppendableFile.$$$reportNull$$$0(0);
        }
        return path2;
    }

    private synchronized void initChunkLengthTable() throws IOException {
        if (this.myChunkLengthTable != null) {
            return;
        }
        Path chunkLengthFile = this.getChunkLengthFile();
        if (Files.exists(chunkLengthFile, new LinkOption[0])) {
            try (DataInputStream chunkLengthStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(Files.newInputStream(chunkLengthFile, new OpenOption[0]), (int)Files.size(chunkLengthFile)){

                @Override
                public int available() {
                    return this.remainingLimit();
                }
            }, 32768));){
                short[] chunkLengthTable = new short[(int)(Files.size(chunkLengthFile) / 2L)];
                int chunkLengthTableLength = 0;
                long o = 0L;
                while (chunkLengthStream.available() != 0) {
                    int chunkLength = DataInputOutputUtil.readINT(chunkLengthStream);
                    o += (long)chunkLength;
                    if (chunkLengthTableLength == chunkLengthTable.length) {
                        chunkLengthTable = CompressedAppendableFile.reallocShortTable(chunkLengthTable);
                    }
                    chunkLengthTable[chunkLengthTableLength++] = (short)chunkLength;
                    if (!doDebug) continue;
                    this.myCompressedChunksFileOffsets.add(o);
                }
                this.myChunkLengthTable = chunkLengthTable;
                this.myChunkTableLength = chunkLengthTableLength;
                if (this.myChunkTableLength >= 32) {
                    int i;
                    long[] chunkOffsetTable = new long[this.myChunkTableLength / 32];
                    long offset = 0L;
                    for (i = 0; i < chunkOffsetTable.length; ++i) {
                        int start2 = i * 32;
                        for (int j = 0; j < 32; ++j) {
                            offset += (long)(chunkLengthTable[start2 + j] & 0xFFFF);
                        }
                        chunkOffsetTable[i] = offset;
                    }
                    this.myChunkOffsetTable = chunkOffsetTable;
                    if (doDebug) {
                        for (i = 0; i < chunkLengthTableLength; ++i) {
                            this.calcOffsetOfPage(i);
                        }
                    }
                } else {
                    this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
                }
                this.myFileLength = this.calcOffsetOfPage(this.myChunkTableLength - 1);
            }
        } else {
            this.myChunkLengthTable = ArrayUtilRt.EMPTY_SHORT_ARRAY;
            this.myChunkTableLength = 0;
            this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
            this.myFileLength = 0L;
        }
        if (this.myUncompressedFileLength == -1L) {
            long tempFileLength = Files.exists(this.getIncompleteChunkFile(), new LinkOption[0]) ? Files.size(this.getIncompleteChunkFile()) : 0L;
            this.myUncompressedFileLength = (long)this.myChunkTableLength * (long)this.myAppendBufferLength + tempFileLength;
            if (this.myUncompressedFileLength != this.myFileLength + tempFileLength && CompressionUtil.DUMP_COMPRESSION_STATS) {
                System.out.println(this.myUncompressedFileLength + "->" + (this.myFileLength + tempFileLength) + " for " + this.myBaseFile);
            }
        }
    }

    /*
     * Loose catch block
     */
    private synchronized byte @NotNull [] loadChunk(int chunkNumber) throws IOException {
        block16: {
            DataInputStream keysStream;
            block13: {
                byte[] byArray;
                block15: {
                    block14: {
                        if (this.myChunkLengthTable == null) {
                            this.initChunkLengthTable();
                        }
                        assert (chunkNumber < this.myChunkTableLength);
                        keysStream = this.getChunkStream(chunkNumber);
                        if (keysStream.available() <= 0) break block13;
                        byte[] decompressedBytes = this.decompress(keysStream);
                        if (decompressedBytes.length != this.myAppendBufferLength) assert (false);
                        byArray = decompressedBytes;
                        if (keysStream == null) break block14;
                        keysStream.close();
                    }
                    if (byArray != null) break block15;
                    CompressedAppendableFile.$$$reportNull$$$0(1);
                }
                return byArray;
            }
            try {
                block17: {
                    if (keysStream != null) {
                        keysStream.close();
                    }
                    break block17;
                    {
                        catch (Throwable throwable) {
                            if (keysStream != null) {
                                try {
                                    keysStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                assert (false) : "data corruption detected:" + chunkNumber + "," + this.myChunkTableLength;
                if (ArrayUtilRt.EMPTY_BYTE_ARRAY != null) break block16;
            }
            catch (AssertionError | RuntimeException e) {
                throw new IOException((Throwable)e);
            }
            CompressedAppendableFile.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    @NotNull
    private DataInputStream getChunkStream(int pageNumber) throws IOException {
        int limit2;
        long pageStartOffset;
        long pageEndOffset;
        assert (this.myFileLength != 0L);
        long l = pageEndOffset = pageNumber < this.myChunkTableLength ? this.calcOffsetOfPage(pageNumber) : this.myFileLength;
        if (pageNumber > 0) {
            pageStartOffset = this.calcOffsetOfPage(pageNumber - 1);
            limit2 = (int)(pageEndOffset - pageStartOffset);
        } else {
            pageStartOffset = 0L;
            limit2 = (int)pageEndOffset;
        }
        return new DataInputStream(this.getChunkInputStream(pageStartOffset, limit2));
    }

    private long calcOffsetOfPage(int pageNumber) {
        int calculatedOffset = (pageNumber + 1) / 32;
        long offset = calculatedOffset > 0 ? this.myChunkOffsetTable[calculatedOffset - 1] : 0L;
        int baseOffset = calculatedOffset * 32;
        int len = (pageNumber + 1) % 32;
        for (int index = 0; index < len; ++index) {
            offset += (long)(this.myChunkLengthTable[baseOffset + index] & 0xFFFF);
        }
        if (doDebug) assert (this.myCompressedChunksFileOffsets.get(pageNumber) == offset);
        return offset;
    }

    @NotNull
    protected InputStream getChunkInputStream(long offset, int pageSize) throws IOException {
        long skipped;
        InputStream in = Files.newInputStream(this.getChunksFile(), new OpenOption[0]);
        for (long toSkip = offset; toSkip > 0L; toSkip -= skipped) {
            skipped = in.skip(toSkip);
            if (skipped != 0L) continue;
            throw new EOFException("Unable to skip " + offset + " bytes: end-of-file reached");
        }
        return new BufferedInputStream(new LimitedInputStream(in, pageSize){

            @Override
            public int available() {
                return this.remainingLimit();
            }
        }, pageSize);
    }

    public synchronized <Data> void append(Data value, KeyDescriptor<Data> descriptor) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        descriptor.save(out, value);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        this.append(buffer, size);
    }

    public void append(byte[] buffer, int size) throws IOException {
        this.append(buffer, 0, size);
    }

    public synchronized void append(byte[] buffer, int offset, int size) throws IOException {
        int bytesToWriteInTheBuffer;
        int newBufferSize;
        if (size == 0) {
            return;
        }
        if (this.myNextChunkBuffer == null) {
            this.loadAppendBuffer();
        }
        if (this.myNextChunkBuffer.length != this.myAppendBufferLength && this.myBufferPosition + size >= this.myNextChunkBuffer.length && (newBufferSize = this.calcBufferSize(this.myBufferPosition + size)) != this.myNextChunkBuffer.length) {
            this.myNextChunkBuffer = Arrays.copyOf(this.myNextChunkBuffer, newBufferSize);
        }
        int bufferPosition = offset;
        for (int sizeToWrite = size; sizeToWrite > 0; sizeToWrite -= bytesToWriteInTheBuffer) {
            bytesToWriteInTheBuffer = Math.min(this.myNextChunkBuffer.length - this.myBufferPosition, sizeToWrite);
            System.arraycopy(buffer, bufferPosition, this.myNextChunkBuffer, this.myBufferPosition, bytesToWriteInTheBuffer);
            this.myBufferPosition += bytesToWriteInTheBuffer;
            bufferPosition += bytesToWriteInTheBuffer;
            this.saveNextChunkIfNeeded();
        }
        if (this.myUncompressedFileLength == -1L) {
            this.length();
        }
        this.myUncompressedFileLength += (long)size;
        this.myDirty = true;
    }

    private synchronized void loadAppendBuffer() throws IOException {
        if (this.myNextChunkBuffer != null) {
            return;
        }
        Path tempAppendFile = this.getIncompleteChunkFile();
        if (Files.exists(tempAppendFile, new LinkOption[0])) {
            this.myBufferPosition = (int)Files.size(tempAppendFile);
            this.myNextChunkBuffer = new byte[this.calcBufferSize(this.myBufferPosition)];
            try (InputStream stream = Files.newInputStream(tempAppendFile, new OpenOption[0]);){
                int count2;
                for (int n = 0; n < this.myBufferPosition; n += count2) {
                    count2 = stream.read(this.myNextChunkBuffer, n, this.myBufferPosition - n);
                    if (count2 >= 0) continue;
                }
            }
        } else {
            this.myBufferPosition = 0;
            this.myNextChunkBuffer = new byte[1024];
        }
    }

    private int calcBufferSize(int position) {
        return Math.min(this.myAppendBufferLength, Integer.highestOneBit(Math.max(1023, position)) << 1);
    }

    private void saveNextChunkIfNeeded() throws IOException {
        if (this.myBufferPosition == this.myNextChunkBuffer.length) {
            BufferExposingByteArrayOutputStream compressedOut = new BufferExposingByteArrayOutputStream();
            DataOutputStream compressedDataOut = new DataOutputStream(compressedOut);
            this.compress(compressedDataOut, this.myNextChunkBuffer);
            compressedDataOut.close();
            assert (compressedDataOut.size() <= 65535);
            this.saveChunk(compressedOut);
            this.myBufferPosition = 0;
            this.initChunkLengthTable();
            this.myFileLength += (long)compressedOut.size();
            if (doDebug) {
                this.myCompressedChunksFileOffsets.add(this.myFileLength);
            }
            if (this.myChunkLengthTable.length == this.myChunkTableLength) {
                this.myChunkLengthTable = CompressedAppendableFile.reallocShortTable(this.myChunkLengthTable);
            }
            this.myChunkLengthTable[this.myChunkTableLength++] = (short)compressedOut.size();
            if (this.myChunkTableLength / 32 > this.myChunkOffsetTable.length) {
                long[] newChunkOffsetTable = new long[this.myChunkOffsetTable.length + 1];
                System.arraycopy(this.myChunkOffsetTable, 0, newChunkOffsetTable, 0, this.myChunkOffsetTable.length);
                newChunkOffsetTable[this.myChunkOffsetTable.length] = this.myFileLength;
                this.myChunkOffsetTable = newChunkOffsetTable;
            }
            byte[] bytes = new byte[this.myAppendBufferLength];
            System.arraycopy(this.myNextChunkBuffer, 0, bytes, 0, this.myAppendBufferLength);
            FileChunkReadCache.ourDecompressedCache.put(this, this.myChunkTableLength - 1, bytes);
        }
    }

    private static short @NotNull [] reallocShortTable(short[] table) {
        short[] sArray = ArrayUtil.realloc(table, Math.max(table.length * 8 / 5, table.length + 1));
        if (sArray == null) {
            CompressedAppendableFile.$$$reportNull$$$0(3);
        }
        return sArray;
    }

    protected int compress(DataOutputStream compressedDataOut, byte[] buffer) throws IOException {
        return CompressionUtil.writeCompressedWithoutOriginalBufferLength(compressedDataOut, buffer, this.myAppendBufferLength);
    }

    protected byte @NotNull [] decompress(DataInputStream keysStream) throws IOException {
        byte[] byArray = CompressionUtil.readCompressedWithoutOriginalBufferLength(keysStream, this.myAppendBufferLength);
        if (byArray == null) {
            CompressedAppendableFile.$$$reportNull$$$0(4);
        }
        return byArray;
    }

    private void saveChunk(BufferExposingByteArrayOutputStream compressedChunk) throws IOException {
        try (DataOutputStream stream = this.getChunkAppendStream();){
            stream.write(compressedChunk.getInternalBuffer(), 0, compressedChunk.size());
        }
        try (DataOutputStream chunkLengthStream = this.getChunkLengthAppendStream();){
            DataInputOutputUtil.writeINT(chunkLengthStream, compressedChunk.size());
        }
    }

    @NotNull
    protected DataOutputStream getChunkLengthAppendStream() throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunkLengthFile().toFile(), true)));
    }

    @NotNull
    protected DataOutputStream getChunkAppendStream() throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunksFile().toFile(), true)));
    }

    @NotNull
    protected Path getChunksFile() {
        Path path2 = this.myBaseFile.resolveSibling(this.myBaseFile.getFileName() + ".a");
        if (path2 == null) {
            CompressedAppendableFile.$$$reportNull$$$0(5);
        }
        return path2;
    }

    private void saveIncompleteChunk() {
        if (this.myNextChunkBuffer != null && this.myDirty) {
            block14: {
                Path incompleteChunkFile = this.getIncompleteChunkFile();
                try {
                    this.saveNextChunkIfNeeded();
                    if (this.myBufferPosition != 0) {
                        try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(incompleteChunkFile, StandardOpenOption.CREATE));){
                            stream.write(this.myNextChunkBuffer, 0, this.myBufferPosition);
                            break block14;
                        }
                    }
                    if (Files.exists(incompleteChunkFile, new LinkOption[0])) {
                        Files.delete(incompleteChunkFile);
                    }
                }
                catch (NoSuchFileException ex) {
                    Path parentFile = incompleteChunkFile.getParent();
                    if (!Files.exists(parentFile, new LinkOption[0])) {
                        try {
                            Files.createDirectories(parentFile, new FileAttribute[0]);
                            this.saveIncompleteChunk();
                            return;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to write: " + incompleteChunkFile, ex);
                        }
                    }
                    throw new RuntimeException(ex);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.myDirty = false;
        }
    }

    @NotNull
    private Path getIncompleteChunkFile() {
        Path path2 = this.myBaseFile.resolveSibling(this.myBaseFile.getFileName() + ".at");
        if (path2 == null) {
            CompressedAppendableFile.$$$reportNull$$$0(6);
        }
        return path2;
    }

    public synchronized void force() {
        this.saveIncompleteChunk();
    }

    public synchronized void dispose() {
        this.force();
        FileChunkReadCache.ourDecompressedCache.clear(this);
    }

    public synchronized long length() {
        if (this.myUncompressedFileLength == -1L && this.myChunkLengthTable == null) {
            try {
                this.initChunkLengthTable();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.myUncompressedFileLength;
    }

    public synchronized boolean isDirty() {
        return this.myDirty;
    }

    public int hashCode() {
        return this.myCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/io/CompressedAppendableFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChunkLengthFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadChunk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocShortTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "decompress";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChunksFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncompleteChunkFile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SegmentedChunkInputStream
    extends InputStream {
        private final int myChunkLengthTableSnapshotLength;
        private final byte[] myNextChunkBufferSnapshot;
        private final int myBufferPositionSnapshot;
        private InputStream bytesFromCompressedBlock;
        private InputStream bytesFromTempAppendBlock;
        private int myCurrentPageNumber;
        private int myPageOffset;

        SegmentedChunkInputStream(long addr, int chunkLengthTableSnapshotLength, byte[] tableRef, int position) {
            this.myChunkLengthTableSnapshotLength = chunkLengthTableSnapshotLength;
            this.myNextChunkBufferSnapshot = tableRef;
            this.myBufferPositionSnapshot = position;
            this.myCurrentPageNumber = (int)(addr / (long)CompressedAppendableFile.this.myAppendBufferLength);
            this.myPageOffset = (int)(addr % (long)CompressedAppendableFile.this.myAppendBufferLength);
        }

        @Override
        public int read(byte @NotNull [] b, int off, int len) throws IOException {
            if (b == null) {
                SegmentedChunkInputStream.$$$reportNull$$$0(0);
            }
            if (this.bytesFromCompressedBlock == null) {
                byte[] decompressedBytes = this.myCurrentPageNumber < this.myChunkLengthTableSnapshotLength ? FileChunkReadCache.ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber) : ArrayUtilRt.EMPTY_BYTE_ARRAY;
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, this.myPageOffset, decompressedBytes.length);
            }
            int readBytesCount = 0;
            if (this.bytesFromCompressedBlock.available() > 0) {
                readBytesCount = this.bytesFromCompressedBlock.read(b, off, len);
                this.myPageOffset += readBytesCount;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if (readBytesCount == len) {
                    return readBytesCount;
                }
            }
            while (this.myCurrentPageNumber < this.myChunkLengthTableSnapshotLength) {
                byte[] decompressedBytes = FileChunkReadCache.ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber);
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, 0, decompressedBytes.length);
                int read = this.bytesFromCompressedBlock.read(b, off + readBytesCount, len - readBytesCount);
                this.myPageOffset += read;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if ((readBytesCount += read) != len) continue;
                return readBytesCount;
            }
            if (this.bytesFromTempAppendBlock == null) {
                this.bytesFromTempAppendBlock = new ByteArrayInputStream(this.myNextChunkBufferSnapshot, this.myPageOffset, this.myBufferPositionSnapshot);
            }
            return readBytesCount + this.bytesFromTempAppendBlock.read(b, off + readBytesCount, len - readBytesCount);
        }

        @Override
        public int read() throws IOException {
            byte[] buf = new byte[]{0};
            int read = this.read(buf);
            if (read == -1) {
                return -1;
            }
            return buf[0] & 0xFF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/util/io/CompressedAppendableFile$SegmentedChunkInputStream", "read"));
        }
    }

    private static class FileChunkReadCache {
        private static final FileChunkReadCache ourDecompressedCache = new FileChunkReadCache();
        private final SLRUMap<FileChunkKey<CompressedAppendableFile>, byte[]> myMap = new SLRUMap(64, 64);

        private FileChunkReadCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        byte @NotNull [] get(CompressedAppendableFile file2, int page2) throws IOException {
            byte[] bytes;
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                bytes = this.myMap.get(new FileChunkKey<CompressedAppendableFile>(file2, page2));
                if (bytes != null) {
                    // MONITOREXIT @DISABLED, blocks:[2, 5] lbl5 : MonitorExitStatement: MONITOREXIT : var4_3
                    if (bytes == null) {
                        FileChunkReadCache.$$$reportNull$$$0(0);
                    }
                    return bytes;
                }
            }
            bytes = file2.loadChunk(page2);
            this.put(file2, page2, bytes);
            if (bytes == null) {
                FileChunkReadCache.$$$reportNull$$$0(1);
            }
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(CompressedAppendableFile file2, long page2, byte[] bytes) {
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.myMap.put(new FileChunkKey<CompressedAppendableFile>(file2, page2), bytes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.myMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear(@NotNull CompressedAppendableFile file2) {
            if (file2 == null) {
                FileChunkReadCache.$$$reportNull$$$0(2);
            }
            HashSet toClean = new HashSet();
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.myMap.iterateKeys(key -> {
                    if (key.getOwner() == file2) {
                        toClean.add(key);
                    }
                });
                for (FileChunkKey key2 : toClean) {
                    this.myMap.remove(key2);
                }
            }
        }

        static {
            LowMemoryWatcher lowMemoryWatcher = LowMemoryWatcher.register(() -> ourDecompressedCache.clear());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/CompressedAppendableFile$FileChunkReadCache";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/CompressedAppendableFile$FileChunkReadCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "clear";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

