/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.indexing.IndexableFilesFilter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0004J<\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/intellij/util/indexing/roots/IndexableFilesIterationMethods;", "", "()V", "followSymlinks", "", "getFollowSymlinks", "()Z", "iterateRoots", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "contentIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "excludeNonProjectRoots", "shouldIndexFile", "file", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "filters", "", "Lcom/intellij/util/indexing/IndexableFilesFilter;", "rootsSet", "", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class IndexableFilesIterationMethods {
    @NotNull
    public static final IndexableFilesIterationMethods INSTANCE;

    private final boolean getFollowSymlinks() {
        return Registry.is("indexer.follows.symlinks");
    }

    public final boolean iterateRoots(@NotNull Project project2, @NotNull Iterable<? extends VirtualFile> roots2, @NotNull ContentIterator contentIterator, @NotNull VirtualFileFilter fileFilter, boolean excludeNonProjectRoots) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(roots2, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)contentIterator, (String)"contentIterator");
            Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
            ProjectFileIndex projectFileIndex2 = projectFileIndex;
            ExtensionPointName<IndexableFilesFilter> extensionPointName = IndexableFilesFilter.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"IndexableFilesFilter.EP_NAME");
            List<IndexableFilesFilter> list2 = extensionPointName.getExtensionList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"IndexableFilesFilter.EP_NAME.extensionList");
            List<IndexableFilesFilter> filters = list2;
            Set rootsSet = CollectionsKt.toSet(roots2);
            VirtualFileFilter virtualFileFilter = fileFilter.and(new VirtualFileFilter(projectFileIndex2, filters, rootsSet, excludeNonProjectRoots){
                final /* synthetic */ ProjectFileIndex $projectFileIndex;
                final /* synthetic */ List $filters;
                final /* synthetic */ Set $rootsSet;
                final /* synthetic */ boolean $excludeNonProjectRoots;

                public final boolean accept(@NotNull VirtualFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return IndexableFilesIterationMethods.access$shouldIndexFile(IndexableFilesIterationMethods.INSTANCE, it, this.$projectFileIndex, this.$filters, this.$rootsSet, this.$excludeNonProjectRoots);
                }
                {
                    this.$projectFileIndex = projectFileIndex;
                    this.$filters = list2;
                    this.$rootsSet = set2;
                    this.$excludeNonProjectRoots = bl;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileFilter, (String)"fileFilter.and { shouldI\u2026excludeNonProjectRoots) }");
            VirtualFileFilter finalFileFilter2 = virtualFileFilter;
            Iterable<? extends VirtualFile> $this$all$iv = roots2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator<? extends VirtualFile> iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile element$iv;
                    VirtualFile root = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (VfsUtilCore.iterateChildrenRecursively(root, finalFileFilter2, contentIterator)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean iterateRoots$default(IndexableFilesIterationMethods indexableFilesIterationMethods, Project project2, Iterable iterable, ContentIterator contentIterator, VirtualFileFilter virtualFileFilter, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return indexableFilesIterationMethods.iterateRoots(project2, iterable, contentIterator, virtualFileFilter, bl);
    }

    private final boolean shouldIndexFile(VirtualFile file2, ProjectFileIndex projectFileIndex, List<? extends IndexableFilesFilter> filters, Set<? extends VirtualFile> rootsSet, boolean excludeNonProjectRoots) {
        Collection $i$f$runReadAction2;
        if (file2.is(VFileProperty.SYMLINK)) {
            if (!this.getFollowSymlinks()) {
                return false;
            }
            VirtualFile targetFile = file2.getCanonicalFile();
            if (targetFile == null || targetFile.is(VFileProperty.SYMLINK)) {
                return false;
            }
            if (rootsSet.contains(file2)) {
                return true;
            }
            return this.shouldIndexFile(targetFile, projectFileIndex, filters, rootsSet, excludeNonProjectRoots);
        }
        if (!(file2 instanceof VirtualFileWithId) || ((VirtualFileWithId)((Object)file2)).getId() <= 0) {
            return false;
        }
        if (excludeNonProjectRoots) {
            boolean $i$f$runReadAction2 = false;
            if (((Boolean)ApplicationManager.getApplication().runReadAction(new Computable(projectFileIndex, file2){
                final /* synthetic */ ProjectFileIndex $projectFileIndex$inlined;
                final /* synthetic */ VirtualFile $file$inlined;
                {
                    this.$projectFileIndex$inlined = projectFileIndex;
                    this.$file$inlined = virtualFile2;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)Boolean.valueOf(this.$projectFileIndex$inlined.isExcluded(this.$file$inlined));
                }
            })).booleanValue()) {
                return false;
            }
        }
        if (!($i$f$runReadAction2 = (Collection)filters).isEmpty()) {
            boolean bl;
            block12: {
                Iterable $this$none$iv = filters;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        IndexableFilesFilter it = (IndexableFilesFilter)element$iv;
                        boolean bl2 = false;
                        if (!it.shouldIndex(file2)) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return false;
            }
        }
        return true;
    }

    private IndexableFilesIterationMethods() {
    }

    static {
        IndexableFilesIterationMethods indexableFilesIterationMethods;
        INSTANCE = indexableFilesIterationMethods = new IndexableFilesIterationMethods();
    }

    public static final /* synthetic */ boolean access$shouldIndexFile(IndexableFilesIterationMethods $this, VirtualFile file2, ProjectFileIndex projectFileIndex, List filters, Set rootsSet, boolean excludeNonProjectRoots) {
        return $this.shouldIndexFile(file2, projectFileIndex, filters, rootsSet, excludeNonProjectRoots);
    }
}

