/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumperUtils;
import com.intellij.util.indexing.diagnostic.StorageDiagnosticData;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.stats.FilePageCacheStatistics;
import com.intellij.util.io.stats.PersistentEnumeratorStatistics;
import com.intellij.util.io.stats.PersistentHashMapStatistics;
import com.intellij.util.io.stats.StorageStatsRegistrar;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003%&'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0007J\b\u0010\u000f\u001a\u00020\nH\u0007J6\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00120\u0011\"\u0004\b\u0000\u0010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0007J0\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001e0\u00142\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 0\u0014H\u0002J0\u0010!\u001a\u00020\"2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001e0#2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 0#H\u0002J0\u0010$\u001a\u00020\"2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001e0\u00142\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 0\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData;", "", "()V", "dumpPeriodInMinutes", "", "fileNamePrefix", "", "maxFiles", "", "deleteOutdatedDiagnostics", "", "dump", "onShutdown", "", "dumpOnShutdown", "dumpPeriodically", "filterStatsForStoragesUnderDir", "Ljava/util/SortedMap;", "Stats", "mapStats", "", "Ljava/nio/file/Path;", "dir", "getDumpFile", "time", "Ljava/time/LocalDateTime;", "getStorageDataStatistics", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StorageDataStats;", "indexStorageStatistics", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$IndexStorageStats;", "Lcom/intellij/util/io/stats/PersistentHashMapStatistics;", "enumeratorStats", "Lcom/intellij/util/io/stats/PersistentEnumeratorStatistics;", "otherGeneralStorageStatistics", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "", "vfsStorageStatistics", "IndexStorageStats", "StatsPerStorage", "StorageDataStats", "intellij.platform.lang.impl"})
public final class StorageDiagnosticData {
    private static final String fileNamePrefix = "storage-diagnostic-";
    private static final int maxFiles = 10;
    private static final long dumpPeriodInMinutes = 5L;
    @NotNull
    public static final StorageDiagnosticData INSTANCE;

    @JvmStatic
    public static final void dumpPeriodically() {
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService("Storage Diagnostic Dumper", 1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"AppExecutorUtil.createBo\u2026c Dumper\",\n      1,\n    )");
        ScheduledExecutorService executor = scheduledExecutorService;
        executor.scheduleWithFixedDelay(dumpPeriodically.1.INSTANCE, 5L, 5L, TimeUnit.MINUTES);
    }

    @JvmStatic
    public static final void dumpOnShutdown() {
        INSTANCE.dump(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void dump(boolean onShutdown) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        long sessionStartTime = application.getStartTime();
        LocalDateTime sessionLocalDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(sessionStartTime), ZoneId.systemDefault());
        try {
            StorageDataStats stats = this.getStorageDataStatistics();
            LocalDateTime localDateTime = sessionLocalDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"sessionLocalDateTime");
            Path file2 = this.getDumpFile(localDateTime, onShutdown);
            IndexDiagnosticDumperUtils.INSTANCE.writeValue(file2, stats);
        }
        catch (Exception e) {
            StorageDiagnosticData $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(StorageDiagnosticData.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error(e);
        }
        finally {
            this.deleteOutdatedDiagnostics();
        }
    }

    private final Path getDumpFile(LocalDateTime time, boolean onShutdown) {
        return IndexDiagnosticDumperUtils.INSTANCE.getDumpFilePath(fileNamePrefix, time, "json", IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir(), onShutdown ? "on-shutdown-" : "");
    }

    @VisibleForTesting
    @NotNull
    public final StorageDataStats getStorageDataStatistics() {
        Map mapStats = MapsKt.toMutableMap(StorageStatsRegistrar.INSTANCE.dumpStatsForOpenMaps());
        Map enumeratorStats = MapsKt.toMutableMap(StorageStatsRegistrar.INSTANCE.dumpStatsForOpenEnumerators());
        StatsPerStorage vfsStorageStats = this.vfsStorageStatistics(mapStats, enumeratorStats);
        IndexStorageStats indexStorageStats = this.indexStorageStatistics(mapStats, enumeratorStats);
        StatsPerStorage otherStorageStats = this.otherGeneralStorageStatistics(mapStats, enumeratorStats);
        FilePageCacheStatistics filePageCacheStatistics = StorageLockContext.getStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)filePageCacheStatistics, (String)"StorageLockContext.getStatistics()");
        FilePageCacheStatistics pageCacheStats = filePageCacheStatistics;
        return new StorageDataStats(pageCacheStats, vfsStorageStats.nullize(), indexStorageStats, otherStorageStats.nullize());
    }

    private final void deleteOutdatedDiagnostics() {
        Iterable $this$sortedBy$iv = PathsKt.listDirectoryEntries((Path)IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir(), (String)"storage-diagnostic-*");
        boolean $i$f$sortedBy = false;
        List allDiagnosticFiles = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Path it = (Path)a;
                boolean bl = false;
                Comparable comparable = it.getFileName();
                it = (Path)b;
                Comparable comparable2 = comparable;
                bl = false;
                Path path2 = it.getFileName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)path2);
            }
        });
        if (allDiagnosticFiles.size() - 10 > 0) {
            List outdatedFiles = CollectionsKt.take((Iterable)allDiagnosticFiles, (int)(allDiagnosticFiles.size() - 10));
            for (Path outdatedFile : outdatedFiles) {
                PathKt.delete$default(outdatedFile, false, 1, null);
            }
        }
    }

    private final StatsPerStorage otherGeneralStorageStatistics(Map<Path, PersistentHashMapStatistics> mapStats, Map<Path, PersistentEnumeratorStatistics> enumeratorStats) {
        Object v;
        Map.Entry it$iv$iv;
        boolean bl;
        Object object;
        String string2;
        Object object2;
        Path path2;
        Map.Entry it;
        Map map2;
        Map<Path, Object> $this$mapKeysTo$iv$iv;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance(ApplicationManager.getApplication());
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"PathMacroManager.getInst\u2026Manager.getApplication())");
        PathMacroManager macroManager = pathMacroManager;
        Map<Path, Object> $this$mapKeys$iv = mapStats;
        boolean $i$f$mapKeys = false;
        Map<Path, PersistentHashMapStatistics> map3 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl2 = false;
            path2 = (Path)it.getKey();
            object2 = macroManager.collapsePath(((Object)path2).toString());
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            string2 = object2;
            object = map2;
            bl = false;
            v = it$iv$iv.getValue();
            object.put(string2, v);
        }
        map2 = destination$iv$iv;
        $this$mapKeys$iv = enumeratorStats;
        map2 = MapsKt.toSortedMap((Map)map2);
        $i$f$mapKeys = false;
        $this$mapKeysTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv;
            boolean bl3 = false;
            path2 = (Path)it.getKey();
            String string3 = macroManager.collapsePath(((Object)path2).toString());
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            string2 = string3;
            object = object2;
            bl = false;
            v = it$iv$iv.getValue();
            object.put(string2, v);
        }
        object2 = destination$iv$iv;
        SortedMap sortedMap2 = MapsKt.toSortedMap((Map)object2);
        Map map4 = map2;
        return new StatsPerStorage((SortedMap<String, PersistentHashMapStatistics>)map4, sortedMap2);
    }

    /*
     * WARNING - void declaration
     */
    private final IndexStorageStats indexStorageStatistics(Map<Path, PersistentHashMapStatistics> mapStats, Map<Path, PersistentEnumeratorStatistics> enumeratorStats) {
        SortedMap perIndexStats = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        for (ID<?, ?> id2 : ID.getRegisteredIds()) {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = CollectionsKt.listOf((Object[])new Path[]{IndexInfrastructure.getIndexRootDir(id2), IndexInfrastructure.getPersistentIndexRootDir(id2)});
            boolean $i$f$map = false;
            void var9_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v0 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
                StatsPerStorage statsPerStorage = new StatsPerStorage(INSTANCE.filterStatsForStoragesUnderDir(mapStats, (Path)v0), INSTANCE.filterStatsForStoragesUnderDir(enumeratorStats, (Path)it));
                collection.add(statsPerStorage);
            }
            $this$map$iv = (List)destination$iv$iv;
            StatsPerStorage initial$iv = StatsPerStorage.Companion.getEMPTY();
            boolean $i$f$fold = false;
            StatsPerStorage accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void b;
                Object item$iv$iv;
                item$iv$iv = (StatsPerStorage)element$iv;
                StatsPerStorage a = accumulator$iv;
                boolean bl = false;
                accumulator$iv = a.plus((StatsPerStorage)b);
            }
            StatsPerStorage indexStats = accumulator$iv;
            if (indexStats.isEmpty()) continue;
            ID<?, ?> iD = id2;
            Intrinsics.checkNotNullExpressionValue(iD, (String)"id");
            perIndexStats.put(iD.getName(), indexStats);
        }
        Path path3 = PathManager.getIndexRoot();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"PathManager.getIndexRoot()");
        Path indexDir = path3;
        StatsPerStorage otherIndexStorageStats = new StatsPerStorage(this.filterStatsForStoragesUnderDir(mapStats, indexDir), this.filterStatsForStoragesUnderDir(enumeratorStats, indexDir)).nullize();
        return new IndexStorageStats(perIndexStats, otherIndexStorageStats);
    }

    private final StatsPerStorage vfsStorageStatistics(Map<Path, PersistentHashMapStatistics> mapStats, Map<Path, PersistentEnumeratorStatistics> enumeratorStats) {
        Path path2 = Path.of(FSRecords.getCachesDir(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Path.of(FSRecords.getCachesDir())");
        Path path3 = path2;
        Path path4 = path3.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toAbsolutePath()");
        Path cachesDir = path4;
        return new StatsPerStorage(this.filterStatsForStoragesUnderDir(mapStats, cachesDir), this.filterStatsForStoragesUnderDir(enumeratorStats, cachesDir));
    }

    /*
     * WARNING - void declaration
     */
    private final <Stats> SortedMap<String, Stats> filterStatsForStoragesUnderDir(Map<Path, Stats> mapStats, Path dir) {
        void $this$mapKeysTo$iv$iv;
        boolean bl = dir.isAbsolute();
        if (!bl) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        Map<Path, Stats> $this$filterKeys$iv = mapStats;
        boolean $i$f$filterKeys = false;
        Map<Path, Stats> result$iv = new LinkedHashMap();
        for (Map.Entry<Path, Stats> entry$iv : $this$filterKeys$iv.entrySet()) {
            Path it = entry$iv.getKey();
            boolean bl2 = false;
            if (!(Intrinsics.areEqual((Object)it.getFileSystem(), (Object)dir.getFileSystem()) && it.startsWith(dir))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map filtered = result$iv;
        for (Path key : filtered.keySet()) {
            mapStats.remove(key);
        }
        Map $this$mapKeys$iv = filtered;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl3 = false;
            Path path2 = PathsKt.relativeTo((Path)((Path)it.getKey()), (Path)dir);
            String string3 = ((Object)path2).toString();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string4 = string3;
            Map map3 = map2;
            boolean bl4 = false;
            Object v = it$iv$iv.getValue();
            map3.put(string4, v);
        }
        return MapsKt.toSortedMap((Map)destination$iv$iv);
    }

    private StorageDiagnosticData() {
    }

    static {
        StorageDiagnosticData storageDiagnosticData;
        INSTANCE = storageDiagnosticData = new StorageDiagnosticData();
    }

    public static final /* synthetic */ void access$dump(StorageDiagnosticData $this, boolean onShutdown) {
        $this.dump(onShutdown);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$IndexStorageStats;", "", "indexStoragesStats", "", "", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "otherStoragesStats", "(Ljava/util/Map;Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;)V", "getIndexStoragesStats", "()Ljava/util/Map;", "getOtherStoragesStats", "()Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    public static final class IndexStorageStats {
        @NotNull
        private final Map<String, StatsPerStorage> indexStoragesStats;
        @Nullable
        private final StatsPerStorage otherStoragesStats;

        @NotNull
        public final Map<String, StatsPerStorage> getIndexStoragesStats() {
            return this.indexStoragesStats;
        }

        @Nullable
        public final StatsPerStorage getOtherStoragesStats() {
            return this.otherStoragesStats;
        }

        public IndexStorageStats(@NotNull Map<String, StatsPerStorage> indexStoragesStats, @Nullable StatsPerStorage otherStoragesStats) {
            Intrinsics.checkNotNullParameter(indexStoragesStats, (String)"indexStoragesStats");
            this.indexStoragesStats = indexStoragesStats;
            this.otherStoragesStats = otherStoragesStats;
        }

        @NotNull
        public final Map<String, StatsPerStorage> component1() {
            return this.indexStoragesStats;
        }

        @Nullable
        public final StatsPerStorage component2() {
            return this.otherStoragesStats;
        }

        @NotNull
        public final IndexStorageStats copy(@NotNull Map<String, StatsPerStorage> indexStoragesStats, @Nullable StatsPerStorage otherStoragesStats) {
            Intrinsics.checkNotNullParameter(indexStoragesStats, (String)"indexStoragesStats");
            return new IndexStorageStats(indexStoragesStats, otherStoragesStats);
        }

        public static /* synthetic */ IndexStorageStats copy$default(IndexStorageStats indexStorageStats, Map map2, StatsPerStorage statsPerStorage, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = indexStorageStats.indexStoragesStats;
            }
            if ((n & 2) != 0) {
                statsPerStorage = indexStorageStats.otherStoragesStats;
            }
            return indexStorageStats.copy(map2, statsPerStorage);
        }

        @NotNull
        public String toString() {
            return "IndexStorageStats(indexStoragesStats=" + this.indexStoragesStats + ", otherStoragesStats=" + this.otherStoragesStats + ")";
        }

        public int hashCode() {
            Map<String, StatsPerStorage> map2 = this.indexStoragesStats;
            StatsPerStorage statsPerStorage = this.otherStoragesStats;
            return (map2 != null ? ((Object)map2).hashCode() : 0) * 31 + (statsPerStorage != null ? ((Object)statsPerStorage).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexStorageStats)) break block3;
                    IndexStorageStats indexStorageStats = (IndexStorageStats)object;
                    if (!Intrinsics.areEqual(this.indexStoragesStats, indexStorageStats.indexStoragesStats) || !Intrinsics.areEqual((Object)this.otherStoragesStats, (Object)indexStorageStats.otherStoragesStats)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0087\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J5\u0010\u000e\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0010H\u0007J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0000J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "", "statsPerPhm", "Ljava/util/SortedMap;", "", "Lcom/intellij/util/io/stats/PersistentHashMapStatistics;", "statsPerEnumerator", "Lcom/intellij/util/io/stats/PersistentEnumeratorStatistics;", "(Ljava/util/SortedMap;Ljava/util/SortedMap;)V", "getStatsPerEnumerator", "()Ljava/util/SortedMap;", "getStatsPerPhm", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isEmpty", "nullize", "plus", "another", "toString", "Companion", "intellij.platform.lang.impl"})
    public static final class StatsPerStorage {
        @NotNull
        private final SortedMap<String, PersistentHashMapStatistics> statsPerPhm;
        @NotNull
        private final SortedMap<String, PersistentEnumeratorStatistics> statsPerEnumerator;
        @NotNull
        private static final StatsPerStorage EMPTY;
        @NotNull
        public static final Companion Companion;

        @NotNull
        public final StatsPerStorage plus(@NotNull StatsPerStorage another) {
            Intrinsics.checkNotNullParameter((Object)another, (String)"another");
            return new StatsPerStorage(MapsKt.toSortedMap((Map)MapsKt.plus((Map)this.statsPerPhm, (Map)another.statsPerPhm)), MapsKt.toSortedMap((Map)MapsKt.plus((Map)this.statsPerEnumerator, (Map)another.statsPerEnumerator)));
        }

        @JsonIgnore
        public final boolean isEmpty() {
            return this.statsPerPhm.isEmpty() && this.statsPerEnumerator.isEmpty();
        }

        @Nullable
        public final StatsPerStorage nullize() {
            return this.isEmpty() ? null : this;
        }

        @NotNull
        public final SortedMap<String, PersistentHashMapStatistics> getStatsPerPhm() {
            return this.statsPerPhm;
        }

        @NotNull
        public final SortedMap<String, PersistentEnumeratorStatistics> getStatsPerEnumerator() {
            return this.statsPerEnumerator;
        }

        public StatsPerStorage(@NotNull SortedMap<String, PersistentHashMapStatistics> statsPerPhm, @NotNull SortedMap<String, PersistentEnumeratorStatistics> statsPerEnumerator) {
            Intrinsics.checkNotNullParameter(statsPerPhm, (String)"statsPerPhm");
            Intrinsics.checkNotNullParameter(statsPerEnumerator, (String)"statsPerEnumerator");
            this.statsPerPhm = statsPerPhm;
            this.statsPerEnumerator = statsPerEnumerator;
        }

        static {
            Companion = new Companion(null);
            EMPTY = new StatsPerStorage(MapsKt.sortedMapOf((Pair[])new Pair[0]), MapsKt.sortedMapOf((Pair[])new Pair[0]));
        }

        @NotNull
        public final SortedMap<String, PersistentHashMapStatistics> component1() {
            return this.statsPerPhm;
        }

        @NotNull
        public final SortedMap<String, PersistentEnumeratorStatistics> component2() {
            return this.statsPerEnumerator;
        }

        @NotNull
        public final StatsPerStorage copy(@NotNull SortedMap<String, PersistentHashMapStatistics> statsPerPhm, @NotNull SortedMap<String, PersistentEnumeratorStatistics> statsPerEnumerator) {
            Intrinsics.checkNotNullParameter(statsPerPhm, (String)"statsPerPhm");
            Intrinsics.checkNotNullParameter(statsPerEnumerator, (String)"statsPerEnumerator");
            return new StatsPerStorage(statsPerPhm, statsPerEnumerator);
        }

        public static /* synthetic */ StatsPerStorage copy$default(StatsPerStorage statsPerStorage, SortedMap sortedMap2, SortedMap sortedMap3, int n, Object object) {
            if ((n & 1) != 0) {
                sortedMap2 = statsPerStorage.statsPerPhm;
            }
            if ((n & 2) != 0) {
                sortedMap3 = statsPerStorage.statsPerEnumerator;
            }
            return statsPerStorage.copy(sortedMap2, sortedMap3);
        }

        @NotNull
        public String toString() {
            return "StatsPerStorage(statsPerPhm=" + this.statsPerPhm + ", statsPerEnumerator=" + this.statsPerEnumerator + ")";
        }

        public int hashCode() {
            SortedMap<String, PersistentHashMapStatistics> sortedMap2 = this.statsPerPhm;
            SortedMap<String, PersistentEnumeratorStatistics> sortedMap3 = this.statsPerEnumerator;
            return (sortedMap2 != null ? sortedMap2.hashCode() : 0) * 31 + (sortedMap3 != null ? sortedMap3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerStorage)) break block3;
                    StatsPerStorage statsPerStorage = (StatsPerStorage)object;
                    if (!Intrinsics.areEqual(this.statsPerPhm, statsPerStorage.statsPerPhm) || !Intrinsics.areEqual(this.statsPerEnumerator, statsPerStorage.statsPerEnumerator)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage$Companion;", "", "()V", "EMPTY", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "getEMPTY", "()Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "intellij.platform.lang.impl"})
        public static final class Companion {
            @NotNull
            public final StatsPerStorage getEMPTY() {
                return EMPTY;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J7\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StorageDataStats;", "", "pageCacheStats", "Lcom/intellij/util/io/stats/FilePageCacheStatistics;", "vfsStorageStats", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "indexStorageStats", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$IndexStorageStats;", "otherStorageStats", "(Lcom/intellij/util/io/stats/FilePageCacheStatistics;Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$IndexStorageStats;Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;)V", "getIndexStorageStats", "()Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$IndexStorageStats;", "getOtherStorageStats", "()Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "getPageCacheStats", "()Lcom/intellij/util/io/stats/FilePageCacheStatistics;", "getVfsStorageStats", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class StorageDataStats {
        @NotNull
        private final FilePageCacheStatistics pageCacheStats;
        @Nullable
        private final StatsPerStorage vfsStorageStats;
        @Nullable
        private final IndexStorageStats indexStorageStats;
        @Nullable
        private final StatsPerStorage otherStorageStats;

        @NotNull
        public final FilePageCacheStatistics getPageCacheStats() {
            return this.pageCacheStats;
        }

        @Nullable
        public final StatsPerStorage getVfsStorageStats() {
            return this.vfsStorageStats;
        }

        @Nullable
        public final IndexStorageStats getIndexStorageStats() {
            return this.indexStorageStats;
        }

        @Nullable
        public final StatsPerStorage getOtherStorageStats() {
            return this.otherStorageStats;
        }

        public StorageDataStats(@NotNull FilePageCacheStatistics pageCacheStats, @Nullable StatsPerStorage vfsStorageStats, @Nullable IndexStorageStats indexStorageStats, @Nullable StatsPerStorage otherStorageStats) {
            Intrinsics.checkNotNullParameter((Object)pageCacheStats, (String)"pageCacheStats");
            this.pageCacheStats = pageCacheStats;
            this.vfsStorageStats = vfsStorageStats;
            this.indexStorageStats = indexStorageStats;
            this.otherStorageStats = otherStorageStats;
        }

        @NotNull
        public final FilePageCacheStatistics component1() {
            return this.pageCacheStats;
        }

        @Nullable
        public final StatsPerStorage component2() {
            return this.vfsStorageStats;
        }

        @Nullable
        public final IndexStorageStats component3() {
            return this.indexStorageStats;
        }

        @Nullable
        public final StatsPerStorage component4() {
            return this.otherStorageStats;
        }

        @NotNull
        public final StorageDataStats copy(@NotNull FilePageCacheStatistics pageCacheStats, @Nullable StatsPerStorage vfsStorageStats, @Nullable IndexStorageStats indexStorageStats, @Nullable StatsPerStorage otherStorageStats) {
            Intrinsics.checkNotNullParameter((Object)pageCacheStats, (String)"pageCacheStats");
            return new StorageDataStats(pageCacheStats, vfsStorageStats, indexStorageStats, otherStorageStats);
        }

        public static /* synthetic */ StorageDataStats copy$default(StorageDataStats storageDataStats, FilePageCacheStatistics filePageCacheStatistics, StatsPerStorage statsPerStorage, IndexStorageStats indexStorageStats, StatsPerStorage statsPerStorage2, int n, Object object) {
            if ((n & 1) != 0) {
                filePageCacheStatistics = storageDataStats.pageCacheStats;
            }
            if ((n & 2) != 0) {
                statsPerStorage = storageDataStats.vfsStorageStats;
            }
            if ((n & 4) != 0) {
                indexStorageStats = storageDataStats.indexStorageStats;
            }
            if ((n & 8) != 0) {
                statsPerStorage2 = storageDataStats.otherStorageStats;
            }
            return storageDataStats.copy(filePageCacheStatistics, statsPerStorage, indexStorageStats, statsPerStorage2);
        }

        @NotNull
        public String toString() {
            return "StorageDataStats(pageCacheStats=" + this.pageCacheStats + ", vfsStorageStats=" + this.vfsStorageStats + ", indexStorageStats=" + this.indexStorageStats + ", otherStorageStats=" + this.otherStorageStats + ")";
        }

        public int hashCode() {
            FilePageCacheStatistics filePageCacheStatistics = this.pageCacheStats;
            StatsPerStorage statsPerStorage = this.vfsStorageStats;
            IndexStorageStats indexStorageStats = this.indexStorageStats;
            StatsPerStorage statsPerStorage2 = this.otherStorageStats;
            return (((filePageCacheStatistics != null ? ((Object)filePageCacheStatistics).hashCode() : 0) * 31 + (statsPerStorage != null ? ((Object)statsPerStorage).hashCode() : 0)) * 31 + (indexStorageStats != null ? ((Object)indexStorageStats).hashCode() : 0)) * 31 + (statsPerStorage2 != null ? ((Object)statsPerStorage2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StorageDataStats)) break block3;
                    StorageDataStats storageDataStats = (StorageDataStats)object;
                    if (!Intrinsics.areEqual((Object)this.pageCacheStats, (Object)storageDataStats.pageCacheStats) || !Intrinsics.areEqual((Object)this.vfsStorageStats, (Object)storageDataStats.vfsStorageStats) || !Intrinsics.areEqual((Object)this.indexStorageStats, (Object)storageDataStats.indexStorageStats) || !Intrinsics.areEqual((Object)this.otherStorageStats, (Object)storageDataStats.otherStorageStats)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

