/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.diagnostic.BiggestFileTypeContributor;
import com.intellij.util.indexing.diagnostic.IndexingFileSetStatistics;
import com.intellij.util.indexing.diagnostic.IndexingTimes;
import com.intellij.util.indexing.diagnostic.LimitedPriorityQueue;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl$Stage$CreatingIterators$getProperty$1;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl$Stage$Indexing$getProperty$1;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl$Stage$PushProperties$getProperty$1;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl$Stage$Scanning$getProperty$1;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl$times$2;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import com.intellij.util.indexing.diagnostic.ScanningType;
import com.intellij.util.indexing.diagnostic.SnapshotInputMappingStats;
import com.intellij.util.indexing.diagnostic.StatsPerFileType;
import com.intellij.util.indexing.diagnostic.StatsPerIndexer;
import com.intellij.util.indexing.diagnostic.dto.JsonConverterKt;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0087\b\u0018\u0000 \\2\u00020\u0001:\b[\\]^_`abB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u0002072\u0006\u00108\u001a\u00020;J\u0014\u0010<\u001a\u0002072\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>J\t\u0010@\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010A\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010B\u001a\u00020\u0007H\u00c2\u0003J)\u0010C\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010GH\u00d6\u0003J\u0006\u0010H\u001a\u000207J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020\r0>H\u0002J\t\u0010J\u001a\u00020\nH\u00d6\u0001J\u0006\u0010K\u001a\u000207J\u000e\u0010L\u001a\u0002072\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u0002072\u0006\u0010P\u001a\u00020EJ\u000e\u0010Q\u001a\u0002072\u0006\u0010R\u001a\u00020SJ\u0018\u0010Q\u001a\u0002072\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0007J\u000e\u0010V\u001a\u0002072\u0006\u0010R\u001a\u00020SJ\u0018\u0010V\u001a\u0002072\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0007J\u0006\u0010W\u001a\u000207J\u0010\u0010W\u001a\u0002072\u0006\u0010T\u001a\u00020UH\u0007J\u0006\u0010X\u001a\u000207J\u0010\u0010X\u001a\u0002072\u0006\u0010T\u001a\u00020UH\u0007J\t\u0010Y\u001a\u00020\u0005H\u00d6\u0001J\b\u0010Z\u001a\u000207H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u0017j\b\u0012\u0004\u0012\u00020\u001d`\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010'\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020)0(j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020)`*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R0\u0010-\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020.0(j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020.`*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010,R\u001a\u00100\u001a\u000201X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006c"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "project", "Lcom/intellij/openapi/project/Project;", "indexingReason", "", "scanningType", "Lcom/intellij/util/indexing/diagnostic/ScanningType;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/util/indexing/diagnostic/ScanningType;)V", "biggestContributorsPerFileTypeLimit", "", "events", "", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Event;", "getIndexingReason", "()Ljava/lang/String;", "indexingSessionId", "", "getIndexingSessionId", "()J", "getProject", "()Lcom/intellij/openapi/project/Project;", "providerStatistics", "Ljava/util/ArrayList;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonFileProviderIndexStatistics;", "Lkotlin/collections/ArrayList;", "getProviderStatistics", "()Ljava/util/ArrayList;", "scanningStatistics", "Lcom/intellij/util/indexing/diagnostic/dto/JsonScanningStatistics;", "getScanningStatistics", "times", "Lcom/intellij/util/indexing/diagnostic/IndexingTimes;", "getTimes", "()Lcom/intellij/util/indexing/diagnostic/IndexingTimes;", "times$delegate", "Lkotlin/reflect/KProperty0;", "timesImpl", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$IndexingTimesImpl;", "totalStatsPerFileType", "Ljava/util/HashMap;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$StatsPerFileTypeImpl;", "Lkotlin/collections/HashMap;", "getTotalStatsPerFileType", "()Ljava/util/HashMap;", "totalStatsPerIndexer", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$StatsPerIndexerImpl;", "getTotalStatsPerIndexer", "visibleTimeToAllThreadsTimeRatio", "", "getVisibleTimeToAllThreadsTimeRatio", "()D", "setVisibleTimeToAllThreadsTimeRatio", "(D)V", "addProviderStatistics", "", "statistics", "Lcom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics;", "addScanningStatistics", "Lcom/intellij/util/indexing/diagnostic/ScanningStatistics;", "addSnapshotInputMappingStatistics", "snapshotInputMappingsStatistics", "", "Lcom/intellij/util/indexing/snapshot/SnapshotInputMappingsStatistics;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "finishTotalUpdatingTime", "getNormalizedEvents", "hashCode", "indexingFinished", "setScanFilesDuration", "duration", "Ljava/time/Duration;", "setWasInterrupted", "interrupted", "startStage", "stage", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage;", "instant", "Ljava/time/Instant;", "stopStage", "stopSuspendingStages", "suspendStages", "toString", "writeStagesToDurations", "BiggestFileTypeContributorImpl", "Companion", "Event", "IndexingTimesImpl", "SnapshotInputMappingStatsImpl", "Stage", "StatsPerFileTypeImpl", "StatsPerIndexerImpl", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class ProjectIndexingHistoryImpl
implements ProjectIndexingHistory {
    private final long indexingSessionId;
    private final int biggestContributorsPerFileTypeLimit;
    @NotNull
    private final KProperty0 times$delegate;
    private final IndexingTimesImpl timesImpl;
    @NotNull
    private final ArrayList<JsonScanningStatistics> scanningStatistics;
    @NotNull
    private final ArrayList<JsonFileProviderIndexStatistics> providerStatistics;
    @NotNull
    private final HashMap<String, StatsPerFileTypeImpl> totalStatsPerFileType;
    @NotNull
    private final HashMap<String, StatsPerIndexerImpl> totalStatsPerIndexer;
    private double visibleTimeToAllThreadsTimeRatio;
    private final List<Event> events;
    @NotNull
    private final Project project;
    @Nullable
    private final String indexingReason;
    private final ScanningType scanningType;
    @Deprecated
    @NotNull
    private static final AtomicLong indexingSessionIdSequencer;
    @Deprecated
    @NotNull
    private static final Logger log;
    @NotNull
    private static final Companion Companion;

    @Override
    public long getIndexingSessionId() {
        return this.indexingSessionId;
    }

    @Override
    @NotNull
    public IndexingTimes getTimes() {
        KProperty0 kProperty0 = this.times$delegate;
        ProjectIndexingHistoryImpl projectIndexingHistoryImpl = this;
        Object var3_3 = null;
        return (IndexingTimes)kProperty0.get();
    }

    @NotNull
    public ArrayList<JsonScanningStatistics> getScanningStatistics() {
        return this.scanningStatistics;
    }

    @NotNull
    public ArrayList<JsonFileProviderIndexStatistics> getProviderStatistics() {
        return this.providerStatistics;
    }

    @NotNull
    public HashMap<String, StatsPerFileTypeImpl> getTotalStatsPerFileType() {
        return this.totalStatsPerFileType;
    }

    @NotNull
    public HashMap<String, StatsPerIndexerImpl> getTotalStatsPerIndexer() {
        return this.totalStatsPerIndexer;
    }

    @Override
    public double getVisibleTimeToAllThreadsTimeRatio() {
        return this.visibleTimeToAllThreadsTimeRatio;
    }

    public void setVisibleTimeToAllThreadsTimeRatio(double d) {
        this.visibleTimeToAllThreadsTimeRatio = d;
    }

    public final void addScanningStatistics(@NotNull ScanningStatistics statistics) {
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        Collection collection = this.getScanningStatistics();
        JsonScanningStatistics jsonScanningStatistics = JsonConverterKt.toJsonStatistics(statistics);
        collection.add(jsonScanningStatistics);
    }

    /*
     * WARNING - void declaration
     */
    public final void addProviderStatistics(@NotNull IndexingFileSetStatistics statistics) {
        Object totalStats;
        Object answer$iv;
        Object value$iv;
        Object fileType;
        boolean $i$f$getOrPut;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        Map.Entry entry3 = this.getProviderStatistics();
        Iterator iterator = JsonConverterKt.toJsonStatistics(statistics, this.getVisibleTimeToAllThreadsTimeRatio());
        entry3.add(iterator);
        Object object = statistics.getStatsPerFileType();
        iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2;
            Map.Entry entry2 = entry3 = (Map.Entry)iterator.next();
            object = (String)entry2.getKey();
            entry2 = entry3;
            IndexingFileSetStatistics.StatsPerFileType fileTypeStats = (IndexingFileSetStatistics.StatsPerFileType)entry2.getValue();
            $this$getOrPut$iv = this.getTotalStatsPerFileType();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(fileType);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new StatsPerFileTypeImpl(0, 0L, 0L, 0L, new LimitedPriorityQueue<BiggestFileTypeContributorImpl>(this.biggestContributorsPerFileTypeLimit, new Comparator(){

                    public final int compare(T a, T b) {
                        BiggestFileTypeContributorImpl it = (BiggestFileTypeContributorImpl)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getProcessingTimeInAllThreads());
                        it = (BiggestFileTypeContributorImpl)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        Comparable comparable3 = Long.valueOf(it.getProcessingTimeInAllThreads());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                    }
                }));
                $this$getOrPut$iv.put(fileType, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            Object object3 = totalStats = (StatsPerFileTypeImpl)object2;
            ((StatsPerFileTypeImpl)object3).setTotalNumberOfFiles(((StatsPerFileTypeImpl)object3).getTotalNumberOfFiles() + fileTypeStats.getNumberOfFiles());
            Object object4 = totalStats;
            ((StatsPerFileTypeImpl)object4).setTotalBytes(((StatsPerFileTypeImpl)object4).getTotalBytes() + fileTypeStats.getTotalBytes());
            Object object5 = totalStats;
            ((StatsPerFileTypeImpl)object5).setTotalProcessingTimeInAllThreads(((StatsPerFileTypeImpl)object5).getTotalProcessingTimeInAllThreads() + fileTypeStats.getProcessingTimeInAllThreads());
            Object object6 = totalStats;
            ((StatsPerFileTypeImpl)object6).setTotalContentLoadingTimeInAllThreads(((StatsPerFileTypeImpl)object6).getTotalContentLoadingTimeInAllThreads() + fileTypeStats.getContentLoadingTimeInAllThreads());
            ((StatsPerFileTypeImpl)totalStats).getBiggestFileTypeContributors().addElement(new BiggestFileTypeContributorImpl(statistics.getFileSetName(), fileTypeStats.getNumberOfFiles(), fileTypeStats.getTotalBytes(), fileTypeStats.getProcessingTimeInAllThreads()));
        }
        fileType = statistics.getStatsPerIndexer();
        for (Map.Entry entry3 : fileType.entrySet()) {
            Object object7;
            void indexId;
            totalStats = entry3;
            fileType = (String)totalStats.getKey();
            totalStats = entry3;
            IndexingFileSetStatistics.StatsPerIndexer stats = (IndexingFileSetStatistics.StatsPerIndexer)totalStats.getValue();
            $this$getOrPut$iv = this.getTotalStatsPerIndexer();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(indexId);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new StatsPerIndexerImpl(0, 0, 0L, 0L, new SnapshotInputMappingStatsImpl(0L, 0L));
                $this$getOrPut$iv.put(indexId, answer$iv);
                object7 = answer$iv;
            } else {
                object7 = value$iv;
            }
            Object object8 = totalStats = (StatsPerIndexerImpl)object7;
            ((StatsPerIndexerImpl)object8).setTotalNumberOfFiles(((StatsPerIndexerImpl)object8).getTotalNumberOfFiles() + stats.getNumberOfFiles());
            Object object9 = totalStats;
            ((StatsPerIndexerImpl)object9).setTotalNumberOfFilesIndexedByExtensions(((StatsPerIndexerImpl)object9).getTotalNumberOfFilesIndexedByExtensions() + stats.getNumberOfFilesIndexedByExtensions());
            Object object10 = totalStats;
            ((StatsPerIndexerImpl)object10).setTotalBytes(((StatsPerIndexerImpl)object10).getTotalBytes() + stats.getTotalBytes());
            Object object11 = totalStats;
            ((StatsPerIndexerImpl)object11).setTotalIndexingTimeInAllThreads(((StatsPerIndexerImpl)object11).getTotalIndexingTimeInAllThreads() + stats.getIndexingTime());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addSnapshotInputMappingStatistics(@NotNull List<SnapshotInputMappingsStatistics> snapshotInputMappingsStatistics) {
        Intrinsics.checkNotNullParameter(snapshotInputMappingsStatistics, (String)"snapshotInputMappingsStatistics");
        for (SnapshotInputMappingsStatistics mappingsStatistic : snapshotInputMappingsStatistics) {
            Object object;
            String key$iv;
            void $this$getOrPut$iv;
            Map map2 = this.getTotalStatsPerIndexer();
            ID<?, ?> iD = mappingsStatistic.getIndexId();
            Intrinsics.checkNotNullExpressionValue(iD, (String)"mappingsStatistic.indexId");
            Intrinsics.checkNotNullExpressionValue((Object)iD.getName(), (String)"mappingsStatistic.indexId.name");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                StatsPerIndexerImpl answer$iv = new StatsPerIndexerImpl(0, 0, 0L, 0L, new SnapshotInputMappingStatsImpl(0L, 0L));
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            StatsPerIndexerImpl totalStats = (StatsPerIndexerImpl)object;
            SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl = totalStats.getSnapshotInputMappingStats();
            snapshotInputMappingStatsImpl.setRequests(snapshotInputMappingStatsImpl.getRequests() + mappingsStatistic.getTotalRequests());
            SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl2 = totalStats.getSnapshotInputMappingStats();
            snapshotInputMappingStatsImpl2.setMisses(snapshotInputMappingStatsImpl2.getMisses() + mappingsStatistic.getTotalMisses());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startStage(@NotNull Stage stage) {
        List<Event> list2;
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        List<Event> list3 = list2 = this.events;
        synchronized (list3) {
            boolean bl = false;
            boolean bl2 = this.events.add(new Event.StageEvent(stage, true, null, 4, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopStage(@NotNull Stage stage) {
        List<Event> list2;
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        List<Event> list3 = list2 = this.events;
        synchronized (list3) {
            boolean bl = false;
            boolean bl2 = this.events.add(new Event.StageEvent(stage, false, null, 4, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspendStages() {
        List<Event> list2;
        List<Event> list3 = list2 = this.events;
        synchronized (list3) {
            boolean bl = false;
            boolean bl2 = this.events.add(new Event.SuspensionEvent(true, null, 2, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopSuspendingStages() {
        List<Event> list2;
        List<Event> list3 = list2 = this.events;
        synchronized (list3) {
            boolean bl = false;
            boolean bl2 = this.events.add(new Event.SuspensionEvent(false, null, 2, null));
        }
    }

    public final void indexingFinished() {
        this.writeStagesToDurations();
    }

    public final void setWasInterrupted(boolean interrupted) {
        this.timesImpl.setWasInterrupted(interrupted);
    }

    public final void finishTotalUpdatingTime() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.now(ZoneOffset.UTC)");
        this.timesImpl.setUpdatingEnd(zonedDateTime);
        this.timesImpl.setTotalUpdatingTime(System.nanoTime() - this.timesImpl.getTotalUpdatingTime());
    }

    public final void setScanFilesDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.timesImpl.setScanFilesDuration(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Event> getNormalizedEvents() {
        List<Event> list2;
        List normalizedEvents = new ArrayList();
        List<Event> list3 = list2 = this.events;
        synchronized (list3) {
            boolean bl = false;
            Instant suspensionStartTime = null;
            for (Event event : this.events) {
                Event event2 = event;
                if (event2 instanceof Event.SuspensionEvent) {
                    if (((Event.SuspensionEvent)event).getStarted()) {
                        if (suspensionStartTime != null) continue;
                        suspensionStartTime = event.getInstant();
                        continue;
                    }
                    if (suspensionStartTime == null) {
                        Event event3 = (Event)CollectionsKt.lastOrNull((List)normalizedEvents);
                        Instant instant = suspensionStartTime = event3 != null ? event3.getInstant() : null;
                    }
                    if (suspensionStartTime != null) {
                        normalizedEvents.add(new Event.SuspensionEvent(true, suspensionStartTime));
                        normalizedEvents.add(new Event.SuspensionEvent(false, event.getInstant()));
                    }
                    suspensionStartTime = null;
                    continue;
                }
                if (!(event2 instanceof Event.StageEvent)) continue;
                normalizedEvents.add(event);
                if (suspensionStartTime == null) continue;
                suspensionStartTime = event.getInstant();
            }
            Unit unit = Unit.INSTANCE;
        }
        return normalizedEvents;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeStagesToDurations() {
        List<Event> normalizedEvents = this.getNormalizedEvents();
        Duration suspendedDuration = Duration.ZERO;
        HashMap<Stage, Instant> startMap = new HashMap<Stage, Instant>();
        HashMap durationMap = new HashMap();
        for (Stage stage : Stage.values()) {
            Map map2 = durationMap;
            Duration duration = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ZERO");
            map2.put(stage, duration);
        }
        Instant suspendStart = null;
        for (Event event : normalizedEvents) {
            void var9_11;
            Event event2 = event;
            if (event2 instanceof Event.SuspensionEvent) {
                if (((Event.SuspensionEvent)event).getStarted()) {
                    Map map3 = startMap;
                    for (Map.Entry entry : map3.entrySet()) {
                        Map map4 = durationMap;
                        Object k = entry.getKey();
                        Object v = durationMap.get(entry.getKey());
                        Intrinsics.checkNotNull(v);
                        Duration duration = ((Duration)v).plus(Duration.between((Temporal)entry.getValue(), event.getInstant()));
                        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"durationMap[entry.key]!!\u2026ry.value, event.instant))");
                        map4.put(k, duration);
                    }
                    suspendStart = event.getInstant();
                } else {
                    if (suspendStart != null) {
                        suspendedDuration = suspendedDuration.plus(Duration.between(suspendStart, event.getInstant()));
                        suspendStart = null;
                    }
                    startMap.replaceAll(new BiFunction(event){
                        final /* synthetic */ Event $event;

                        @NotNull
                        public final Instant apply(@NotNull Stage $noName_0, @NotNull Instant $noName_1) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$noName_0), (String)"<anonymous parameter 0>");
                            Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                            return this.$event.getInstant();
                        }
                        {
                            this.$event = event;
                        }
                    });
                }
            } else if (event2 instanceof Event.StageEvent) {
                if (((Event.StageEvent)event).getStarted()) {
                    Instant instant = startMap.put(((Event.StageEvent)event).getStage(), event.getInstant());
                    log.assertTrue(instant == null, ((Event.StageEvent)event).getStage() + " is already started. Events " + normalizedEvents);
                } else {
                    Instant instant = (Instant)startMap.remove((Object)((Event.StageEvent)event).getStage());
                    log.assertTrue(instant != null, ((Event.StageEvent)event).getStage() + " is not started, tries to stop. Events " + normalizedEvents);
                    Map map5 = durationMap;
                    Stage stage = ((Event.StageEvent)event).getStage();
                    Object v = durationMap.get((Object)((Event.StageEvent)event).getStage());
                    Intrinsics.checkNotNull(v);
                    Duration duration = ((Duration)v).plus(Duration.between(instant, event.getInstant()));
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"durationMap[event.stage]\u2026en(start, event.instant))");
                    map5.put(stage, duration);
                }
            }
            Stage[] stageArray = Stage.values();
            int map3 = stageArray.length;
            boolean bl = false;
            while (var9_11 < map3) {
                Object stage = stageArray[var9_11];
                KMutableProperty1<IndexingTimesImpl, Duration> kMutableProperty1 = ((Stage)((Object)stage)).getProperty();
                Object v = durationMap.get(stage);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNullExpressionValue(v, (String)"durationMap[stage]!!");
                kMutableProperty1.set((Object)this.timesImpl, v);
                ++var9_11;
            }
            Duration duration = suspendedDuration;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"suspendedDuration");
            this.timesImpl.setSuspendedDuration(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void startStage(@NotNull Stage stage, @NotNull Instant instant) {
        List<Event> list2;
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        List<Event> list3 = list2 = this.events;
        synchronized (list3) {
            boolean bl = false;
            boolean bl2 = this.events.add(new Event.StageEvent(stage, true, instant));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void stopStage(@NotNull Stage stage, @NotNull Instant instant) {
        List<Event> list2;
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        List<Event> list3 = list2 = this.events;
        synchronized (list3) {
            boolean bl = false;
            boolean bl2 = this.events.add(new Event.StageEvent(stage, false, instant));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void suspendStages(@NotNull Instant instant) {
        List<Event> list2;
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        List<Event> list3 = list2 = this.events;
        synchronized (list3) {
            boolean bl = false;
            boolean bl2 = this.events.add(new Event.SuspensionEvent(true, instant));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void stopSuspendingStages(@NotNull Instant instant) {
        List<Event> list2;
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        List<Event> list3 = list2 = this.events;
        synchronized (list3) {
            boolean bl = false;
            boolean bl2 = this.events.add(new Event.SuspensionEvent(false, instant));
        }
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public String getIndexingReason() {
        return this.indexingReason;
    }

    public ProjectIndexingHistoryImpl(@NotNull Project project2, @Nullable String indexingReason, @NotNull ScanningType scanningType2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)scanningType2), (String)"scanningType");
        this.project = project2;
        this.indexingReason = indexingReason;
        this.scanningType = scanningType2;
        this.indexingSessionId = indexingSessionIdSequencer.getAndIncrement();
        this.biggestContributorsPerFileTypeLimit = 10;
        this.times$delegate = new ProjectIndexingHistoryImpl$times$2(this);
        String string2 = this.getIndexingReason();
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.now(ZoneOffset.UTC)");
        this.timesImpl = new IndexingTimesImpl(string2, this.scanningType, zonedDateTime, System.nanoTime(), null, null, null, null, null, null, null, null, false, 0L, false, 32752, null);
        this.scanningStatistics = new ArrayList();
        this.providerStatistics = new ArrayList();
        this.totalStatsPerFileType = new HashMap();
        this.totalStatsPerIndexer = new HashMap();
        this.events = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        indexingSessionIdSequencer = new AtomicLong();
        Companion $this$thisLogger$iv = Companion;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
    }

    public static final /* synthetic */ IndexingTimesImpl access$getTimesImpl$p(ProjectIndexingHistoryImpl $this) {
        return $this.timesImpl;
    }

    @NotNull
    public final Project component1() {
        return this.getProject();
    }

    @Nullable
    public final String component2() {
        return this.getIndexingReason();
    }

    private final ScanningType component3() {
        return this.scanningType;
    }

    @NotNull
    public final ProjectIndexingHistoryImpl copy(@NotNull Project project2, @Nullable String indexingReason, @NotNull ScanningType scanningType2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)scanningType2), (String)"scanningType");
        return new ProjectIndexingHistoryImpl(project2, indexingReason, scanningType2);
    }

    public static /* synthetic */ ProjectIndexingHistoryImpl copy$default(ProjectIndexingHistoryImpl projectIndexingHistoryImpl, Project project2, String string2, ScanningType scanningType2, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = projectIndexingHistoryImpl.getProject();
        }
        if ((n & 2) != 0) {
            string2 = projectIndexingHistoryImpl.getIndexingReason();
        }
        if ((n & 4) != 0) {
            scanningType2 = projectIndexingHistoryImpl.scanningType;
        }
        return projectIndexingHistoryImpl.copy(project2, string2, scanningType2);
    }

    @NotNull
    public String toString() {
        return "ProjectIndexingHistoryImpl(project=" + this.getProject() + ", indexingReason=" + this.getIndexingReason() + ", scanningType=" + this.scanningType + ")";
    }

    public int hashCode() {
        Project project2 = this.getProject();
        String string2 = this.getIndexingReason();
        ScanningType scanningType2 = this.scanningType;
        return ((project2 != null ? project2.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (scanningType2 != null ? ((Object)((Object)scanningType2)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ProjectIndexingHistoryImpl)) break block3;
                ProjectIndexingHistoryImpl projectIndexingHistoryImpl = (ProjectIndexingHistoryImpl)object;
                if (!Intrinsics.areEqual((Object)this.getProject(), (Object)projectIndexingHistoryImpl.getProject()) || !Intrinsics.areEqual((Object)this.getIndexingReason(), (Object)projectIndexingHistoryImpl.getIndexingReason()) || !Intrinsics.areEqual((Object)((Object)this.scanningType), (Object)((Object)projectIndexingHistoryImpl.scanningType))) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0006\u0007R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Event;", "", "instant", "Ljava/time/Instant;", "getInstant", "()Ljava/time/Instant;", "StageEvent", "SuspensionEvent", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Event$StageEvent;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Event$SuspensionEvent;", "intellij.platform.lang.impl"})
    private static interface Event {
        @NotNull
        public Instant getInstant();

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Event$StageEvent;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Event;", "stage", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage;", "started", "", "instant", "Ljava/time/Instant;", "(Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage;ZLjava/time/Instant;)V", "getInstant", "()Ljava/time/Instant;", "getStage", "()Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage;", "getStarted", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
        public static final class StageEvent
        implements Event {
            @NotNull
            private final Stage stage;
            private final boolean started;
            @NotNull
            private final Instant instant;

            @NotNull
            public final Stage getStage() {
                return this.stage;
            }

            public final boolean getStarted() {
                return this.started;
            }

            @Override
            @NotNull
            public Instant getInstant() {
                return this.instant;
            }

            public StageEvent(@NotNull Stage stage, boolean started, @NotNull Instant instant) {
                Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
                Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
                this.stage = stage;
                this.started = started;
                this.instant = instant;
            }

            public /* synthetic */ StageEvent(Stage stage, boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    Instant instant2 = Instant.now();
                    Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"Instant.now()");
                    instant = instant2;
                }
                this(stage, bl, instant);
            }

            @NotNull
            public final Stage component1() {
                return this.stage;
            }

            public final boolean component2() {
                return this.started;
            }

            @NotNull
            public final Instant component3() {
                return this.getInstant();
            }

            @NotNull
            public final StageEvent copy(@NotNull Stage stage, boolean started, @NotNull Instant instant) {
                Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
                Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
                return new StageEvent(stage, started, instant);
            }

            public static /* synthetic */ StageEvent copy$default(StageEvent stageEvent, Stage stage, boolean bl, Instant instant, int n, Object object) {
                if ((n & 1) != 0) {
                    stage = stageEvent.stage;
                }
                if ((n & 2) != 0) {
                    bl = stageEvent.started;
                }
                if ((n & 4) != 0) {
                    instant = stageEvent.getInstant();
                }
                return stageEvent.copy(stage, bl, instant);
            }

            @NotNull
            public String toString() {
                return "StageEvent(stage=" + this.stage + ", started=" + this.started + ", instant=" + this.getInstant() + ")";
            }

            public int hashCode() {
                Stage stage = this.stage;
                int n = (stage != null ? ((Object)((Object)stage)).hashCode() : 0) * 31;
                int n2 = this.started ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                Instant instant = this.getInstant();
                return (n + n2) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StageEvent)) break block3;
                        StageEvent stageEvent = (StageEvent)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.stage), (Object)((Object)stageEvent.stage)) || this.started != stageEvent.started || !Intrinsics.areEqual((Object)this.getInstant(), (Object)stageEvent.getInstant())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Event$SuspensionEvent;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Event;", "started", "", "instant", "Ljava/time/Instant;", "(ZLjava/time/Instant;)V", "getInstant", "()Ljava/time/Instant;", "getStarted", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
        public static final class SuspensionEvent
        implements Event {
            private final boolean started;
            @NotNull
            private final Instant instant;

            public final boolean getStarted() {
                return this.started;
            }

            @Override
            @NotNull
            public Instant getInstant() {
                return this.instant;
            }

            public SuspensionEvent(boolean started, @NotNull Instant instant) {
                Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
                this.started = started;
                this.instant = instant;
            }

            public /* synthetic */ SuspensionEvent(boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    Instant instant2 = Instant.now();
                    Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"Instant.now()");
                    instant = instant2;
                }
                this(bl, instant);
            }

            public final boolean component1() {
                return this.started;
            }

            @NotNull
            public final Instant component2() {
                return this.getInstant();
            }

            @NotNull
            public final SuspensionEvent copy(boolean started, @NotNull Instant instant) {
                Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
                return new SuspensionEvent(started, instant);
            }

            public static /* synthetic */ SuspensionEvent copy$default(SuspensionEvent suspensionEvent, boolean bl, Instant instant, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = suspensionEvent.started;
                }
                if ((n & 2) != 0) {
                    instant = suspensionEvent.getInstant();
                }
                return suspensionEvent.copy(bl, instant);
            }

            @NotNull
            public String toString() {
                return "SuspensionEvent(started=" + this.started + ", instant=" + this.getInstant() + ")";
            }

            public int hashCode() {
                int n = this.started ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                Instant instant = this.getInstant();
                return n * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof SuspensionEvent)) break block3;
                        SuspensionEvent suspensionEvent = (SuspensionEvent)object;
                        if (this.started != suspensionEvent.started || !Intrinsics.areEqual((Object)this.getInstant(), (Object)suspensionEvent.getInstant())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H&j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage;", "", "(Ljava/lang/String;I)V", "getProperty", "Lkotlin/reflect/KMutableProperty1;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$IndexingTimesImpl;", "Ljava/time/Duration;", "CreatingIterators", "Scanning", "Indexing", "PushProperties", "intellij.platform.lang.impl"})
    public static final abstract class Stage
    extends Enum<Stage> {
        public static final /* enum */ Stage CreatingIterators;
        public static final /* enum */ Stage Scanning;
        public static final /* enum */ Stage Indexing;
        public static final /* enum */ Stage PushProperties;
        private static final /* synthetic */ Stage[] $VALUES;

        static {
            Stage[] stageArray = new Stage[4];
            Stage[] stageArray2 = stageArray;
            stageArray[0] = CreatingIterators = new CreatingIterators("CreatingIterators", 0);
            stageArray[1] = Scanning = new Scanning("Scanning", 1);
            stageArray[2] = Indexing = new Indexing("Indexing", 2);
            stageArray[3] = PushProperties = new PushProperties("PushProperties", 3);
            $VALUES = stageArray;
        }

        @NotNull
        public abstract KMutableProperty1<IndexingTimesImpl, Duration> getProperty();

        private Stage() {
        }

        public /* synthetic */ Stage(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static Stage[] values() {
            return (Stage[])$VALUES.clone();
        }

        public static Stage valueOf(String string2) {
            return Enum.valueOf(Stage.class, string2);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage$CreatingIterators;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage;", "getProperty", "Lkotlin/reflect/KMutableProperty1;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$IndexingTimesImpl;", "Ljava/time/Duration;", "intellij.platform.lang.impl"})
        static final class CreatingIterators
        extends Stage {
            @Override
            @NotNull
            public KMutableProperty1<IndexingTimesImpl, Duration> getProperty() {
                return ProjectIndexingHistoryImpl$Stage$CreatingIterators$getProperty$1.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            CreatingIterators() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage$Scanning;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage;", "getProperty", "Lkotlin/reflect/KMutableProperty1;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$IndexingTimesImpl;", "Ljava/time/Duration;", "intellij.platform.lang.impl"})
        static final class Scanning
        extends Stage {
            @Override
            @NotNull
            public KMutableProperty1<IndexingTimesImpl, Duration> getProperty() {
                return ProjectIndexingHistoryImpl$Stage$Scanning$getProperty$1.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            Scanning() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage$Indexing;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage;", "getProperty", "Lkotlin/reflect/KMutableProperty1;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$IndexingTimesImpl;", "Ljava/time/Duration;", "intellij.platform.lang.impl"})
        static final class Indexing
        extends Stage {
            @Override
            @NotNull
            public KMutableProperty1<IndexingTimesImpl, Duration> getProperty() {
                return ProjectIndexingHistoryImpl$Stage$Indexing$getProperty$1.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            Indexing() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage$PushProperties;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Stage;", "getProperty", "Lkotlin/reflect/KMutableProperty1;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$IndexingTimesImpl;", "Ljava/time/Duration;", "intellij.platform.lang.impl"})
        static final class PushProperties
        extends Stage {
            @Override
            @NotNull
            public KMutableProperty1<IndexingTimesImpl, Duration> getProperty() {
                return ProjectIndexingHistoryImpl$Stage$PushProperties$getProperty$1.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            PushProperties() {
                void var1_1;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0005j\u0002`\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\"\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J\r\u0010#\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J\r\u0010$\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JM\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\b\u0002\u0010\u0007\u001a\u00060\u0005j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0005j\u0002`\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\t\u001a\u00060\u0005j\u0002`\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u0007\u001a\u00060\u0005j\u0002`\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u0018\u00a8\u0006."}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$StatsPerFileTypeImpl;", "Lcom/intellij/util/indexing/diagnostic/StatsPerFileType;", "totalNumberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalProcessingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "totalContentLoadingTimeInAllThreads", "biggestFileTypeContributors", "Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$BiggestFileTypeContributorImpl;", "(IJJJLcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;)V", "biggestFileTypeContributorList", "", "Lcom/intellij/util/indexing/diagnostic/BiggestFileTypeContributor;", "getBiggestFileTypeContributorList", "()Ljava/util/List;", "getBiggestFileTypeContributors", "()Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "getTotalContentLoadingTimeInAllThreads", "setTotalContentLoadingTimeInAllThreads", "getTotalNumberOfFiles", "()I", "setTotalNumberOfFiles", "(I)V", "getTotalProcessingTimeInAllThreads", "setTotalProcessingTimeInAllThreads", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerFileTypeImpl
    implements StatsPerFileType {
        private int totalNumberOfFiles;
        private long totalBytes;
        private long totalProcessingTimeInAllThreads;
        private long totalContentLoadingTimeInAllThreads;
        @NotNull
        private final LimitedPriorityQueue<BiggestFileTypeContributorImpl> biggestFileTypeContributors;

        @Override
        @NotNull
        public List<BiggestFileTypeContributor> getBiggestFileTypeContributorList() {
            return this.biggestFileTypeContributors.getBiggestElements();
        }

        @Override
        public int getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public void setTotalNumberOfFiles(int n) {
            this.totalNumberOfFiles = n;
        }

        @Override
        public long getTotalBytes() {
            return this.totalBytes;
        }

        public void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        @Override
        public long getTotalProcessingTimeInAllThreads() {
            return this.totalProcessingTimeInAllThreads;
        }

        public void setTotalProcessingTimeInAllThreads(long l) {
            this.totalProcessingTimeInAllThreads = l;
        }

        @Override
        public long getTotalContentLoadingTimeInAllThreads() {
            return this.totalContentLoadingTimeInAllThreads;
        }

        public void setTotalContentLoadingTimeInAllThreads(long l) {
            this.totalContentLoadingTimeInAllThreads = l;
        }

        @NotNull
        public final LimitedPriorityQueue<BiggestFileTypeContributorImpl> getBiggestFileTypeContributors() {
            return this.biggestFileTypeContributors;
        }

        public StatsPerFileTypeImpl(int totalNumberOfFiles, long totalBytes, long totalProcessingTimeInAllThreads, long totalContentLoadingTimeInAllThreads, @NotNull LimitedPriorityQueue<BiggestFileTypeContributorImpl> biggestFileTypeContributors) {
            Intrinsics.checkNotNullParameter(biggestFileTypeContributors, (String)"biggestFileTypeContributors");
            this.totalNumberOfFiles = totalNumberOfFiles;
            this.totalBytes = totalBytes;
            this.totalProcessingTimeInAllThreads = totalProcessingTimeInAllThreads;
            this.totalContentLoadingTimeInAllThreads = totalContentLoadingTimeInAllThreads;
            this.biggestFileTypeContributors = biggestFileTypeContributors;
        }

        public final int component1() {
            return this.getTotalNumberOfFiles();
        }

        public final long component2() {
            return this.getTotalBytes();
        }

        public final long component3() {
            return this.getTotalProcessingTimeInAllThreads();
        }

        public final long component4() {
            return this.getTotalContentLoadingTimeInAllThreads();
        }

        @NotNull
        public final LimitedPriorityQueue<BiggestFileTypeContributorImpl> component5() {
            return this.biggestFileTypeContributors;
        }

        @NotNull
        public final StatsPerFileTypeImpl copy(int totalNumberOfFiles, long totalBytes, long totalProcessingTimeInAllThreads, long totalContentLoadingTimeInAllThreads, @NotNull LimitedPriorityQueue<BiggestFileTypeContributorImpl> biggestFileTypeContributors) {
            Intrinsics.checkNotNullParameter(biggestFileTypeContributors, (String)"biggestFileTypeContributors");
            return new StatsPerFileTypeImpl(totalNumberOfFiles, totalBytes, totalProcessingTimeInAllThreads, totalContentLoadingTimeInAllThreads, biggestFileTypeContributors);
        }

        public static /* synthetic */ StatsPerFileTypeImpl copy$default(StatsPerFileTypeImpl statsPerFileTypeImpl, int n, long l, long l2, long l3, LimitedPriorityQueue limitedPriorityQueue, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = statsPerFileTypeImpl.getTotalNumberOfFiles();
            }
            if ((n2 & 2) != 0) {
                l = statsPerFileTypeImpl.getTotalBytes();
            }
            if ((n2 & 4) != 0) {
                l2 = statsPerFileTypeImpl.getTotalProcessingTimeInAllThreads();
            }
            if ((n2 & 8) != 0) {
                l3 = statsPerFileTypeImpl.getTotalContentLoadingTimeInAllThreads();
            }
            if ((n2 & 0x10) != 0) {
                limitedPriorityQueue = statsPerFileTypeImpl.biggestFileTypeContributors;
            }
            return statsPerFileTypeImpl.copy(n, l, l2, l3, limitedPriorityQueue);
        }

        @NotNull
        public String toString() {
            return "StatsPerFileTypeImpl(totalNumberOfFiles=" + this.getTotalNumberOfFiles() + ", totalBytes=" + this.getTotalBytes() + ", totalProcessingTimeInAllThreads=" + this.getTotalProcessingTimeInAllThreads() + ", totalContentLoadingTimeInAllThreads=" + this.getTotalContentLoadingTimeInAllThreads() + ", biggestFileTypeContributors=" + this.biggestFileTypeContributors + ")";
        }

        public int hashCode() {
            LimitedPriorityQueue<BiggestFileTypeContributorImpl> limitedPriorityQueue = this.biggestFileTypeContributors;
            return (((Integer.hashCode(this.getTotalNumberOfFiles()) * 31 + Long.hashCode(this.getTotalBytes())) * 31 + Long.hashCode(this.getTotalProcessingTimeInAllThreads())) * 31 + Long.hashCode(this.getTotalContentLoadingTimeInAllThreads())) * 31 + (limitedPriorityQueue != null ? limitedPriorityQueue.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerFileTypeImpl)) break block3;
                    StatsPerFileTypeImpl statsPerFileTypeImpl = (StatsPerFileTypeImpl)object;
                    if (this.getTotalNumberOfFiles() != statsPerFileTypeImpl.getTotalNumberOfFiles() || this.getTotalBytes() != statsPerFileTypeImpl.getTotalBytes() || this.getTotalProcessingTimeInAllThreads() != statsPerFileTypeImpl.getTotalProcessingTimeInAllThreads() || this.getTotalContentLoadingTimeInAllThreads() != statsPerFileTypeImpl.getTotalContentLoadingTimeInAllThreads() || !Intrinsics.areEqual(this.biggestFileTypeContributors, statsPerFileTypeImpl.biggestFileTypeContributors)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u0015\u001a\u00060\u0007j\u0002`\bH\u00c6\u0003J\r\u0010\u0016\u001a\u00060\u0007j\u0002`\nH\u00c6\u0003J9\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0007j\u0002`\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\t\u001a\u00060\u0007j\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$BiggestFileTypeContributorImpl;", "Lcom/intellij/util/indexing/diagnostic/BiggestFileTypeContributor;", "providerName", "", "numberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "processingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "(Ljava/lang/String;IJJ)V", "getNumberOfFiles", "()I", "getProcessingTimeInAllThreads", "()J", "getProviderName", "()Ljava/lang/String;", "getTotalBytes", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.platform.lang.impl"})
    public static final class BiggestFileTypeContributorImpl
    implements BiggestFileTypeContributor {
        @NotNull
        private final String providerName;
        private final int numberOfFiles;
        private final long totalBytes;
        private final long processingTimeInAllThreads;

        @Override
        @NotNull
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        public int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        @Override
        public long getTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public long getProcessingTimeInAllThreads() {
            return this.processingTimeInAllThreads;
        }

        public BiggestFileTypeContributorImpl(@NotNull String providerName, int numberOfFiles, long totalBytes, long processingTimeInAllThreads) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            this.providerName = providerName;
            this.numberOfFiles = numberOfFiles;
            this.totalBytes = totalBytes;
            this.processingTimeInAllThreads = processingTimeInAllThreads;
        }

        @NotNull
        public final String component1() {
            return this.getProviderName();
        }

        public final int component2() {
            return this.getNumberOfFiles();
        }

        public final long component3() {
            return this.getTotalBytes();
        }

        public final long component4() {
            return this.getProcessingTimeInAllThreads();
        }

        @NotNull
        public final BiggestFileTypeContributorImpl copy(@NotNull String providerName, int numberOfFiles, long totalBytes, long processingTimeInAllThreads) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            return new BiggestFileTypeContributorImpl(providerName, numberOfFiles, totalBytes, processingTimeInAllThreads);
        }

        public static /* synthetic */ BiggestFileTypeContributorImpl copy$default(BiggestFileTypeContributorImpl biggestFileTypeContributorImpl, String string2, int n, long l, long l2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = biggestFileTypeContributorImpl.getProviderName();
            }
            if ((n2 & 2) != 0) {
                n = biggestFileTypeContributorImpl.getNumberOfFiles();
            }
            if ((n2 & 4) != 0) {
                l = biggestFileTypeContributorImpl.getTotalBytes();
            }
            if ((n2 & 8) != 0) {
                l2 = biggestFileTypeContributorImpl.getProcessingTimeInAllThreads();
            }
            return biggestFileTypeContributorImpl.copy(string2, n, l, l2);
        }

        @NotNull
        public String toString() {
            return "BiggestFileTypeContributorImpl(providerName=" + this.getProviderName() + ", numberOfFiles=" + this.getNumberOfFiles() + ", totalBytes=" + this.getTotalBytes() + ", processingTimeInAllThreads=" + this.getProcessingTimeInAllThreads() + ")";
        }

        public int hashCode() {
            String string2 = this.getProviderName();
            return (((string2 != null ? string2.hashCode() : 0) * 31 + Integer.hashCode(this.getNumberOfFiles())) * 31 + Long.hashCode(this.getTotalBytes())) * 31 + Long.hashCode(this.getProcessingTimeInAllThreads());
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BiggestFileTypeContributorImpl)) break block3;
                    BiggestFileTypeContributorImpl biggestFileTypeContributorImpl = (BiggestFileTypeContributorImpl)object;
                    if (!Intrinsics.areEqual((Object)this.getProviderName(), (Object)biggestFileTypeContributorImpl.getProviderName()) || this.getNumberOfFiles() != biggestFileTypeContributorImpl.getNumberOfFiles() || this.getTotalBytes() != biggestFileTypeContributorImpl.getTotalBytes() || this.getProcessingTimeInAllThreads() != biggestFileTypeContributorImpl.getProcessingTimeInAllThreads()) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u001f\u001a\u00060\u0006j\u0002`\u0007H\u00c6\u0003J\r\u0010 \u001a\u00060\u0006j\u0002`\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003JC\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\f\b\u0002\u0010\b\u001a\u00060\u0006j\u0002`\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\b\u001a\u00060\u0006j\u0002`\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001a\u00a8\u0006*"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$StatsPerIndexerImpl;", "Lcom/intellij/util/indexing/diagnostic/StatsPerIndexer;", "totalNumberOfFiles", "", "totalNumberOfFilesIndexedByExtensions", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalIndexingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "snapshotInputMappingStats", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$SnapshotInputMappingStatsImpl;", "(IIJJLcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$SnapshotInputMappingStatsImpl;)V", "getSnapshotInputMappingStats", "()Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$SnapshotInputMappingStatsImpl;", "setSnapshotInputMappingStats", "(Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$SnapshotInputMappingStatsImpl;)V", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "getTotalIndexingTimeInAllThreads", "setTotalIndexingTimeInAllThreads", "getTotalNumberOfFiles", "()I", "setTotalNumberOfFiles", "(I)V", "getTotalNumberOfFilesIndexedByExtensions", "setTotalNumberOfFilesIndexedByExtensions", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerIndexerImpl
    implements StatsPerIndexer {
        private int totalNumberOfFiles;
        private int totalNumberOfFilesIndexedByExtensions;
        private long totalBytes;
        private long totalIndexingTimeInAllThreads;
        @NotNull
        private SnapshotInputMappingStatsImpl snapshotInputMappingStats;

        @Override
        public int getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public void setTotalNumberOfFiles(int n) {
            this.totalNumberOfFiles = n;
        }

        @Override
        public int getTotalNumberOfFilesIndexedByExtensions() {
            return this.totalNumberOfFilesIndexedByExtensions;
        }

        public void setTotalNumberOfFilesIndexedByExtensions(int n) {
            this.totalNumberOfFilesIndexedByExtensions = n;
        }

        @Override
        public long getTotalBytes() {
            return this.totalBytes;
        }

        public void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        @Override
        public long getTotalIndexingTimeInAllThreads() {
            return this.totalIndexingTimeInAllThreads;
        }

        public void setTotalIndexingTimeInAllThreads(long l) {
            this.totalIndexingTimeInAllThreads = l;
        }

        @Override
        @NotNull
        public SnapshotInputMappingStatsImpl getSnapshotInputMappingStats() {
            return this.snapshotInputMappingStats;
        }

        public void setSnapshotInputMappingStats(@NotNull SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStatsImpl, (String)"<set-?>");
            this.snapshotInputMappingStats = snapshotInputMappingStatsImpl;
        }

        public StatsPerIndexerImpl(int totalNumberOfFiles, int totalNumberOfFilesIndexedByExtensions, long totalBytes, long totalIndexingTimeInAllThreads, @NotNull SnapshotInputMappingStatsImpl snapshotInputMappingStats) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStats, (String)"snapshotInputMappingStats");
            this.totalNumberOfFiles = totalNumberOfFiles;
            this.totalNumberOfFilesIndexedByExtensions = totalNumberOfFilesIndexedByExtensions;
            this.totalBytes = totalBytes;
            this.totalIndexingTimeInAllThreads = totalIndexingTimeInAllThreads;
            this.snapshotInputMappingStats = snapshotInputMappingStats;
        }

        public final int component1() {
            return this.getTotalNumberOfFiles();
        }

        public final int component2() {
            return this.getTotalNumberOfFilesIndexedByExtensions();
        }

        public final long component3() {
            return this.getTotalBytes();
        }

        public final long component4() {
            return this.getTotalIndexingTimeInAllThreads();
        }

        @NotNull
        public final SnapshotInputMappingStatsImpl component5() {
            return this.getSnapshotInputMappingStats();
        }

        @NotNull
        public final StatsPerIndexerImpl copy(int totalNumberOfFiles, int totalNumberOfFilesIndexedByExtensions, long totalBytes, long totalIndexingTimeInAllThreads, @NotNull SnapshotInputMappingStatsImpl snapshotInputMappingStats) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStats, (String)"snapshotInputMappingStats");
            return new StatsPerIndexerImpl(totalNumberOfFiles, totalNumberOfFilesIndexedByExtensions, totalBytes, totalIndexingTimeInAllThreads, snapshotInputMappingStats);
        }

        public static /* synthetic */ StatsPerIndexerImpl copy$default(StatsPerIndexerImpl statsPerIndexerImpl, int n, int n2, long l, long l2, SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = statsPerIndexerImpl.getTotalNumberOfFiles();
            }
            if ((n3 & 2) != 0) {
                n2 = statsPerIndexerImpl.getTotalNumberOfFilesIndexedByExtensions();
            }
            if ((n3 & 4) != 0) {
                l = statsPerIndexerImpl.getTotalBytes();
            }
            if ((n3 & 8) != 0) {
                l2 = statsPerIndexerImpl.getTotalIndexingTimeInAllThreads();
            }
            if ((n3 & 0x10) != 0) {
                snapshotInputMappingStatsImpl = statsPerIndexerImpl.getSnapshotInputMappingStats();
            }
            return statsPerIndexerImpl.copy(n, n2, l, l2, snapshotInputMappingStatsImpl);
        }

        @NotNull
        public String toString() {
            return "StatsPerIndexerImpl(totalNumberOfFiles=" + this.getTotalNumberOfFiles() + ", totalNumberOfFilesIndexedByExtensions=" + this.getTotalNumberOfFilesIndexedByExtensions() + ", totalBytes=" + this.getTotalBytes() + ", totalIndexingTimeInAllThreads=" + this.getTotalIndexingTimeInAllThreads() + ", snapshotInputMappingStats=" + this.getSnapshotInputMappingStats() + ")";
        }

        public int hashCode() {
            SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl = this.getSnapshotInputMappingStats();
            return (((Integer.hashCode(this.getTotalNumberOfFiles()) * 31 + Integer.hashCode(this.getTotalNumberOfFilesIndexedByExtensions())) * 31 + Long.hashCode(this.getTotalBytes())) * 31 + Long.hashCode(this.getTotalIndexingTimeInAllThreads())) * 31 + (snapshotInputMappingStatsImpl != null ? ((Object)snapshotInputMappingStatsImpl).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerIndexerImpl)) break block3;
                    StatsPerIndexerImpl statsPerIndexerImpl = (StatsPerIndexerImpl)object;
                    if (this.getTotalNumberOfFiles() != statsPerIndexerImpl.getTotalNumberOfFiles() || this.getTotalNumberOfFilesIndexedByExtensions() != statsPerIndexerImpl.getTotalNumberOfFilesIndexedByExtensions() || this.getTotalBytes() != statsPerIndexerImpl.getTotalBytes() || this.getTotalIndexingTimeInAllThreads() != statsPerIndexerImpl.getTotalIndexingTimeInAllThreads() || !Intrinsics.areEqual((Object)this.getSnapshotInputMappingStats(), (Object)statsPerIndexerImpl.getSnapshotInputMappingStats())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b:\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u009d\u0001\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0010\u001a\u00020\r\u0012\b\b\u0002\u0010\u0011\u001a\u00020\r\u0012\b\b\u0002\u0010\u0012\u001a\u00020\r\u0012\b\b\u0002\u0010\u0013\u001a\u00020\r\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\f\b\u0002\u0010\u0016\u001a\u00060\tj\u0002`\n\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0018J\u000b\u0010>\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010?\u001a\u00020\rH\u00c6\u0003J\t\u0010@\u001a\u00020\rH\u00c6\u0003J\t\u0010A\u001a\u00020\rH\u00c6\u0003J\t\u0010B\u001a\u00020\u0015H\u00c6\u0003J\r\u0010C\u001a\u00060\tj\u0002`\nH\u00c6\u0003J\t\u0010D\u001a\u00020\u0015H\u00c6\u0003J\t\u0010E\u001a\u00020\u0005H\u00c6\u0003J\t\u0010F\u001a\u00020\u0007H\u00c6\u0003J\r\u0010G\u001a\u00060\tj\u0002`\nH\u00c6\u0003J\t\u0010H\u001a\u00020\u0007H\u00c6\u0003J\t\u0010I\u001a\u00020\rH\u00c6\u0003J\t\u0010J\u001a\u00020\rH\u00c6\u0003J\t\u0010K\u001a\u00020\rH\u00c6\u0003J\t\u0010L\u001a\u00020\rH\u00c6\u0003J\u00a9\u0001\u0010M\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\f\b\u0002\u0010\b\u001a\u00060\tj\u0002`\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\f\b\u0002\u0010\u0016\u001a\u00060\tj\u0002`\n2\b\b\u0002\u0010\u0017\u001a\u00020\u0015H\u00c6\u0001J\u0013\u0010N\u001a\u00020\u00152\b\u0010O\u001a\u0004\u0018\u00010PH\u00d6\u0003J\t\u0010Q\u001a\u00020RH\u00d6\u0001J\t\u0010S\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u000e\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u0011\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001e\"\u0004\b\"\u0010 R\u001a\u0010\u0010\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010 R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010\u000f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001e\"\u0004\b*\u0010 R\u001a\u0010\u0012\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001e\"\u0004\b,\u0010 R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001e\u0010\u0016\u001a\u00060\tj\u0002`\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u0010\u0013\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001e\"\u0004\b4\u0010 R\u001e\u0010\b\u001a\u00060\tj\u0002`\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00100\"\u0004\b6\u00102R\u001a\u0010\u000b\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u00108R\u001a\u0010\u0017\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u001a\"\u0004\b=\u0010\u001c\u00a8\u0006T"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$IndexingTimesImpl;", "Lcom/intellij/util/indexing/diagnostic/IndexingTimes;", "indexingReason", "", "scanningType", "Lcom/intellij/util/indexing/diagnostic/ScanningType;", "updatingStart", "Ljava/time/ZonedDateTime;", "totalUpdatingTime", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "updatingEnd", "indexingDuration", "Ljava/time/Duration;", "contentLoadingVisibleDuration", "pushPropertiesDuration", "indexExtensionsDuration", "creatingIteratorsDuration", "scanFilesDuration", "suspendedDuration", "appliedAllValuesSeparately", "", "separateValueApplicationVisibleTime", "wasInterrupted", "(Ljava/lang/String;Lcom/intellij/util/indexing/diagnostic/ScanningType;Ljava/time/ZonedDateTime;JLjava/time/ZonedDateTime;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;ZJZ)V", "getAppliedAllValuesSeparately", "()Z", "setAppliedAllValuesSeparately", "(Z)V", "getContentLoadingVisibleDuration", "()Ljava/time/Duration;", "setContentLoadingVisibleDuration", "(Ljava/time/Duration;)V", "getCreatingIteratorsDuration", "setCreatingIteratorsDuration", "getIndexExtensionsDuration", "setIndexExtensionsDuration", "getIndexingDuration", "setIndexingDuration", "getIndexingReason", "()Ljava/lang/String;", "getPushPropertiesDuration", "setPushPropertiesDuration", "getScanFilesDuration", "setScanFilesDuration", "getScanningType", "()Lcom/intellij/util/indexing/diagnostic/ScanningType;", "getSeparateValueApplicationVisibleTime", "()J", "setSeparateValueApplicationVisibleTime", "(J)V", "getSuspendedDuration", "setSuspendedDuration", "getTotalUpdatingTime", "setTotalUpdatingTime", "getUpdatingEnd", "()Ljava/time/ZonedDateTime;", "setUpdatingEnd", "(Ljava/time/ZonedDateTime;)V", "getUpdatingStart", "getWasInterrupted", "setWasInterrupted", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    public static final class IndexingTimesImpl
    implements IndexingTimes {
        @Nullable
        private final String indexingReason;
        @NotNull
        private final ScanningType scanningType;
        @NotNull
        private final ZonedDateTime updatingStart;
        private long totalUpdatingTime;
        @NotNull
        private ZonedDateTime updatingEnd;
        @NotNull
        private Duration indexingDuration;
        @NotNull
        private Duration contentLoadingVisibleDuration;
        @NotNull
        private Duration pushPropertiesDuration;
        @NotNull
        private Duration indexExtensionsDuration;
        @NotNull
        private Duration creatingIteratorsDuration;
        @NotNull
        private Duration scanFilesDuration;
        @NotNull
        private Duration suspendedDuration;
        private boolean appliedAllValuesSeparately;
        private long separateValueApplicationVisibleTime;
        private boolean wasInterrupted;

        @Override
        @Nullable
        public String getIndexingReason() {
            return this.indexingReason;
        }

        @Override
        @NotNull
        public ScanningType getScanningType() {
            return this.scanningType;
        }

        @Override
        @NotNull
        public ZonedDateTime getUpdatingStart() {
            return this.updatingStart;
        }

        @Override
        public long getTotalUpdatingTime() {
            return this.totalUpdatingTime;
        }

        public void setTotalUpdatingTime(long l) {
            this.totalUpdatingTime = l;
        }

        @Override
        @NotNull
        public ZonedDateTime getUpdatingEnd() {
            return this.updatingEnd;
        }

        public void setUpdatingEnd(@NotNull ZonedDateTime zonedDateTime) {
            Intrinsics.checkNotNullParameter((Object)zonedDateTime, (String)"<set-?>");
            this.updatingEnd = zonedDateTime;
        }

        @Override
        @NotNull
        public Duration getIndexingDuration() {
            return this.indexingDuration;
        }

        public void setIndexingDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.indexingDuration = duration;
        }

        @Override
        @NotNull
        public Duration getContentLoadingVisibleDuration() {
            return this.contentLoadingVisibleDuration;
        }

        public void setContentLoadingVisibleDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.contentLoadingVisibleDuration = duration;
        }

        @Override
        @NotNull
        public Duration getPushPropertiesDuration() {
            return this.pushPropertiesDuration;
        }

        public void setPushPropertiesDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.pushPropertiesDuration = duration;
        }

        @Override
        @NotNull
        public Duration getIndexExtensionsDuration() {
            return this.indexExtensionsDuration;
        }

        public void setIndexExtensionsDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.indexExtensionsDuration = duration;
        }

        @Override
        @NotNull
        public Duration getCreatingIteratorsDuration() {
            return this.creatingIteratorsDuration;
        }

        @Override
        public void setCreatingIteratorsDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.creatingIteratorsDuration = duration;
        }

        @Override
        @NotNull
        public Duration getScanFilesDuration() {
            return this.scanFilesDuration;
        }

        public void setScanFilesDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.scanFilesDuration = duration;
        }

        @Override
        @NotNull
        public Duration getSuspendedDuration() {
            return this.suspendedDuration;
        }

        public void setSuspendedDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.suspendedDuration = duration;
        }

        @Override
        public boolean getAppliedAllValuesSeparately() {
            return this.appliedAllValuesSeparately;
        }

        public void setAppliedAllValuesSeparately(boolean bl) {
            this.appliedAllValuesSeparately = bl;
        }

        @Override
        public long getSeparateValueApplicationVisibleTime() {
            return this.separateValueApplicationVisibleTime;
        }

        public void setSeparateValueApplicationVisibleTime(long l) {
            this.separateValueApplicationVisibleTime = l;
        }

        @Override
        public boolean getWasInterrupted() {
            return this.wasInterrupted;
        }

        public void setWasInterrupted(boolean bl) {
            this.wasInterrupted = bl;
        }

        public IndexingTimesImpl(@Nullable String indexingReason, @NotNull ScanningType scanningType2, @NotNull ZonedDateTime updatingStart, long totalUpdatingTime, @NotNull ZonedDateTime updatingEnd, @NotNull Duration indexingDuration, @NotNull Duration contentLoadingVisibleDuration, @NotNull Duration pushPropertiesDuration, @NotNull Duration indexExtensionsDuration, @NotNull Duration creatingIteratorsDuration, @NotNull Duration scanFilesDuration, @NotNull Duration suspendedDuration, boolean appliedAllValuesSeparately, long separateValueApplicationVisibleTime, boolean wasInterrupted) {
            Intrinsics.checkNotNullParameter((Object)((Object)scanningType2), (String)"scanningType");
            Intrinsics.checkNotNullParameter((Object)updatingStart, (String)"updatingStart");
            Intrinsics.checkNotNullParameter((Object)updatingEnd, (String)"updatingEnd");
            Intrinsics.checkNotNullParameter((Object)indexingDuration, (String)"indexingDuration");
            Intrinsics.checkNotNullParameter((Object)contentLoadingVisibleDuration, (String)"contentLoadingVisibleDuration");
            Intrinsics.checkNotNullParameter((Object)pushPropertiesDuration, (String)"pushPropertiesDuration");
            Intrinsics.checkNotNullParameter((Object)indexExtensionsDuration, (String)"indexExtensionsDuration");
            Intrinsics.checkNotNullParameter((Object)creatingIteratorsDuration, (String)"creatingIteratorsDuration");
            Intrinsics.checkNotNullParameter((Object)scanFilesDuration, (String)"scanFilesDuration");
            Intrinsics.checkNotNullParameter((Object)suspendedDuration, (String)"suspendedDuration");
            this.indexingReason = indexingReason;
            this.scanningType = scanningType2;
            this.updatingStart = updatingStart;
            this.totalUpdatingTime = totalUpdatingTime;
            this.updatingEnd = updatingEnd;
            this.indexingDuration = indexingDuration;
            this.contentLoadingVisibleDuration = contentLoadingVisibleDuration;
            this.pushPropertiesDuration = pushPropertiesDuration;
            this.indexExtensionsDuration = indexExtensionsDuration;
            this.creatingIteratorsDuration = creatingIteratorsDuration;
            this.scanFilesDuration = scanFilesDuration;
            this.suspendedDuration = suspendedDuration;
            this.appliedAllValuesSeparately = appliedAllValuesSeparately;
            this.separateValueApplicationVisibleTime = separateValueApplicationVisibleTime;
            this.wasInterrupted = wasInterrupted;
        }

        public /* synthetic */ IndexingTimesImpl(String string2, ScanningType scanningType2, ZonedDateTime zonedDateTime, long l, ZonedDateTime zonedDateTime2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, Duration duration6, Duration duration7, boolean bl, long l2, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                zonedDateTime2 = zonedDateTime;
            }
            if ((n & 0x20) != 0) {
                Duration duration8 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration8, (String)"Duration.ZERO");
                duration = duration8;
            }
            if ((n & 0x40) != 0) {
                Duration duration9 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration9, (String)"Duration.ZERO");
                duration2 = duration9;
            }
            if ((n & 0x80) != 0) {
                Duration duration10 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration10, (String)"Duration.ZERO");
                duration3 = duration10;
            }
            if ((n & 0x100) != 0) {
                Duration duration11 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration11, (String)"Duration.ZERO");
                duration4 = duration11;
            }
            if ((n & 0x200) != 0) {
                Duration duration12 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration12, (String)"Duration.ZERO");
                duration5 = duration12;
            }
            if ((n & 0x400) != 0) {
                Duration duration13 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration13, (String)"Duration.ZERO");
                duration6 = duration13;
            }
            if ((n & 0x800) != 0) {
                Duration duration14 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration14, (String)"Duration.ZERO");
                duration7 = duration14;
            }
            if ((n & 0x1000) != 0) {
                bl = true;
            }
            if ((n & 0x2000) != 0) {
                l2 = 0L;
            }
            if ((n & 0x4000) != 0) {
                bl2 = false;
            }
            this(string2, scanningType2, zonedDateTime, l, zonedDateTime2, duration, duration2, duration3, duration4, duration5, duration6, duration7, bl, l2, bl2);
        }

        @Nullable
        public final String component1() {
            return this.getIndexingReason();
        }

        @NotNull
        public final ScanningType component2() {
            return this.getScanningType();
        }

        @NotNull
        public final ZonedDateTime component3() {
            return this.getUpdatingStart();
        }

        public final long component4() {
            return this.getTotalUpdatingTime();
        }

        @NotNull
        public final ZonedDateTime component5() {
            return this.getUpdatingEnd();
        }

        @NotNull
        public final Duration component6() {
            return this.getIndexingDuration();
        }

        @NotNull
        public final Duration component7() {
            return this.getContentLoadingVisibleDuration();
        }

        @NotNull
        public final Duration component8() {
            return this.getPushPropertiesDuration();
        }

        @NotNull
        public final Duration component9() {
            return this.getIndexExtensionsDuration();
        }

        @NotNull
        public final Duration component10() {
            return this.getCreatingIteratorsDuration();
        }

        @NotNull
        public final Duration component11() {
            return this.getScanFilesDuration();
        }

        @NotNull
        public final Duration component12() {
            return this.getSuspendedDuration();
        }

        public final boolean component13() {
            return this.getAppliedAllValuesSeparately();
        }

        public final long component14() {
            return this.getSeparateValueApplicationVisibleTime();
        }

        public final boolean component15() {
            return this.getWasInterrupted();
        }

        @NotNull
        public final IndexingTimesImpl copy(@Nullable String indexingReason, @NotNull ScanningType scanningType2, @NotNull ZonedDateTime updatingStart, long totalUpdatingTime, @NotNull ZonedDateTime updatingEnd, @NotNull Duration indexingDuration, @NotNull Duration contentLoadingVisibleDuration, @NotNull Duration pushPropertiesDuration, @NotNull Duration indexExtensionsDuration, @NotNull Duration creatingIteratorsDuration, @NotNull Duration scanFilesDuration, @NotNull Duration suspendedDuration, boolean appliedAllValuesSeparately, long separateValueApplicationVisibleTime, boolean wasInterrupted) {
            Intrinsics.checkNotNullParameter((Object)((Object)scanningType2), (String)"scanningType");
            Intrinsics.checkNotNullParameter((Object)updatingStart, (String)"updatingStart");
            Intrinsics.checkNotNullParameter((Object)updatingEnd, (String)"updatingEnd");
            Intrinsics.checkNotNullParameter((Object)indexingDuration, (String)"indexingDuration");
            Intrinsics.checkNotNullParameter((Object)contentLoadingVisibleDuration, (String)"contentLoadingVisibleDuration");
            Intrinsics.checkNotNullParameter((Object)pushPropertiesDuration, (String)"pushPropertiesDuration");
            Intrinsics.checkNotNullParameter((Object)indexExtensionsDuration, (String)"indexExtensionsDuration");
            Intrinsics.checkNotNullParameter((Object)creatingIteratorsDuration, (String)"creatingIteratorsDuration");
            Intrinsics.checkNotNullParameter((Object)scanFilesDuration, (String)"scanFilesDuration");
            Intrinsics.checkNotNullParameter((Object)suspendedDuration, (String)"suspendedDuration");
            return new IndexingTimesImpl(indexingReason, scanningType2, updatingStart, totalUpdatingTime, updatingEnd, indexingDuration, contentLoadingVisibleDuration, pushPropertiesDuration, indexExtensionsDuration, creatingIteratorsDuration, scanFilesDuration, suspendedDuration, appliedAllValuesSeparately, separateValueApplicationVisibleTime, wasInterrupted);
        }

        public static /* synthetic */ IndexingTimesImpl copy$default(IndexingTimesImpl indexingTimesImpl, String string2, ScanningType scanningType2, ZonedDateTime zonedDateTime, long l, ZonedDateTime zonedDateTime2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, Duration duration6, Duration duration7, boolean bl, long l2, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = indexingTimesImpl.getIndexingReason();
            }
            if ((n & 2) != 0) {
                scanningType2 = indexingTimesImpl.getScanningType();
            }
            if ((n & 4) != 0) {
                zonedDateTime = indexingTimesImpl.getUpdatingStart();
            }
            if ((n & 8) != 0) {
                l = indexingTimesImpl.getTotalUpdatingTime();
            }
            if ((n & 0x10) != 0) {
                zonedDateTime2 = indexingTimesImpl.getUpdatingEnd();
            }
            if ((n & 0x20) != 0) {
                duration = indexingTimesImpl.getIndexingDuration();
            }
            if ((n & 0x40) != 0) {
                duration2 = indexingTimesImpl.getContentLoadingVisibleDuration();
            }
            if ((n & 0x80) != 0) {
                duration3 = indexingTimesImpl.getPushPropertiesDuration();
            }
            if ((n & 0x100) != 0) {
                duration4 = indexingTimesImpl.getIndexExtensionsDuration();
            }
            if ((n & 0x200) != 0) {
                duration5 = indexingTimesImpl.getCreatingIteratorsDuration();
            }
            if ((n & 0x400) != 0) {
                duration6 = indexingTimesImpl.getScanFilesDuration();
            }
            if ((n & 0x800) != 0) {
                duration7 = indexingTimesImpl.getSuspendedDuration();
            }
            if ((n & 0x1000) != 0) {
                bl = indexingTimesImpl.getAppliedAllValuesSeparately();
            }
            if ((n & 0x2000) != 0) {
                l2 = indexingTimesImpl.getSeparateValueApplicationVisibleTime();
            }
            if ((n & 0x4000) != 0) {
                bl2 = indexingTimesImpl.getWasInterrupted();
            }
            return indexingTimesImpl.copy(string2, scanningType2, zonedDateTime, l, zonedDateTime2, duration, duration2, duration3, duration4, duration5, duration6, duration7, bl, l2, bl2);
        }

        @NotNull
        public String toString() {
            return "IndexingTimesImpl(indexingReason=" + this.getIndexingReason() + ", scanningType=" + this.getScanningType() + ", updatingStart=" + this.getUpdatingStart() + ", totalUpdatingTime=" + this.getTotalUpdatingTime() + ", updatingEnd=" + this.getUpdatingEnd() + ", indexingDuration=" + this.getIndexingDuration() + ", contentLoadingVisibleDuration=" + this.getContentLoadingVisibleDuration() + ", pushPropertiesDuration=" + this.getPushPropertiesDuration() + ", indexExtensionsDuration=" + this.getIndexExtensionsDuration() + ", creatingIteratorsDuration=" + this.getCreatingIteratorsDuration() + ", scanFilesDuration=" + this.getScanFilesDuration() + ", suspendedDuration=" + this.getSuspendedDuration() + ", appliedAllValuesSeparately=" + this.getAppliedAllValuesSeparately() + ", separateValueApplicationVisibleTime=" + this.getSeparateValueApplicationVisibleTime() + ", wasInterrupted=" + this.getWasInterrupted() + ")";
        }

        public int hashCode() {
            String string2 = this.getIndexingReason();
            ScanningType scanningType2 = this.getScanningType();
            ZonedDateTime zonedDateTime = this.getUpdatingStart();
            ZonedDateTime zonedDateTime2 = this.getUpdatingEnd();
            Duration duration = this.getIndexingDuration();
            Duration duration2 = this.getContentLoadingVisibleDuration();
            Duration duration3 = this.getPushPropertiesDuration();
            Duration duration4 = this.getIndexExtensionsDuration();
            Duration duration5 = this.getCreatingIteratorsDuration();
            Duration duration6 = this.getScanFilesDuration();
            Duration duration7 = this.getSuspendedDuration();
            int n = ((((((((((((string2 != null ? string2.hashCode() : 0) * 31 + (scanningType2 != null ? ((Object)((Object)scanningType2)).hashCode() : 0)) * 31 + (zonedDateTime != null ? ((Object)zonedDateTime).hashCode() : 0)) * 31 + Long.hashCode(this.getTotalUpdatingTime())) * 31 + (zonedDateTime2 != null ? ((Object)zonedDateTime2).hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + (duration2 != null ? ((Object)duration2).hashCode() : 0)) * 31 + (duration3 != null ? ((Object)duration3).hashCode() : 0)) * 31 + (duration4 != null ? ((Object)duration4).hashCode() : 0)) * 31 + (duration5 != null ? ((Object)duration5).hashCode() : 0)) * 31 + (duration6 != null ? ((Object)duration6).hashCode() : 0)) * 31 + (duration7 != null ? ((Object)duration7).hashCode() : 0)) * 31;
            int n2 = this.getAppliedAllValuesSeparately() ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = ((n + n2) * 31 + Long.hashCode(this.getSeparateValueApplicationVisibleTime())) * 31;
            int n4 = this.getWasInterrupted() ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexingTimesImpl)) break block3;
                    IndexingTimesImpl indexingTimesImpl = (IndexingTimesImpl)object;
                    if (!Intrinsics.areEqual((Object)this.getIndexingReason(), (Object)indexingTimesImpl.getIndexingReason()) || !Intrinsics.areEqual((Object)((Object)this.getScanningType()), (Object)((Object)indexingTimesImpl.getScanningType())) || !Intrinsics.areEqual((Object)this.getUpdatingStart(), (Object)indexingTimesImpl.getUpdatingStart()) || this.getTotalUpdatingTime() != indexingTimesImpl.getTotalUpdatingTime() || !Intrinsics.areEqual((Object)this.getUpdatingEnd(), (Object)indexingTimesImpl.getUpdatingEnd()) || !Intrinsics.areEqual((Object)this.getIndexingDuration(), (Object)indexingTimesImpl.getIndexingDuration()) || !Intrinsics.areEqual((Object)this.getContentLoadingVisibleDuration(), (Object)indexingTimesImpl.getContentLoadingVisibleDuration()) || !Intrinsics.areEqual((Object)this.getPushPropertiesDuration(), (Object)indexingTimesImpl.getPushPropertiesDuration()) || !Intrinsics.areEqual((Object)this.getIndexExtensionsDuration(), (Object)indexingTimesImpl.getIndexExtensionsDuration()) || !Intrinsics.areEqual((Object)this.getCreatingIteratorsDuration(), (Object)indexingTimesImpl.getCreatingIteratorsDuration()) || !Intrinsics.areEqual((Object)this.getScanFilesDuration(), (Object)indexingTimesImpl.getScanFilesDuration()) || !Intrinsics.areEqual((Object)this.getSuspendedDuration(), (Object)indexingTimesImpl.getSuspendedDuration()) || this.getAppliedAllValuesSeparately() != indexingTimesImpl.getAppliedAllValuesSeparately() || this.getSeparateValueApplicationVisibleTime() != indexingTimesImpl.getSeparateValueApplicationVisibleTime() || this.getWasInterrupted() != indexingTimesImpl.getWasInterrupted()) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$SnapshotInputMappingStatsImpl;", "Lcom/intellij/util/indexing/diagnostic/SnapshotInputMappingStats;", "requests", "", "misses", "(JJ)V", "hits", "getHits", "()J", "getMisses", "setMisses", "(J)V", "getRequests", "setRequests", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class SnapshotInputMappingStatsImpl
    implements SnapshotInputMappingStats {
        private long requests;
        private long misses;

        @Override
        public long getHits() {
            return this.getRequests() - this.getMisses();
        }

        @Override
        public long getRequests() {
            return this.requests;
        }

        public void setRequests(long l) {
            this.requests = l;
        }

        @Override
        public long getMisses() {
            return this.misses;
        }

        public void setMisses(long l) {
            this.misses = l;
        }

        public SnapshotInputMappingStatsImpl(long requests, long misses) {
            this.requests = requests;
            this.misses = misses;
        }

        public final long component1() {
            return this.getRequests();
        }

        public final long component2() {
            return this.getMisses();
        }

        @NotNull
        public final SnapshotInputMappingStatsImpl copy(long requests, long misses) {
            return new SnapshotInputMappingStatsImpl(requests, misses);
        }

        public static /* synthetic */ SnapshotInputMappingStatsImpl copy$default(SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = snapshotInputMappingStatsImpl.getRequests();
            }
            if ((n & 2) != 0) {
                l2 = snapshotInputMappingStatsImpl.getMisses();
            }
            return snapshotInputMappingStatsImpl.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "SnapshotInputMappingStatsImpl(requests=" + this.getRequests() + ", misses=" + this.getMisses() + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.getRequests()) * 31 + Long.hashCode(this.getMisses());
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SnapshotInputMappingStatsImpl)) break block3;
                    SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl = (SnapshotInputMappingStatsImpl)object;
                    if (this.getRequests() != snapshotInputMappingStatsImpl.getRequests() || this.getMisses() != snapshotInputMappingStatsImpl.getMisses()) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Companion;", "", "()V", "indexingSessionIdSequencer", "Ljava/util/concurrent/atomic/AtomicLong;", "getIndexingSessionIdSequencer", "()Ljava/util/concurrent/atomic/AtomicLong;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.lang.impl"})
    private static final class Companion {
        @NotNull
        public final AtomicLong getIndexingSessionIdSequencer() {
            return indexingSessionIdSequencer;
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

