/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryFusReporter;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryListener;
import com.intellij.util.indexing.diagnostic.StatsPerFileType;
import com.intellij.util.indexing.diagnostic.dto.JsonConverterKt;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0004j\u0002`\u00062\n\u0010\u0007\u001a\u00060\u0004j\u0002`\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryFusReporterListener;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryListener;", "()V", "calculateReadSpeed", "", "bytes", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "loadingTime", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "onFinishedIndexing", "", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "onStartedIndexing", "intellij.platform.lang.impl"})
public final class ProjectIndexingHistoryFusReporterListener
implements ProjectIndexingHistoryListener {
    @Override
    public void onStartedIndexing(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        ProjectIndexingHistoryFusReporter.INSTANCE.reportIndexingStarted(projectIndexingHistory.getProject(), projectIndexingHistory.getIndexingSessionId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFinishedIndexing(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        Object object;
        long l;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        long scanningTime = projectIndexingHistory.getTimes().getScanFilesDuration().toMillis();
        int numberOfFileProviders = projectIndexingHistory.getScanningStatistics().size();
        Iterable iterable = projectIndexingHistory.getScanningStatistics();
        int n3 = 0;
        for (Object object2 : iterable) {
            void it;
            Object object3 = (JsonScanningStatistics)object2;
            n2 = n3;
            boolean bl = false;
            n = it.getNumberOfScannedFiles();
            n3 = n2 + n;
        }
        int numberOfScannedFiles = n3;
        Iterable iterable2 = projectIndexingHistory.getScanningStatistics();
        int n4 = 0;
        for (Object object3 : iterable2) {
            void it;
            JsonScanningStatistics bl = object3;
            n2 = n4;
            boolean bl2 = false;
            n = it.getNumberOfFilesFullyIndexedByInfrastructureExtensions();
            n4 = n2 + n;
        }
        int numberOfFilesIndexedByExtensionsDuringScan = n4;
        Iterable iterable3 = projectIndexingHistory.getProviderStatistics();
        int n5 = 0;
        for (Object it : iterable3) {
            void it2;
            JsonFileProviderIndexStatistics bl2 = (JsonFileProviderIndexStatistics)it;
            n2 = n5;
            boolean bl = false;
            n = it2.getTotalNumberOfFilesFullyIndexedByExtensions();
            n5 = n2 + n;
        }
        int numberOfFilesIndexedByExtensionsWithLoadingContent = n5;
        Iterable iterable4 = projectIndexingHistory.getProviderStatistics();
        int n6 = 0;
        for (Object t : iterable4) {
            void it4;
            JsonFileProviderIndexStatistics bl = (JsonFileProviderIndexStatistics)t;
            n2 = n6;
            boolean bl3 = false;
            n = it4.getTotalNumberOfIndexedFiles();
            n6 = n2 + n;
        }
        int numberOfFilesIndexedWithLoadingContent = n6;
        Iterable it = projectIndexingHistory.getTotalStatsPerFileType().values();
        long l2 = 0L;
        Iterator iterator = it.iterator();
        while (iterator.hasNext()) {
            Iterator it3;
            Object t = iterator.next();
            StatsPerFileType statsPerFileType = (StatsPerFileType)t;
            long l3 = l2;
            boolean bl = false;
            l = it3.getTotalContentLoadingTimeInAllThreads();
            l2 = l3 + l;
        }
        long totalContentLoadingTime = l2;
        Iterable it4 = projectIndexingHistory.getTotalStatsPerFileType().values();
        long l4 = 0L;
        for (Object bl : it4) {
            void it5;
            object = (StatsPerFileType)bl;
            long l5 = l4;
            boolean bl4 = false;
            l = it5.getTotalBytes();
            l4 = l5 + l;
        }
        long totalContentData = l4;
        long averageContentLoadingSpeed = this.calculateReadSpeed(totalContentData, totalContentLoadingTime);
        HashMap contentLoadingSpeedByFileType = new HashMap();
        Map<String, StatsPerFileType> $this$forEach$iv = projectIndexingHistory.getTotalStatsPerFileType();
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            void fileType;
            Map.Entry element$iv;
            Map.Entry $dstr$fileType$stats = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            Map.Entry entry = $dstr$fileType$stats;
            String string2 = (String)entry.getKey();
            entry = $dstr$fileType$stats;
            StatsPerFileType stats = (StatsPerFileType)entry.getValue();
            if (stats.getTotalContentLoadingTimeInAllThreads() == 0L || stats.getTotalBytes() == 0L) continue;
            Map map2 = contentLoadingSpeedByFileType;
            FileType fileType2 = FileTypeManager.getInstance().getStdFileType((String)fileType);
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"FileTypeManager.getInsta\u2026.getStdFileType(fileType)");
            map2.put(fileType2, this.calculateReadSpeed(stats.getTotalBytes(), stats.getTotalContentLoadingTimeInAllThreads()));
        }
        ProjectIndexingHistoryFusReporter.INSTANCE.reportIndexingFinished(projectIndexingHistory.getProject(), projectIndexingHistory.getIndexingSessionId(), projectIndexingHistory.getTimes().getScanningType(), JsonConverterKt.toMillis(projectIndexingHistory.getTimes().getTotalUpdatingTime()), projectIndexingHistory.getTimes().getIndexingDuration().toMillis(), scanningTime, numberOfFileProviders, numberOfScannedFiles, numberOfFilesIndexedByExtensionsDuringScan, numberOfFilesIndexedByExtensionsWithLoadingContent, numberOfFilesIndexedWithLoadingContent, averageContentLoadingSpeed, contentLoadingSpeedByFileType);
    }

    private final long calculateReadSpeed(long bytes, long loadingTime) {
        if (bytes == 0L || loadingTime == 0L) {
            return 0L;
        }
        long nanoSecondInOneSecond = TimeUnit.SECONDS.toNanos(1L);
        return bytes * nanoSecondInOneSecond > 0L ? bytes * nanoSecondInOneSecond / loadingTime : MathKt.roundToLong((double)((double)bytes / (double)loadingTime * (double)nanoSecondInOneSecond));
    }
}

