/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumperUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\u0019\u001a\u00020\u0014J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumperUtils;", "", "()V", "diagnosticTimestampFormat", "Ljava/time/format/DateTimeFormatter;", "getDiagnosticTimestampFormat", "()Ljava/time/format/DateTimeFormatter;", "indexingDiagnosticDir", "Ljava/nio/file/Path;", "getIndexingDiagnosticDir", "()Ljava/nio/file/Path;", "indexingDiagnosticDir$delegate", "Lkotlin/Lazy;", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonMapper$delegate", "getDumpFilePath", "prefix", "", "time", "Ljava/time/LocalDateTime;", "extension", "parent", "suffix", "writeValue", "", "file", "value", "intellij.platform.lang.impl"})
public final class IndexDiagnosticDumperUtils {
    @NotNull
    private static final Lazy jacksonMapper$delegate;
    @NotNull
    private static final DateTimeFormatter diagnosticTimestampFormat;
    @NotNull
    private static final Lazy indexingDiagnosticDir$delegate;
    @NotNull
    public static final IndexDiagnosticDumperUtils INSTANCE;

    @NotNull
    public final ObjectMapper getJacksonMapper() {
        Lazy lazy = jacksonMapper$delegate;
        IndexDiagnosticDumperUtils indexDiagnosticDumperUtils = this;
        Object var3_3 = null;
        return (ObjectMapper)lazy.getValue();
    }

    @NotNull
    public final DateTimeFormatter getDiagnosticTimestampFormat() {
        return diagnosticTimestampFormat;
    }

    public final void writeValue(@NotNull Path file2, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Path path2 = file2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file.parent");
        Path path3 = path2;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        this.getJacksonMapper().writerWithDefaultPrettyPrinter().writeValue(file2.toFile(), value);
    }

    @NotNull
    public final Path getDumpFilePath(@NotNull String prefix, @NotNull LocalDateTime time, @NotNull String extension2, @NotNull Path parent, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String timestamp = time.format(diagnosticTimestampFormat);
        Path path2 = parent;
        String string2 = prefix + suffix + timestamp + "." + extension2;
        Path path3 = path2.resolve(string2);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.resolve(other)");
        return path3;
    }

    public static /* synthetic */ Path getDumpFilePath$default(IndexDiagnosticDumperUtils indexDiagnosticDumperUtils, String string2, LocalDateTime localDateTime, String string3, Path path2, String string4, int n, Object object) {
        if ((n & 0x10) != 0) {
            string4 = "";
        }
        return indexDiagnosticDumperUtils.getDumpFilePath(string2, localDateTime, string3, path2, string4);
    }

    @NotNull
    public final Path getIndexingDiagnosticDir() {
        Lazy lazy = indexingDiagnosticDir$delegate;
        IndexDiagnosticDumperUtils indexDiagnosticDumperUtils = this;
        Object var3_3 = null;
        return (Path)lazy.getValue();
    }

    private IndexDiagnosticDumperUtils() {
    }

    static {
        IndexDiagnosticDumperUtils indexDiagnosticDumperUtils;
        INSTANCE = indexDiagnosticDumperUtils = new IndexDiagnosticDumperUtils();
        jacksonMapper$delegate = LazyKt.lazy((Function0)jacksonMapper.2.INSTANCE);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPatt\u2026yyyy-MM-dd-HH-mm-ss.SSS\")");
        diagnosticTimestampFormat = dateTimeFormatter;
        indexingDiagnosticDir$delegate = LazyKt.lazy((Function0)indexingDiagnosticDir.2.INSTANCE);
    }
}

