/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.DumbModeProgressTitle;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.BooleanFunction;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FilePropertyPusherEx;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PoweredProgressIndicator;
import com.intellij.util.indexing.UnindexedFileStatus;
import com.intellij.util.indexing.UnindexedFilesFinder;
import com.intellij.util.indexing.contentQueue.IndexUpdateRunner;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import com.intellij.util.indexing.diagnostic.ScanningType;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.ModuleRootOrigin;
import com.intellij.util.indexing.roots.kind.SdkOrigin;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class UnindexedFilesUpdater
extends DumbModeTask {
    @VisibleForTesting
    public static final Key<Boolean> INDEX_PROJECT_WITH_MANY_UPDATERS_TEST_KEY = new Key("INDEX_PROJECT_WITH_MANY_UPDATERS_TEST_KEY");
    private static final Logger LOG = Logger.getInstance(UnindexedFilesUpdater.class);
    private static final int DEFAULT_MAX_INDEXER_THREADS = 4;
    @VisibleForTesting
    public static volatile TestMode ourTestMode;
    public static final ExecutorService GLOBAL_INDEXING_EXECUTOR;
    private static final int MINIMUM_NUMBER_OF_FILES_TO_RUN_CONCURRENT_INDEXING;
    @NotNull
    private static final Key<Boolean> CONTENT_SCANNED;
    @NotNull
    private static final Key<Boolean> INDEX_UPDATE_IN_PROGRESS;
    @NotNull
    private static final Key<UnindexedFilesUpdater> RUNNING_TASK;
    private static final Object ourLastRunningTaskLock;
    private final FileBasedIndexImpl myIndex;
    protected final Project myProject;
    private final boolean myStartSuspended;
    private final boolean myOnProjectOpen;
    @NonNls
    private final String myIndexingReason;
    @NotNull
    private final ScanningType myScanningType;
    private final PushedFilePropertiesUpdater myPusher;
    @Nullable
    private final List<IndexableFilesIterator> myPredefinedIndexableFilesIterators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnindexedFilesUpdater(@NotNull Project project2, boolean startSuspended, boolean onProjectOpen, @Nullable List<IndexableFilesIterator> predefinedIndexableFilesIterators, @Nullable @NonNls String indexingReason, @NotNull ScanningType scanningType2) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(0);
        }
        if (scanningType2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(1);
        }
        this.myIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        this.myProject = project2;
        this.myStartSuspended = startSuspended;
        this.myOnProjectOpen = onProjectOpen;
        this.myIndexingReason = indexingReason;
        this.myScanningType = scanningType2;
        this.myPusher = PushedFilePropertiesUpdater.getInstance(this.myProject);
        this.myPredefinedIndexableFilesIterators = predefinedIndexableFilesIterators;
        if (this.isFullIndexUpdate()) {
            this.myProject.putUserData(CONTENT_SCANNED, null);
        }
        if (this.isFullIndexUpdate()) {
            Object object = ourLastRunningTaskLock;
            synchronized (object) {
                UnindexedFilesUpdater runningTask = this.myProject.getUserData(RUNNING_TASK);
                if (runningTask != null) {
                    DumbService.getInstance(project2).cancelTask(runningTask);
                }
            }
        }
    }

    private boolean isFullIndexUpdate() {
        return this.myPredefinedIndexableFilesIterators == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = ourLastRunningTaskLock;
        synchronized (object) {
            UnindexedFilesUpdater lastRunningTask = this.myProject.getUserData(RUNNING_TASK);
            if (lastRunningTask == this) {
                this.myProject.putUserData(RUNNING_TASK, null);
            }
        }
    }

    @Override
    @Nullable
    public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
        if (taskFromQueue == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(2);
        }
        if (!(taskFromQueue instanceof UnindexedFilesUpdater) || taskFromQueue.getClass() != this.getClass()) {
            return null;
        }
        UnindexedFilesUpdater oldTask = (UnindexedFilesUpdater)taskFromQueue;
        if (!this.myProject.equals(oldTask.myProject)) {
            return null;
        }
        Object reason = oldTask.isFullIndexUpdate() ? oldTask.myIndexingReason : (this.isFullIndexUpdate() ? this.myIndexingReason : "Merged " + StringUtil.trimStart(this.myIndexingReason, "Merged ") + " with " + StringUtil.trimStart(oldTask.myIndexingReason, "Merged "));
        LOG.debug("Merged " + this + " task");
        return new UnindexedFilesUpdater(this.myProject, this.myStartSuspended, false, UnindexedFilesUpdater.mergeIterators(this.myPredefinedIndexableFilesIterators, ((UnindexedFilesUpdater)taskFromQueue).myPredefinedIndexableFilesIterators), (String)reason, ScanningType.Companion.merge(oldTask.myScanningType, oldTask.myScanningType));
    }

    @Nullable
    private static List<IndexableFilesIterator> mergeIterators(@Nullable List<IndexableFilesIterator> iterators, @Nullable List<IndexableFilesIterator> otherIterators) {
        if (iterators == null || otherIterators == null) {
            return null;
        }
        LinkedHashMap<IndexableSetOrigin, IndexableFilesIterator> uniqueIterators = new LinkedHashMap<IndexableSetOrigin, IndexableFilesIterator>();
        for (IndexableFilesIterator iterator : iterators) {
            uniqueIterators.putIfAbsent(iterator.getOrigin(), iterator);
        }
        for (IndexableFilesIterator iterator : otherIterators) {
            uniqueIterators.putIfAbsent(iterator.getOrigin(), iterator);
        }
        return new ArrayList<IndexableFilesIterator>(uniqueIterators.values());
    }

    public UnindexedFilesUpdater(@NotNull Project project2) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(3);
        }
        this(project2, false, false, null, null, ScanningType.FULL);
    }

    public UnindexedFilesUpdater(@NotNull Project project2, @Nullable @NonNls String indexingReason) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(4);
        }
        this(project2, false, false, null, indexingReason, ScanningType.FULL);
    }

    public UnindexedFilesUpdater(@NotNull Project project2, @Nullable List<IndexableFilesIterator> predefinedIndexableFilesIterators, @Nullable @NonNls String indexingReason) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(5);
        }
        this(project2, false, false, predefinedIndexableFilesIterators, indexingReason, predefinedIndexableFilesIterators == null ? ScanningType.FULL : ScanningType.PARTIAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<IndexableFilesIterator, List<VirtualFile>> scan(@NotNull PerformanceWatcher.Snapshot snapshot, @NotNull ProjectIndexingHistoryImpl projectIndexingHistory, @NotNull ProgressIndicator indicator) {
        Map<IndexableFilesIterator, List<VirtualFile>> providerToFiles;
        List orderedProviders;
        if (snapshot == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(6);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(8);
        }
        projectIndexingHistory.startStage(ProjectIndexingHistoryImpl.Stage.PushProperties);
        try {
            if (this.myPusher instanceof PushedFilePropertiesUpdaterImpl) {
                ((PushedFilePropertiesUpdaterImpl)this.myPusher).performDelayedPushTasks();
            }
        }
        finally {
            projectIndexingHistory.stopStage(ProjectIndexingHistoryImpl.Stage.PushProperties);
        }
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage("Performing delayed pushing properties tasks for " + this.myProject.getName()));
        snapshot = PerformanceWatcher.takeSnapshot();
        if (this.isFullIndexUpdate()) {
            this.myIndex.clearIndicesIfNecessary();
        }
        projectIndexingHistory.startStage(ProjectIndexingHistoryImpl.Stage.CreatingIterators);
        try {
            orderedProviders = Objects.requireNonNullElseGet(this.myPredefinedIndexableFilesIterators, () -> UnindexedFilesUpdater.collectProviders(this.myProject, this.myIndex));
        }
        finally {
            projectIndexingHistory.stopStage(ProjectIndexingHistoryImpl.Stage.CreatingIterators);
        }
        projectIndexingHistory.startStage(ProjectIndexingHistoryImpl.Stage.Scanning);
        try {
            providerToFiles = this.collectIndexableFilesConcurrently(this.myProject, indicator, orderedProviders, projectIndexingHistory);
            if (this.isFullIndexUpdate()) {
                this.myProject.putUserData(CONTENT_SCANNED, true);
            }
        }
        finally {
            projectIndexingHistory.stopStage(ProjectIndexingHistoryImpl.Stage.Scanning);
        }
        String scanningCompletedMessage = UnindexedFilesUpdater.getLogScanningCompletedStageMessage(projectIndexingHistory);
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage(scanningCompletedMessage));
        Map<IndexableFilesIterator, List<VirtualFile>> map2 = providerToFiles;
        if (map2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(9);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanAndUpdateUnindexedFiles(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory, @NotNull ProgressIndicator indicator) {
        int totalFiles;
        Map<IndexableFilesIterator, List<VirtualFile>> providerToFiles;
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(11);
        }
        if (!IndexInfrastructure.hasIndices()) {
            return;
        }
        LOG.info("Started scanning for indexing of " + this.myProject.getName() + (String)(this.myIndexingReason == null ? "" : ". Reason: " + this.myIndexingReason));
        ProgressSuspender suspender = ProgressSuspender.getSuspender((ProgressIndicator)indicator);
        if (suspender != null) {
            this.listenToProgressSuspenderForSuspendedTimeDiagnostic(suspender, projectIndexingHistory);
        }
        if (this.myStartSuspended) {
            if (suspender == null) {
                throw new IllegalStateException("Indexing progress indicator must be suspendable!");
            }
            if (!suspender.isSuspended()) {
                suspender.suspendProcess(IndexingBundle.message((String)"progress.indexing.started.as.suspended", (Object[])new Object[0]));
            }
        }
        indicator.setIndeterminate(true);
        indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        Disposable scanningLifetime = Disposer.newDisposable();
        try {
            DumbModeProgressTitle.getInstance((Project)this.myProject).attachProgressTitleText(IndexingBundle.message((String)"progress.indexing.scanning.title", (Object[])new Object[0]), scanningLifetime);
            providerToFiles = this.scan(snapshot, projectIndexingHistory, indicator);
        }
        finally {
            Disposer.dispose(scanningLifetime);
        }
        boolean skipInitialRefresh = UnindexedFilesUpdater.skipInitialRefresh();
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (this.myOnProjectOpen && !isUnitTestMode && !skipInitialRefresh) {
            this.scheduleInitialVfsRefresh();
        }
        if ((totalFiles = providerToFiles.values().stream().mapToInt(it -> it.size()).sum()) == 0) {
            LOG.info("Finished for " + this.myProject.getName() + ". No files to index with loading content.");
            return;
        }
        if (SystemProperties.getBooleanProperty("idea.indexes.pretendNoFiles", false)) {
            LOG.info("Finished for " + this.myProject.getName() + ". System property 'idea.indexes.pretendNoFiles' is enabled.");
            return;
        }
        snapshot = PerformanceWatcher.takeSnapshot();
        ProgressIndicator poweredIndicator = PoweredProgressIndicator.wrap(indicator, UnindexedFilesUpdater.getPowerForSmoothProgressIndicator());
        poweredIndicator.setIndeterminate(false);
        poweredIndicator.setFraction(0.0);
        poweredIndicator.setText(IndexingBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
        this.myIndex.resetSnapshotInputMappingStatistics();
        projectIndexingHistory.startStage(ProjectIndexingHistoryImpl.Stage.Indexing);
        try {
            this.indexFiles(providerToFiles, projectIndexingHistory, poweredIndicator);
        }
        finally {
            projectIndexingHistory.stopStage(ProjectIndexingHistoryImpl.Stage.Indexing);
        }
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage("Finished for " + this.myProject.getName() + ". Unindexed files update"));
        List<SnapshotInputMappingsStatistics> snapshotInputMappingsStatistics = this.myIndex.dumpSnapshotInputMappingStatistics();
        projectIndexingHistory.addSnapshotInputMappingStatistics(snapshotInputMappingsStatistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexFiles(@NotNull Map<IndexableFilesIterator, List<VirtualFile>> providerToFiles, @NotNull ProjectIndexingHistoryImpl projectIndexingHistory, @NotNull ProgressIndicator progressIndicator) {
        if (providerToFiles == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(12);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(13);
        }
        if (progressIndicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(14);
        }
        int totalFiles = providerToFiles.values().stream().mapToInt(it -> it.size()).sum();
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(progressIndicator, totalFiles);
        int numberOfIndexingThreads = UnindexedFilesUpdater.getNumberOfIndexingThreads();
        LOG.info("Use " + numberOfIndexingThreads + " indexing " + StringUtil.pluralize("thread", numberOfIndexingThreads) + " for indexing of " + this.myProject.getName());
        IndexUpdateRunner indexUpdateRunner = new IndexUpdateRunner(this.myIndex, GLOBAL_INDEXING_EXECUTOR, numberOfIndexingThreads);
        ArrayList<IndexableFilesIterator> providers2 = new ArrayList<IndexableFilesIterator>(providerToFiles.keySet());
        int index = 0;
        while (index < providers2.size()) {
            List<VirtualFile> providerFiles;
            ArrayList<IndexUpdateRunner.FileSet> fileSets = new ArrayList<IndexUpdateRunner.FileSet>();
            int biggestProviderFiles = 0;
            IndexableFilesIterator biggestProvider = null;
            for (int takenFiles = 0; takenFiles < MINIMUM_NUMBER_OF_FILES_TO_RUN_CONCURRENT_INDEXING && index < providers2.size(); takenFiles += providerFiles.size()) {
                IndexableFilesIterator provider2;
                if (!(providerFiles = providerToFiles.getOrDefault(provider2 = providers2.get(index++), Collections.emptyList())).isEmpty()) {
                    fileSets.add(new IndexUpdateRunner.FileSet(this.myProject, provider2.getDebugName(), providerFiles));
                }
                if (biggestProviderFiles >= providerFiles.size()) continue;
                biggestProviderFiles = providerFiles.size();
                biggestProvider = provider2;
            }
            if (fileSets.isEmpty() || biggestProvider == null) break;
            String indexingProgressText = biggestProvider.getIndexingProgressText();
            concurrentTasksProgressManager.setText(indexingProgressText);
            int setFilesNumber = fileSets.stream().mapToInt(b -> b.files.size()).sum();
            SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(setFilesNumber);
            try {
                IndexUpdateRunner.IndexingInterruptedException exception = null;
                try {
                    indexUpdateRunner.indexFiles(this.myProject, fileSets, (ProgressIndicator)subTaskIndicator, projectIndexingHistory);
                }
                catch (IndexUpdateRunner.IndexingInterruptedException e) {
                    exception = e;
                }
                try {
                    fileSets.forEach(b -> projectIndexingHistory.addProviderStatistics(b.statistics));
                }
                catch (Exception e) {
                    LOG.error("Failed to add indexing statistics", e);
                }
                if (exception == null) continue;
                ExceptionUtil.rethrow(exception.getCause());
            }
            finally {
                subTaskIndicator.finished();
            }
        }
    }

    @NotNull
    private static String getLogScanningCompletedStageMessage(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory) {
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(15);
        }
        List statistics = projectIndexingHistory.getScanningStatistics();
        int numberOfScannedFiles = statistics.stream().mapToInt(s -> s.getNumberOfScannedFiles()).sum();
        int numberOfFilesForIndexing = statistics.stream().mapToInt(s -> s.getNumberOfFilesForIndexing()).sum();
        String string2 = "Scanning completed for " + projectIndexingHistory.getProject().getName() + ". Number of scanned files: " + numberOfScannedFiles + "; Number of files for indexing: " + numberOfFilesForIndexing;
        if (string2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(16);
        }
        return string2;
    }

    private void listenToProgressSuspenderForSuspendedTimeDiagnostic(final @NotNull ProgressSuspender suspender, final @NotNull ProjectIndexingHistoryImpl projectIndexingHistory) {
        if (suspender == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(17);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(18);
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(this);
        connection.subscribe(ProgressSuspender.TOPIC, new ProgressSuspender.SuspenderListener(){

            public void suspendedStatusChanged(@NotNull ProgressSuspender changedSuspender) {
                if (changedSuspender == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (suspender == changedSuspender) {
                    if (suspender.isSuspended()) {
                        projectIndexingHistory.suspendStages();
                    } else {
                        projectIndexingHistory.stopSuspendingStages();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedSuspender", "com/intellij/util/indexing/UnindexedFilesUpdater$1", "suspendedStatusChanged"));
            }
        });
    }

    public static boolean isIndexUpdateInProgress(@NotNull Project project2) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(19);
        }
        return project2.getUserData(INDEX_UPDATE_IN_PROGRESS) == Boolean.TRUE;
    }

    public static boolean isProjectContentFullyScanned(@NotNull Project project2) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(20);
        }
        return Boolean.TRUE.equals(project2.getUserData(CONTENT_SCANNED));
    }

    @NotNull
    private static List<IndexableFilesIterator> collectProviders(@NotNull Project project2, FileBasedIndexImpl index) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(21);
        }
        List originalOrderedProviders = index.getIndexableFilesProviders(project2);
        ArrayList<IndexableFilesIterator> orderedProviders = new ArrayList<IndexableFilesIterator>();
        originalOrderedProviders.stream().filter(p -> !(p.getOrigin() instanceof SdkOrigin)).collect(Collectors.toCollection(() -> orderedProviders));
        originalOrderedProviders.stream().filter(p -> p.getOrigin() instanceof SdkOrigin).collect(Collectors.toCollection(() -> orderedProviders));
        ArrayList<IndexableFilesIterator> arrayList = orderedProviders;
        if (arrayList == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Nullable
    protected BooleanFunction<IndexedFile> getForceReindexingTrigger() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<IndexableFilesIterator, List<VirtualFile>> collectIndexableFilesConcurrently(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull List<IndexableFilesIterator> providers2, @NotNull ProjectIndexingHistoryImpl projectIndexingHistory) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(23);
        }
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(24);
        }
        if (providers2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(25);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(26);
        }
        if (providers2.isEmpty()) {
            Map<IndexableFilesIterator, List<VirtualFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                UnindexedFilesUpdater.$$$reportNull$$$0(27);
            }
            return map2;
        }
        List<IndexableFileScanner.ScanSession> sessions = ContainerUtil.map(IndexableFileScanner.EP_NAME.getExtensionList(), scanner -> scanner.startSession(project2));
        UnindexedFilesFinder unindexedFileFinder = new UnindexedFilesFinder(project2, this.myIndex, this.getForceReindexingTrigger());
        IdentityHashMap<IndexableFilesIterator, List<VirtualFile>> providerToFiles = new IdentityHashMap<IndexableFilesIterator, List<VirtualFile>>();
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
        indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(indicator, providers2.size());
        Ref<Boolean> allTasksFinished = Ref.create(false);
        List<Runnable> tasks = ContainerUtil.map(providers2, provider2 -> {
            Object[] moduleValues;
            SmartList<FilePropertyPusherEx> pusherExs;
            List<FilePropertyPusher<?>> pushers;
            SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(1);
            ArrayList files2 = new ArrayList();
            ScanningStatistics scanningStatistics = new ScanningStatistics(provider2.getDebugName());
            scanningStatistics.setProviderRoots((IndexableFilesIterator)provider2, project2);
            providerToFiles.put((IndexableFilesIterator)provider2, files2);
            IndexableSetOrigin origin = provider2.getOrigin();
            List<// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull IndexableFileScanner.IndexableFileVisitor> fileScannerVisitors = ContainerUtil.mapNotNull(sessions, s -> s.createVisitor(origin));
            IndexableFilesDeduplicateFilter thisProviderDeduplicateFilter = IndexableFilesDeduplicateFilter.createDelegatingTo((IndexableFilesDeduplicateFilter)indexableFilesDeduplicateFilter);
            if (origin instanceof ModuleRootOrigin && !((ModuleRootOrigin)origin).getModule().isDisposed()) {
                pushers = FilePropertyPusher.EP_NAME.getExtensionList();
                pusherExs = null;
                moduleValues = ReadAction.compute(() -> PushedFilePropertiesUpdaterImpl.getModuleImmediateValues(pushers, ((ModuleRootOrigin)origin).getModule()));
            } else {
                pushers = null;
                SmartList<FilePropertyPusherEx> extendedPushers = new SmartList<FilePropertyPusherEx>();
                for (FilePropertyPusher<?> pusher : FilePropertyPusher.EP_NAME.getExtensionList()) {
                    if (!(pusher instanceof FilePropertyPusherEx) || !((FilePropertyPusherEx)pusher).acceptsOrigin(project2, origin)) continue;
                    extendedPushers.add((FilePropertyPusherEx)pusher);
                }
                if (extendedPushers.isEmpty()) {
                    pusherExs = null;
                    moduleValues = null;
                } else {
                    pusherExs = extendedPushers;
                    moduleValues = ReadAction.compute(() -> PushedFilePropertiesUpdaterImpl.getImmediateValuesEx(extendedPushers, origin));
                }
            }
            ProgressManager.checkCanceled();
            ContentIterator collectingIterator = fileOrDir -> {
                UnindexedFileStatus status;
                ProgressManager.checkCanceled();
                if (subTaskIndicator.isCanceled()) {
                    return false;
                }
                long scanningStart = System.nanoTime();
                PushedFilePropertiesUpdaterImpl.applyScannersToFile(fileOrDir, fileScannerVisitors);
                if (pushers != null && this.myPusher instanceof PushedFilePropertiesUpdaterImpl) {
                    ((PushedFilePropertiesUpdaterImpl)this.myPusher).applyPushersToFile(fileOrDir, pushers, moduleValues);
                } else if (pusherExs != null && this.myPusher instanceof PushedFilePropertiesUpdaterImpl) {
                    ((PushedFilePropertiesUpdaterImpl)this.myPusher).applyPushersToFile(fileOrDir, pusherExs, moduleValues);
                }
                @NotNull long statusTime = System.nanoTime();
                try {
                    status = ourTestMode == TestMode.PUSHING ? null : unindexedFileFinder.getFileStatus(fileOrDir);
                }
                finally {
                    statusTime = System.nanoTime() - statusTime;
                }
                if (status != null) {
                    if (status.getShouldIndex() && ourTestMode == null) {
                        files2.add(fileOrDir);
                    }
                    scanningStatistics.addStatus(fileOrDir, status, statusTime, project2);
                }
                scanningStatistics.addScanningTime(System.nanoTime() - scanningStart);
                return true;
            };
            return () -> {
                subTaskIndicator.setText(provider2.getRootsScanningProgressText());
                try {
                    provider2.iterateFiles(project2, collectingIterator, (VirtualFileFilter)thisProviderDeduplicateFilter);
                }
                finally {
                    scanningStatistics.setNumberOfSkippedFiles(thisProviderDeduplicateFilter.getNumberOfSkippedFiles());
                    Ref ref = allTasksFinished;
                    synchronized (ref) {
                        if (!((Boolean)allTasksFinished.get()).booleanValue()) {
                            projectIndexingHistory.addScanningStatistics(scanningStatistics);
                        }
                    }
                    subTaskIndicator.finished();
                }
            };
        });
        LOG.info("Scanning of " + this.myProject.getName() + " uses " + UnindexedFilesUpdater.getNumberOfScanningThreads() + " scanning threads");
        try {
            PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
        }
        finally {
            Ref<Boolean> ref = allTasksFinished;
            synchronized (ref) {
                allTasksFinished.set(true);
            }
        }
        IdentityHashMap<IndexableFilesIterator, List<VirtualFile>> identityHashMap = providerToFiles;
        if (identityHashMap == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(28);
        }
        return identityHashMap;
    }

    private void scheduleInitialVfsRefresh() {
        ProjectRootManagerEx.getInstanceEx(this.myProject).markRootsForRefresh();
        Application app = ApplicationManager.getApplication();
        if (!app.isCommandLine() || CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
            final MessageBusConnection connection = app.getMessageBus().connect();
            connection.subscribe(ProjectManager.TOPIC, new ProjectManagerListener(){

                @Override
                public void projectClosed(@NotNull Project project2) {
                    if (project2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (project2 == UnindexedFilesUpdater.this.myProject) {
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/UnindexedFilesUpdater$2", "projectClosed"));
                }
            });
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> VirtualFileManager.getInstance().syncRefresh());
        }
    }

    private static double getPowerForSmoothProgressIndicator() {
        String rawValue = Registry.stringValue("indexing.progress.indicator.power");
        if ("-".equals(rawValue)) {
            return 1.0;
        }
        try {
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException e) {
            return 1.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(29);
        }
        this.myProject.putUserData(INDEX_UPDATE_IN_PROGRESS, true);
        Object object = ourLastRunningTaskLock;
        synchronized (object) {
            this.myProject.putUserData(RUNNING_TASK, this);
        }
        this.performScanningAndIndexing(indicator);
    }

    @NotNull
    protected ProjectIndexingHistoryImpl performScanningAndIndexing(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(30);
        }
        ProjectIndexingHistoryImpl projectIndexingHistory = new ProjectIndexingHistoryImpl(this.myProject, this.myIndexingReason, this.myScanningType);
        this.myIndex.loadIndexes();
        this.myIndex.filesUpdateStarted(this.myProject, this.isFullIndexUpdate());
        IndexDiagnosticDumper.getInstance().onIndexingStarted(projectIndexingHistory);
        try {
            ((GistManagerImpl)GistManager.getInstance()).runWithMergingDependentCacheInvalidations(() -> this.scanAndUpdateUnindexedFiles(projectIndexingHistory, indicator));
        }
        catch (Throwable e) {
            projectIndexingHistory.setWasInterrupted(true);
            if (e instanceof ControlFlowException) {
                LOG.info("Cancelled indexing of " + this.myProject.getName());
            }
            throw e;
        }
        finally {
            this.myIndex.filesUpdateFinished(this.myProject);
            this.myProject.putUserData(INDEX_UPDATE_IN_PROGRESS, false);
            projectIndexingHistory.finishTotalUpdatingTime();
            IndexDiagnosticDumper.getInstance().onIndexingFinished(projectIndexingHistory);
        }
        ProjectIndexingHistoryImpl projectIndexingHistoryImpl = projectIndexingHistory;
        if (projectIndexingHistoryImpl == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(31);
        }
        return projectIndexingHistoryImpl;
    }

    public String toString() {
        String partialInfo = this.myPredefinedIndexableFilesIterators != null ? ", " + this.myPredefinedIndexableFilesIterators.size() + " iterators" : "";
        return "UnindexedFilesUpdater[" + this.myProject.getName() + partialInfo + "]";
    }

    public static int getNumberOfIndexingThreads() {
        int threadCount = Registry.intValue("caches.indexerThreadsCount");
        if (threadCount <= 0) {
            int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isCommandLine() ? 0 : 1;
            threadCount = Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() - coresToLeaveForOtherActivity, 4));
        }
        return threadCount;
    }

    public static int getMaxNumberOfIndexingThreads() {
        int threadCount = Registry.intValue("caches.indexerThreadsCount");
        return threadCount <= 0 ? 4 : threadCount;
    }

    public static int getNumberOfScanningThreads() {
        int scanningThreadCount = Registry.intValue("caches.scanningThreadsCount");
        if (scanningThreadCount > 0) {
            return scanningThreadCount;
        }
        int coresToLeaveForOtherActivity = DumbServiceImpl.ALWAYS_SMART ? UnindexedFilesUpdater.getMaxNumberOfIndexingThreads() : (ApplicationManager.getApplication().isCommandLine() ? 0 : 1);
        return Math.max(Runtime.getRuntime().availableProcessors() - coresToLeaveForOtherActivity, UnindexedFilesUpdater.getNumberOfIndexingThreads());
    }

    private static boolean skipInitialRefresh() {
        return SystemProperties.getBooleanProperty("ij.indexes.skip.initial.refresh", false);
    }

    public static void scanAndIndexProjectAfterOpen(@NotNull Project project2, boolean startSuspended, @Nullable @NonNls String indexingReason) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(32);
        }
        if (TestModeFlags.is(INDEX_PROJECT_WITH_MANY_UPDATERS_TEST_KEY)) {
            LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
            List<IndexableFilesIterator> iterators = UnindexedFilesUpdater.collectProviders(project2, (FileBasedIndexImpl)FileBasedIndex.getInstance());
            for (IndexableFilesIterator iterator : iterators) {
                new UnindexedFilesUpdater(project2, startSuspended, true, Collections.singletonList(iterator), indexingReason, ScanningType.FULL_ON_PROJECT_OPEN).queue(project2);
            }
            project2.putUserData(CONTENT_SCANNED, true);
        } else {
            new UnindexedFilesUpdater(project2, startSuspended, true, null, indexingReason, ScanningType.FULL_ON_PROJECT_OPEN).queue(project2);
        }
    }

    static {
        GLOBAL_INDEXING_EXECUTOR = AppExecutorUtil.createBoundedApplicationPoolExecutor("Indexing", UnindexedFilesUpdater.getMaxNumberOfIndexingThreads());
        MINIMUM_NUMBER_OF_FILES_TO_RUN_CONCURRENT_INDEXING = SystemProperties.getIntProperty("intellij.indexing.minimum.number.of.files.to.run.concurrent.indexing", 100);
        CONTENT_SCANNED = Key.create("CONTENT_SCANNED");
        INDEX_UPDATE_IN_PROGRESS = Key.create("INDEX_UPDATE_IN_PROGRESS");
        RUNNING_TASK = Key.create("RUNNING_INDEX_UPDATER_TASK");
        ourLastRunningTaskLock = new Object();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 31: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanningType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskFromQueue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIndexingHistory";
                break;
            }
            case 8: 
            case 11: 
            case 24: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/UnindexedFilesUpdater";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerToFiles";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspender";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesUpdater";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "scan";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogScanningCompletedStageMessage";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProviders";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIndexableFilesConcurrently";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "performScanningAndIndexing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryMergeWith";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scan";
                break;
            }
            case 9: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 31: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scanAndUpdateUnindexedFiles";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "indexFiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLogScanningCompletedStageMessage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "listenToProgressSuspenderForSuspendedTimeDiagnostic";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isIndexUpdateInProgress";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isProjectContentFullyScanned";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectProviders";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectIndexableFilesConcurrently";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "performInDumbMode";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "performScanningAndIndexing";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "scanAndIndexProjectAfterOpen";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TestMode {
        PUSHING,
        PUSHING_AND_SCANNING;

    }
}

