/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Computable;
import com.intellij.util.SmartList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

class StripedLock {
    private static final int LOCK_SIZE = 16;
    private final ReadWriteLock[] myLocks = new ReadWriteLock[16];

    StripedLock() {
        for (int i = 0; i < this.myLocks.length; ++i) {
            this.myLocks[i] = new ReentrantReadWriteLock();
        }
    }

    ReadWriteLock getLock(int fileId) {
        if (fileId < 0) {
            fileId = -fileId;
        }
        return this.myLocks[(fileId & 0xFF) % this.myLocks.length];
    }

    <T> T withReadLock(int fileId, @NotNull Computable<T> computable) {
        if (computable == null) {
            StripedLock.$$$reportNull$$$0(0);
        }
        return this.withLock(fileId, computable, true);
    }

    <T> T withWriteLock(int fileId, @NotNull Computable<T> computable) {
        if (computable == null) {
            StripedLock.$$$reportNull$$$0(1);
        }
        return this.withLock(fileId, computable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLock(int fileId, @NotNull Computable<T> computable, boolean readLock) {
        if (computable == null) {
            StripedLock.$$$reportNull$$$0(2);
        }
        ReadWriteLock readWriteLock = this.getLock(fileId);
        Lock lock = readLock ? readWriteLock.readLock() : readWriteLock.writeLock();
        lock.lock();
        try {
            T t = computable.compute();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T withAllLocksWriteLocked(@NotNull Computable<T> computable) {
        if (computable == null) {
            StripedLock.$$$reportNull$$$0(3);
        }
        Lock[] locks = new Lock[this.myLocks.length];
        SmartList<Exception> exceptions = new SmartList<Exception>();
        boolean isComputed = false;
        T result2 = null;
        try {
            for (int i = 0; i < this.myLocks.length; ++i) {
                locks[i] = this.myLocks[i].writeLock();
                locks[i].lock();
            }
            result2 = computable.compute();
            isComputed = true;
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        finally {
            for (Lock lock : locks) {
                if (lock == null) break;
                try {
                    lock.unlock();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        if (!exceptions.isEmpty()) {
            IllegalStateException exception = new IllegalStateException("Exceptions during unlocking");
            for (Exception subException : exceptions) {
                exception.addSuppressed(subException);
            }
            throw exception;
        }
        assert (isComputed) : "Computation in StripedLock.withAllLocksWriteLocked was incorrect";
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "computable";
        objectArray2[1] = "com/intellij/util/indexing/StripedLock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withReadLock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withWriteLock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withLock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withAllLocksWriteLocked";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

