/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class StaleIndexesChecker {
    private static final Logger LOG = Logger.getInstance(StaleIndexesChecker.class);
    private static final ThreadLocal<Boolean> IS_IN_STALE_IDS_DELETION = new ThreadLocal();

    public static boolean isStaleIdDeletion() {
        return IS_IN_STALE_IDS_DELETION.get() == Boolean.TRUE;
    }

    @NotNull
    static IntSet checkIndexForStaleRecords(@NotNull UpdatableIndex<?, ?, FileContent, ?> index, boolean onStartup) throws StorageException {
        if (index == null) {
            StaleIndexesChecker.$$$reportNull$$$0(0);
        }
        if (!ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isEAP()) {
            IntSets.EmptySet emptySet = IntSets.EMPTY_SET;
            if (emptySet == null) {
                StaleIndexesChecker.$$$reportNull$$$0(1);
            }
            return emptySet;
        }
        IndexExtension extension2 = index.getExtension();
        IndexId indexId = extension2.getName();
        LOG.assertTrue(indexId.equals(StubUpdatingIndex.INDEX_ID));
        LOG.assertTrue(extension2 instanceof SingleEntryFileBasedIndexExtension);
        Int2ObjectOpenHashMap<String> staleFiles = new Int2ObjectOpenHashMap<String>();
        IntListIterator intListIterator = (onStartup ? FSRecords.getRemainFreeRecords() : FSRecords.getNewFreeRecords()).iterator();
        while (intListIterator.hasNext()) {
            String name2;
            int freeRecord = (Integer)intListIterator.next();
            Map dataAsMap = index.getIndexedFileData(freeRecord);
            Object data2 = ContainerUtil.getFirstItem(dataAsMap.values());
            if (data2 == null) continue;
            try {
                name2 = VfsImplUtil.getRecordPath((int)freeRecord);
            }
            catch (Exception e) {
                name2 = e.getMessage();
            }
            staleFiles.put(freeRecord, name2);
        }
        if (!staleFiles.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode() && onStartup) {
                Disposer.register(ApplicationManager.getApplication(), () -> LOG.error(StaleIndexesChecker.getStaleInputIdsMessage(staleFiles, indexId)));
            } else {
                LOG.error(StaleIndexesChecker.getStaleInputIdsMessage(staleFiles, indexId));
            }
        }
        IntSet intSet = staleFiles.keySet();
        if (intSet == null) {
            StaleIndexesChecker.$$$reportNull$$$0(2);
        }
        return intSet;
    }

    static void clearStaleIndexes(@NotNull IntSet staleIds) {
        if (staleIds == null) {
            StaleIndexesChecker.$$$reportNull$$$0(3);
        }
        IS_IN_STALE_IDS_DELETION.set(Boolean.TRUE);
        try {
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                for (Integer staleId : staleIds) {
                    StaleIndexesChecker.clearStaleIndexesForId(staleId);
                }
            });
        }
        finally {
            IS_IN_STALE_IDS_DELETION.remove();
        }
    }

    static void clearStaleIndexesForId(int staleInputId) {
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        IndexConfiguration state = fileBasedIndex.getRegisteredIndexes().getState();
        for (ID id2 : state.getIndexIDs()) {
            try {
                UpdatableIndex index = state.getIndex(id2);
                if (index == null) continue;
                fileBasedIndex.runUpdateForPersistentData(index.mapInputAndPrepareUpdate(staleInputId, null));
            }
            catch (Exception e) {
                LOG.info(e);
                fileBasedIndex.requestRebuild(id2);
            }
        }
    }

    @NotNull
    private static String getStaleInputIdsMessage(Int2ObjectMap<String> staleTrees, IndexId<?, ?> indexId) {
        String string2 = "`" + indexId + "` index contains several stale file ids (size = " + staleTrees.size() + "). Ids & filenames: " + StringUtil.first(staleTrees.toString(), 300, true) + ".";
        if (string2 == null) {
            StaleIndexesChecker.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/StaleIndexesChecker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staleIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/StaleIndexesChecker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkIndexForStaleRecords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaleInputIdsMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkIndexForStaleRecords";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "clearStaleIndexes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

