/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import org.jetbrains.annotations.NotNull;

final class ProjectFileBasedIndexStartupActivity
implements StartupActivity.RequiredForSmartMode {
    private static final Logger LOG = Logger.getInstance(ProjectFileBasedIndexStartupActivity.class);

    ProjectFileBasedIndexStartupActivity() {
        ApplicationManager.getApplication().getMessageBus().simpleConnect().subscribe(ProjectManager.TOPIC, new ProjectManagerListener(){

            @Override
            public void projectClosing(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProjectFileBasedIndexStartupActivity.removeProjectIndexableSet(project2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/ProjectFileBasedIndexStartupActivity$1", "projectClosing"));
            }
        });
    }

    @Override
    public void runActivity(final @NotNull Project project2) {
        if (project2 == null) {
            ProjectFileBasedIndexStartupActivity.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isInternal()) {
            project2.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

                @Override
                public void exitDumbMode() {
                    LOG.info("Has changed files: " + FileBasedIndexProjectHandler.mightHaveManyChangedFilesInProject(project2) + "; project=" + project2);
                }
            });
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        PushedFilePropertiesUpdater propertiesUpdater = PushedFilePropertiesUpdater.getInstance(project2);
        if (propertiesUpdater instanceof PushedFilePropertiesUpdaterImpl) {
            ((PushedFilePropertiesUpdaterImpl)propertiesUpdater).initializeProperties();
        }
        fileBasedIndex.registerProjectFileSets(project2);
        if (fileBasedIndex instanceof FileBasedIndexImpl) {
            boolean suspended = IndexInfrastructure.isIndexesInitializationSuspended();
            UnindexedFilesUpdater.scanAndIndexProjectAfterOpen(project2, suspended, "On project open");
        }
        Disposer.register(project2, () -> ProjectFileBasedIndexStartupActivity.removeProjectIndexableSet(project2));
    }

    private static void removeProjectIndexableSet(@NotNull Project project2) {
        if (project2 == null) {
            ProjectFileBasedIndexStartupActivity.$$$reportNull$$$0(1);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> FileBasedIndex.getInstance().removeProjectFileSets(project2)), IndexingBundle.message((String)"removing.indexable.set.project.handler", (Object[])new Object[0]), false, project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/util/indexing/ProjectFileBasedIndexStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeProjectIndexableSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

