/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public final class IndexVersion {
    private static final int BASE_VERSION = 15;
    private static final IndexVersion NON_EXISTING_INDEX_VERSION = new IndexVersion(0L, -1, -1L);
    private static final int MIN_FS_MODIFIED_TIMESTAMP_RESOLUTION = 2000;
    private static final int OUR_INDICES_TIMESTAMP_INCREMENT = SystemProperties.getIntProperty("idea.indices.timestamp.resolution", 1);
    private static final ConcurrentMap<ID<?, ?>, IndexVersion> ourIndexIdToCreationStamp = new ConcurrentHashMap();
    private static volatile int ourVersion = -1;
    private static volatile long ourLastStamp;
    private final long myModificationCount;
    private final int myIndexVersion;
    private final int myCommonIndicesVersion;
    private final long myVfsCreationStamp;

    IndexVersion(long modificationCount, int indexVersion, long vfsCreationStamp) {
        this.myModificationCount = modificationCount;
        IndexVersion.advanceIndexStamp(modificationCount);
        this.myIndexVersion = indexVersion;
        this.myCommonIndicesVersion = IndexVersion.getVersion();
        this.myVfsCreationStamp = vfsCreationStamp;
    }

    private static void advanceIndexStamp(long modificationCount) {
        ourLastStamp = Math.max(modificationCount, ourLastStamp);
    }

    IndexVersion(DataInput in) throws IOException {
        this.myIndexVersion = DataInputOutputUtil.readINT(in);
        this.myCommonIndicesVersion = DataInputOutputUtil.readINT(in);
        this.myVfsCreationStamp = DataInputOutputUtil.readTIME(in);
        this.myModificationCount = DataInputOutputUtil.readTIME(in);
        IndexVersion.advanceIndexStamp(this.myModificationCount);
    }

    void write(DataOutput os) throws IOException {
        DataInputOutputUtil.writeINT(os, this.myIndexVersion);
        DataInputOutputUtil.writeINT(os, this.myCommonIndicesVersion);
        DataInputOutputUtil.writeTIME(os, this.myVfsCreationStamp);
        DataInputOutputUtil.writeTIME(os, this.myModificationCount);
    }

    IndexVersion nextVersion(int indexVersion, long vfsCreationStamp) {
        long modificationCount = IndexVersion.calcNextVersion(this == NON_EXISTING_INDEX_VERSION ? ourLastStamp : this.myModificationCount);
        return new IndexVersion(modificationCount, indexVersion, vfsCreationStamp);
    }

    private static long calcNextVersion(long modificationCount) {
        return Math.max(System.currentTimeMillis(), Math.max(modificationCount + 2000L, ourLastStamp + (long)OUR_INDICES_TIMESTAMP_INCREMENT));
    }

    static void initPersistentIndexStamp(DataInput in) throws IOException {
        IndexVersion.advanceIndexStamp(DataInputOutputUtil.readTIME(in));
    }

    static void savePersistentIndexStamp(DataOutput out) throws IOException {
        DataInputOutputUtil.writeTIME(out, ourLastStamp);
    }

    private static int getVersion() {
        if (ourVersion == -1) {
            int version = 15;
            for (FileBasedIndexInfrastructureExtension ex : (FileBasedIndexInfrastructureExtension[])FileBasedIndexInfrastructureExtension.EP_NAME.getExtensions()) {
                int extensionVersion = ex.getVersion();
                if (extensionVersion == -1) continue;
                version = 31 * version + extensionVersion;
            }
            ourVersion = version;
        }
        return ourVersion;
    }

    static void clearCachedIndexVersions() {
        ourVersion = -1;
        ourIndexIdToCreationStamp.clear();
    }

    public static IndexVersionDiff versionDiffers(@NotNull ID<?, ?> indexId, int currentIndexVersion) {
        if (indexId == null) {
            IndexVersion.$$$reportNull$$$0(0);
        }
        IndexVersion version = IndexVersion.getIndexVersion(indexId);
        if (version.myIndexVersion == -1) {
            return new IndexVersionDiff.InitialBuild(currentIndexVersion);
        }
        if (version.myIndexVersion != currentIndexVersion) {
            return new IndexVersionDiff.VersionChanged(version.myIndexVersion, currentIndexVersion, "index version");
        }
        if (version.myCommonIndicesVersion != IndexVersion.getVersion()) {
            return new IndexVersionDiff.VersionChanged(version.myCommonIndicesVersion, IndexVersion.getVersion(), "common index version");
        }
        long timestamp = FSRecords.getCreationTimestamp();
        if (version.myVfsCreationStamp != timestamp) {
            return new IndexVersionDiff.VersionChanged(version.myVfsCreationStamp, timestamp, "vfs creation stamp");
        }
        return IndexVersionDiff.UP_TO_DATE;
    }

    public static synchronized void rewriteVersion(@NotNull ID<?, ?> indexId, int version) throws IOException {
        if (indexId == null) {
            IndexVersion.$$$reportNull$$$0(1);
        }
        if (FileBasedIndex.USE_IN_MEMORY_INDEX) {
            return;
        }
        Path file2 = IndexInfrastructure.getVersionFile(indexId);
        if (FileBasedIndexImpl.LOG.isDebugEnabled()) {
            FileBasedIndexImpl.LOG.debug("Rewriting " + file2 + "," + version);
        }
        IndexVersion newIndexVersion = IndexVersion.getIndexVersion(indexId).nextVersion(version, FSRecords.getCreationTimestamp());
        if (Files.exists(file2, new LinkOption[0])) {
            FileUtil.deleteWithRenaming(file2.toFile());
        } else {
            Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        }
        try (DataOutputStream os = FileUtilRt.doIOOperation(lastAttempt -> {
            try {
                return new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(file2, new OpenOption[0])));
            }
            catch (IOException ex) {
                if (lastAttempt) {
                    throw ex;
                }
                return null;
            }
        });){
            assert (os != null);
            newIndexVersion.write(os);
            ourIndexIdToCreationStamp.put(indexId, newIndexVersion);
        }
    }

    static long getIndexCreationStamp(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexVersion.$$$reportNull$$$0(2);
        }
        IndexVersion version = IndexVersion.getIndexVersion(indexName);
        return version.myModificationCount;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static IndexVersion getIndexVersion(@NotNull ID<?, ?> indexName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexVersion";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "versionDiffers";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rewriteVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndexCreationStamp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndexVersion";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface IndexVersionDiff {
        public static final IndexVersionDiff UP_TO_DATE = new IndexVersionDiff(){

            @Override
            @NotNull
            public String getLogText() {
                return "";
            }
        };

        @NotNull
        public String getLogText();

        public static class VersionChanged
        implements IndexVersionDiff {
            private final long myPreviousVersion;
            private final long myActualVersion;
            private final String myVersionType;

            public VersionChanged(long previousVersion, long actualVersion, String type) {
                this.myPreviousVersion = previousVersion;
                this.myActualVersion = actualVersion;
                this.myVersionType = type;
            }

            @Override
            @NotNull
            public String getLogText() {
                String string2 = "(" + this.myVersionType + " : " + this.myPreviousVersion + " -> " + this.myActualVersion + ")";
                if (string2 == null) {
                    VersionChanged.$$$reportNull$$$0(0);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexVersion$IndexVersionDiff$VersionChanged", "getLogText"));
            }
        }

        public static class CorruptedRebuild
        implements IndexVersionDiff {
            private final int myVersion;

            public CorruptedRebuild(int version) {
                this.myVersion = version;
            }

            @Override
            @NotNull
            public String getLogText() {
                String string2 = "(corrupted, v = " + this.myVersion + ")";
                if (string2 == null) {
                    CorruptedRebuild.$$$reportNull$$$0(0);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexVersion$IndexVersionDiff$CorruptedRebuild", "getLogText"));
            }
        }

        public static class InitialBuild
        implements IndexVersionDiff {
            private final int myVersion;

            public InitialBuild(int version) {
                this.myVersion = version;
            }

            @Override
            @NotNull
            public String getLogText() {
                String string2 = "(v = " + this.myVersion + ")";
                if (string2 == null) {
                    InitialBuild.$$$reportNull$$$0(0);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexVersion$IndexVersionDiff$InitialBuild", "getLogText"));
            }
        }
    }
}

