/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.indexing.CorruptionMarker;
import com.intellij.util.indexing.FbiSnapshot;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileTypeTracker;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0012\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/FileBasedIndexTumbler;", "", "reason", "", "Lorg/jetbrains/annotations/NonNls;", "(Ljava/lang/String;)V", "dumbModeSemaphore", "Lcom/intellij/util/concurrency/Semaphore;", "fileBasedIndex", "Lcom/intellij/util/indexing/FileBasedIndexImpl;", "fileTypeTracker", "Lcom/intellij/util/indexing/FileTypeTracker;", "nestedLevelCount", "", "snapshot", "Lcom/intellij/util/indexing/FbiSnapshot;", "turnOff", "", "turnOn", "beforeIndexTasksStarted", "Ljava/lang/Runnable;", "Companion", "intellij.platform.lang.impl"})
public final class FileBasedIndexTumbler {
    private final FileBasedIndexImpl fileBasedIndex;
    private final Semaphore dumbModeSemaphore;
    private int nestedLevelCount;
    private FbiSnapshot snapshot;
    private FileTypeTracker fileTypeTracker;
    private final String reason;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void turnOff() {
        Application app;
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        LOG.assertTrue(application.isDispatchThread());
        LOG.assertTrue(!app.isWriteAccessAllowed());
        try {
            if (this.nestedLevelCount == 0) {
                boolean headless = app.isHeadlessEnvironment();
                if (!headless) {
                    boolean wasUp = this.dumbModeSemaphore.isUp();
                    this.dumbModeSemaphore.down();
                    if (wasUp) {
                        for (Project project2 : ProjectUtil.getOpenProjects()) {
                            DumbService dumbService = DumbService.getInstance(project2);
                            dumbService.cancelAllTasksAndWait();
                            new Companion.MyDumbModeTask(this.dumbModeSemaphore).queue(project2);
                        }
                    }
                }
                LOG.assertTrue(this.fileTypeTracker == null);
                this.fileTypeTracker = new FileTypeTracker();
                this.fileBasedIndex.waitUntilIndicesAreInitialized();
                this.fileBasedIndex.performShutdown(true, this.reason);
                this.fileBasedIndex.dropRegisteredIndexes();
                boolean indexesAreOk = RebuildStatus.isOk();
                RebuildStatus.reset();
                IndexingStamp.dropTimestampMemoryCaches();
                LOG.assertTrue(this.snapshot == null);
                this.snapshot = indexesAreOk ? (FbiSnapshot)FbiSnapshot.Impl.Companion.capture() : (FbiSnapshot)FbiSnapshot.RebuildRequired.INSTANCE;
            }
        }
        finally {
            int n = this.nestedLevelCount;
            this.nestedLevelCount = n + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @JvmOverloads
    public final void turnOn(@Nullable Runnable beforeIndexTasksStarted) {
        block13: {
            v0 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ApplicationManager.getApplication()");
            FileBasedIndexTumbler.LOG.assertTrue(v0.isWriteThread());
            var2_2 = this.nestedLevelCount;
            this.nestedLevelCount = var2_2 + -1;
            if (this.nestedLevelCount != 0) break block13;
            try {
                this.fileBasedIndex.loadIndexes();
                v1 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"ApplicationManager.getApplication()");
                headless = v1.isHeadlessEnvironment();
                if (headless) {
                    this.fileBasedIndex.waitUntilIndicesAreInitialized();
                }
                if (!headless) {
                    this.dumbModeSemaphore.up();
                }
                if (CorruptionMarker.requireInvalidation() || Registry.is("run.index.rescanning.on.plugin.load.unload") || this.snapshot instanceof FbiSnapshot.RebuildRequired) ** GOTO lbl-1000
                v2 = this.snapshot;
                if (v2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FbiSnapshot.Impl");
                }
                if (FbiSnapshot.Impl.Companion.isRescanningRequired((FbiSnapshot.Impl)v2, FbiSnapshot.Impl.Companion.capture())) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = runRescanning = false;
                }
                if (runRescanning) {
                    v4 = beforeIndexTasksStarted;
                    if (v4 != null) {
                        v4.run();
                    }
                    IndexingFlag.cleanupProcessedFlag();
                    for (Project project : ProjectUtil.getOpenProjects()) {
                        new UnindexedFilesUpdater(project, this.reason).queue(project);
                    }
                    FileBasedIndexTumbler.LOG.info("Index rescanning has been started after `" + this.reason + "`");
                } else {
                    FileBasedIndexTumbler.LOG.info("Index rescanning has been skipped after `" + this.reason + "`");
                }
            }
            finally {
                v5 = this.fileTypeTracker;
                if (v5 != null) {
                    it = var2_3 = v5;
                    $i$a$-let-FileBasedIndexTumbler$turnOn$1 = false;
                    Disposer.dispose(it);
                }
                this.fileTypeTracker = null;
                this.snapshot = null;
            }
        }
    }

    public static /* synthetic */ void turnOn$default(FileBasedIndexTumbler fileBasedIndexTumbler, Runnable runnable, int n, Object object) {
        if ((n & 1) != 0) {
            runnable = null;
        }
        fileBasedIndexTumbler.turnOn(runnable);
    }

    @JvmOverloads
    public final void turnOn() {
        FileBasedIndexTumbler.turnOn$default(this, null, 1, null);
    }

    public FileBasedIndexTumbler(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.reason = reason;
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        }
        this.fileBasedIndex = (FileBasedIndexImpl)fileBasedIndex;
        this.dumbModeSemaphore = new Semaphore();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileBasedIndexTumbler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/indexing/FileBasedIndexTumbler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MyDumbModeTask", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/FileBasedIndexTumbler$Companion$MyDumbModeTask;", "Lcom/intellij/openapi/project/DumbModeTask;", "semaphore", "Lcom/intellij/util/concurrency/Semaphore;", "(Lcom/intellij/util/concurrency/Semaphore;)V", "getSemaphore", "()Lcom/intellij/util/concurrency/Semaphore;", "performInDumbMode", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "toString", "", "tryMergeWith", "taskFromQueue", "intellij.platform.lang.impl"})
        private static final class MyDumbModeTask
        extends DumbModeTask {
            @NotNull
            private final Semaphore semaphore;

            @Override
            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(IndexingBundle.message((String)"indexes.reloading", (Object[])new Object[0]));
                this.semaphore.waitFor();
            }

            @NotNull
            public String toString() {
                return "Plugin loading/unloading";
            }

            @Override
            @Nullable
            public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
                Intrinsics.checkNotNullParameter((Object)taskFromQueue, (String)"taskFromQueue");
                return taskFromQueue instanceof MyDumbModeTask && ((MyDumbModeTask)taskFromQueue).semaphore == this.semaphore ? (DumbModeTask)this : null;
            }

            @NotNull
            public final Semaphore getSemaphore() {
                return this.semaphore;
            }

            public MyDumbModeTask(@NotNull Semaphore semaphore) {
                Intrinsics.checkNotNullParameter((Object)semaphore, (String)"semaphore");
                this.semaphore = semaphore;
            }
        }
    }
}

