/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.contentQueue.IndexUpdateRunner;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import com.intellij.util.indexing.diagnostic.ScanningType;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileBasedIndexProjectHandler {
    private static final Logger LOG = Logger.getInstance(FileBasedIndexProjectHandler.class);
    @ApiStatus.Internal
    public static final int ourMinFilesToStartDumbMode = Registry.intValue("ide.dumb.mode.minFilesToStart", 20);
    private static final int ourMinFilesSizeToStartDumbMode = Registry.intValue("ide.dumb.mode.minFilesSizeToStart", 0x100000);

    public static void scheduleReindexingInDumbMode(@NotNull Project project2) {
        FileBasedIndex i;
        if (project2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(0);
        }
        if ((i = FileBasedIndex.getInstance()) instanceof FileBasedIndexImpl && IndexInfrastructure.hasIndices() && !project2.isDisposed() && FileBasedIndexProjectHandler.mightHaveManyChangedFilesInProject(project2)) {
            new ProjectChangedFilesIndexingTask(project2).queue(project2);
        }
    }

    @ApiStatus.Internal
    public static boolean mightHaveManyChangedFilesInProject(Project project2) {
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (!(fileBasedIndex instanceof FileBasedIndexImpl)) {
            return false;
        }
        final long start2 = System.currentTimeMillis();
        return !((FileBasedIndexImpl)fileBasedIndex).processChangedFiles(project2, (Processor<? super VirtualFile>)new Processor<VirtualFile>(){
            int filesInProjectToBeIndexed;
            long sizeOfFilesToBeIndexed;

            @Override
            public boolean process(VirtualFile file2) {
                ++this.filesInProjectToBeIndexed;
                if (file2.isValid() && !file2.isDirectory()) {
                    this.sizeOfFilesToBeIndexed += file2.getLength();
                }
                return this.filesInProjectToBeIndexed < ourMinFilesToStartDumbMode && this.sizeOfFilesToBeIndexed < (long)ourMinFilesSizeToStartDumbMode && System.currentTimeMillis() < start2 + 100L;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexProjectHandler", "scheduleReindexingInDumbMode"));
    }

    private static class ProjectChangedFilesIndexingTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        private ProjectChangedFilesIndexingTask(@NotNull Project project2) {
            if (project2 == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(1);
            }
            indicator.setIndeterminate(false);
            indicator.setText(IndexingBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
            long refreshedFilesCalcDuration = System.nanoTime();
            FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
            Collection<VirtualFile> files2 = fileBasedIndex.getFilesToUpdate(this.myProject);
            refreshedFilesCalcDuration = System.nanoTime() - refreshedFilesCalcDuration;
            LOG.info("Reindexing refreshed files of " + this.myProject.getName() + " : " + files2.size() + " to update, calculated in " + TimeUnit.NANOSECONDS.toMillis(refreshedFilesCalcDuration) + "ms");
            if (!files2.isEmpty()) {
                PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                ProjectChangedFilesIndexingTask.indexChangedFiles(files2, indicator, fileBasedIndex, this.myProject, refreshedFilesCalcDuration);
                snapshot.logResponsivenessSinceCreation("Reindexing refreshed files of " + this.myProject.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void indexChangedFiles(@NotNull Collection<VirtualFile> files2, @NotNull ProgressIndicator indicator, @NotNull FileBasedIndexImpl index, @NotNull Project project2, long refreshedFilesCalcDuration) {
            if (files2 == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(3);
            }
            if (index == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(4);
            }
            if (project2 == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(5);
            }
            ProjectIndexingHistoryImpl projectIndexingHistory = new ProjectIndexingHistoryImpl(project2, "On refresh of " + files2.size() + " files", ScanningType.REFRESH);
            IndexDiagnosticDumper.getInstance().onIndexingStarted(projectIndexingHistory);
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).fireUpdateStarted(project2);
            try {
                int numberOfIndexingThreads = UnindexedFilesUpdater.getNumberOfIndexingThreads();
                LOG.info("Using " + numberOfIndexingThreads + " " + StringUtil.pluralize("thread", numberOfIndexingThreads) + " for indexing");
                IndexUpdateRunner indexUpdateRunner = new IndexUpdateRunner(index, UnindexedFilesUpdater.GLOBAL_INDEXING_EXECUTOR, numberOfIndexingThreads);
                IndexUpdateRunner.IndexingInterruptedException interruptedException = null;
                projectIndexingHistory.startStage(ProjectIndexingHistoryImpl.Stage.Indexing);
                String fileSetName = "Refreshed files";
                IndexUpdateRunner.FileSet fileSet = new IndexUpdateRunner.FileSet(project2, fileSetName, files2);
                try {
                    indexUpdateRunner.indexFiles(project2, Collections.singletonList(fileSet), indicator, projectIndexingHistory);
                }
                catch (IndexUpdateRunner.IndexingInterruptedException e) {
                    projectIndexingHistory.setWasInterrupted(true);
                    interruptedException = e;
                }
                finally {
                    projectIndexingHistory.stopStage(ProjectIndexingHistoryImpl.Stage.Indexing);
                    projectIndexingHistory.finishTotalUpdatingTime();
                }
                ScanningStatistics scanningStatistics = new ScanningStatistics(fileSetName);
                scanningStatistics.setNumberOfScannedFiles(files2.size());
                scanningStatistics.setNumberOfFilesForIndexing(files2.size());
                scanningStatistics.setScanningTime(refreshedFilesCalcDuration);
                scanningStatistics.setNoRootsForRefresh();
                projectIndexingHistory.addScanningStatistics(scanningStatistics);
                projectIndexingHistory.addProviderStatistics(fileSet.statistics);
                if (interruptedException != null) {
                    ExceptionUtil.rethrow(interruptedException.getCause());
                }
            }
            finally {
                IndexDiagnosticDumper.getInstance().onIndexingFinished(projectIndexingHistory);
                projectIndexingHistory.setScanFilesDuration(Duration.ofNanos(refreshedFilesCalcDuration));
                ((FileBasedIndexImpl)FileBasedIndex.getInstance()).fireUpdateFinished(project2);
            }
        }

        @Override
        @Nullable
        public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
            if (taskFromQueue == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(6);
            }
            if (taskFromQueue instanceof ProjectChangedFilesIndexingTask && ((ProjectChangedFilesIndexingTask)taskFromQueue).myProject.equals(this.myProject)) {
                return this;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskFromQueue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexProjectHandler$ProjectChangedFilesIndexingTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexChangedFiles";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryMergeWith";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

