/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualFileGistImpl<Data>
implements VirtualFileGist<Data> {
    private static final Logger LOG = Logger.getInstance(VirtualFileGist.class);
    private static final int ourInternalVersion = 2;
    static final Key<AtomicInteger> GIST_INVALIDATION_COUNT_KEY = Key.create("virtual.file.gist.invalidation.count");
    @NotNull
    private final String myId;
    private final int myVersion;
    @NotNull
    private final VirtualFileGist.GistCalculator<Data> myCalculator;
    @NotNull
    private final DataExternalizer<Data> myExternalizer;
    private static final Map<Pair<String, Integer>, FileAttribute> ourAttributes = FactoryMap.create(key -> new FileAttribute((String)key.first, (Integer)key.second, false));

    VirtualFileGistImpl(@NotNull String id2, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull VirtualFileGist.GistCalculator<Data> calcData) {
        if (id2 == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(0);
        }
        if (externalizer == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(1);
        }
        if (calcData == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(2);
        }
        this.myId = id2;
        this.myVersion = version;
        this.myExternalizer = externalizer;
        this.myCalculator = calcData;
    }

    public Data getFileData(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(3);
        }
        return this.getOrCalculateAndCache(project2, file2, this.myCalculator).get();
    }

    @Nullable
    public Supplier<Data> getUpToDateOrNull(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(4);
        }
        return this.getOrCalculateAndCache(project2, file2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(value="_, _, !null -> !null")
    @Nullable
    private Supplier<Data> getOrCalculateAndCache(@Nullable Project project2, @NotNull VirtualFile file2, @Nullable VirtualFileGist.GistCalculator<Data> calculator) {
        if (file2 == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        if (!(file2 instanceof VirtualFileWithId)) {
            if (calculator == null) return null;
            Object value = calculator.calcData(project2, file2);
            return () -> value;
        }
        AtomicInteger invalidationCount = file2.getUserData(GIST_INVALIDATION_COUNT_KEY);
        int stamp = Objects.hash(file2.getModificationCount(), ((GistManagerImpl)GistManager.getInstance()).getReindexCount(), invalidationCount != null ? invalidationCount.get() : 0);
        try (AttributeInputStream stream = this.getFileAttribute(project2).readFileAttribute(file2);){
            if (stream != null && DataInputOutputUtil.readINT(stream) == stamp) {
                Object value = stream.readBoolean() ? this.myExternalizer.read(stream) : null;
                Supplier<Object> supplier2 = () -> value;
                return supplier2;
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
        if (calculator == null) return null;
        Object value = calculator.calcData(project2, file2);
        this.cacheResult(stamp, value, project2, file2);
        return () -> value;
    }

    private void cacheResult(int modCount, @Nullable Data result2, Project project2, VirtualFile file2) {
        try (AttributeOutputStream out = this.getFileAttribute(project2).writeFileAttribute(file2);){
            DataInputOutputUtil.writeINT(out, modCount);
            out.writeBoolean(result2 != null);
            if (result2 != null) {
                this.myExternalizer.save(out, result2);
            }
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAttribute getFileAttribute(@Nullable Project project2) {
        Map<Pair<String, Integer>, FileAttribute> map2 = ourAttributes;
        synchronized (map2) {
            return ourAttributes.get(Pair.create(this.myId + (project2 == null ? "###noProject###" : project2.getLocationHash()), this.myVersion + 2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calcData";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/gist/VirtualFileGistImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getUpToDateOrNull";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCalculateAndCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

