/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.NullableFunction;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.io.DataExternalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiFileGistImpl<Data>
implements PsiFileGist<Data> {
    private static final ModificationTracker ourReindexTracker = () -> ((GistManagerImpl)GistManager.getInstance()).getReindexCount();
    private final VirtualFileGist<Data> myPersistence;
    private final VirtualFileGist.GistCalculator<Data> myCalculator;
    private final Key<CachedValue<Data>> myCacheKey;

    PsiFileGistImpl(@NotNull String id2, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull NullableFunction<? super PsiFile, ? extends Data> calculator) {
        if (id2 == null) {
            PsiFileGistImpl.$$$reportNull$$$0(0);
        }
        if (externalizer == null) {
            PsiFileGistImpl.$$$reportNull$$$0(1);
        }
        if (calculator == null) {
            PsiFileGistImpl.$$$reportNull$$$0(2);
        }
        this.myCalculator = (project2, file2) -> {
            PsiFile psiFile = PsiFileGistImpl.getPsiFile(project2, file2);
            return psiFile == null ? null : calculator.fun(psiFile);
        };
        this.myPersistence = GistManager.getInstance().newVirtualFileGist(id2, version, externalizer, this.myCalculator);
        this.myCacheKey = Key.create("PsiFileGist " + id2);
    }

    public Data getFileData(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiFileGistImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (PsiFileGistImpl.shouldUseMemoryStorage(file2)) {
            return (Data)CachedValuesManager.getManager(file2.getProject()).getCachedValue(file2, this.myCacheKey, () -> {
                Object data2 = this.myCalculator.calcData(file2.getProject(), PsiFileGistImpl.getVirtualFile(file2));
                return CachedValueProvider.Result.create(data2, file2, ourReindexTracker);
            }, false);
        }
        file2.putUserData(this.myCacheKey, null);
        return (Data)this.myPersistence.getFileData(file2.getProject(), PsiFileGistImpl.getVirtualFile(file2));
    }

    @NotNull
    private static VirtualFile getVirtualFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiFileGistImpl.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile2 = file2.getViewProvider().getVirtualFile();
        if (virtualFile2 == null) {
            PsiFileGistImpl.$$$reportNull$$$0(5);
        }
        return virtualFile2;
    }

    private static boolean shouldUseMemoryStorage(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiFileGistImpl.$$$reportNull$$$0(6);
        }
        if (!(PsiFileGistImpl.getVirtualFile(file2) instanceof NewVirtualFile)) {
            return true;
        }
        PsiDocumentManager pdm = PsiDocumentManager.getInstance(file2.getProject());
        Document document = pdm.getCachedDocument(file2);
        return document != null && (pdm.isUncommited(document) || FileDocumentManager.getInstance().isDocumentUnsaved(document));
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull Project project2, @NotNull VirtualFile file2) {
        PsiFile psi;
        if (project2 == null) {
            PsiFileGistImpl.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            PsiFileGistImpl.$$$reportNull$$$0(8);
        }
        if (!((psi = PsiManager.getInstance(project2).findFile(file2)) instanceof PsiFileImpl) || ((PsiFileImpl)psi).isContentsLoaded()) {
            return psi;
        }
        FileType fileType = file2.getFileType();
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        return FileContentImpl.createFileFromText(project2, psi.getViewProvider().getContents(), (LanguageFileType)fileType, file2, file2.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculator";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/gist/PsiFileGistImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/gist/PsiFileGistImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseMemoryStorage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

