/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fmap;

import com.intellij.util.fmap.FMap;
import com.intellij.util.fmap.TwoKeysFMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OneKeyFMap<@NotNull K, @NotNull V>
implements FMap<K, V> {
    private final K myKey;
    private final V myValue;

    OneKeyFMap(K key, V value) {
        this.myKey = key;
        this.myValue = value;
    }

    @Override
    @NotNull
    public FMap<K, V> plus(K key, V value) {
        if (this.myKey.equals(key)) {
            if (this.myValue.equals(value)) {
                OneKeyFMap oneKeyFMap = this;
                if (oneKeyFMap == null) {
                    OneKeyFMap.$$$reportNull$$$0(0);
                }
                return oneKeyFMap;
            }
            return new OneKeyFMap<K, V>(key, value);
        }
        return new TwoKeysFMap<K, V>(this.myKey, this.myValue, key, value);
    }

    @Override
    @NotNull
    public FMap<K, V> minus(K key) {
        OneKeyFMap oneKeyFMap = this.myKey.equals(key) ? FMap.empty() : this;
        if (oneKeyFMap == null) {
            OneKeyFMap.$$$reportNull$$$0(1);
        }
        return oneKeyFMap;
    }

    @Override
    @Nullable
    public V get(K key) {
        return this.myKey.equals(key) ? (V)this.myValue : null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    @NotNull
    public Collection<K> keys() {
        Set<K> set2 = Collections.singleton(this.myKey);
        if (set2 == null) {
            OneKeyFMap.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @Override
    @NotNull
    public Map<K, V> toMap() {
        Map<K, V> map2 = Collections.singletonMap(this.myKey, this.myValue);
        if (map2 == null) {
            OneKeyFMap.$$$reportNull$$$0(3);
        }
        return map2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneKeyFMap map2 = (OneKeyFMap)o;
        return this.myKey.equals(map2.myKey) && this.myValue.equals(map2.myValue);
    }

    public int hashCode() {
        return Objects.hash(this.myKey, this.myValue);
    }

    public String toString() {
        return String.format("[%s: %s,]", this.myKey, this.myValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/fmap/OneKeyFMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

