/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.RefValueHashMapUtil;
import com.intellij.util.containers.SoftHashMap;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class SoftKeySoftValueHashMap<K, V>
implements Map<K, V> {
    private final RefHashMap<K, ValueReference<K, V>> mySoftKeyMap = new SoftHashMap<K, ValueReference<K, V>>(4);
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    SoftKeySoftValueHashMap() {
    }

    private boolean processQueue() {
        ValueReference ref;
        boolean processed = this.mySoftKeyMap.processQueue();
        while ((ref = (ValueReference)this.myQueue.poll()) != null) {
            RefHashMap.Key key = ref.key;
            this.mySoftKeyMap.removeKey(key);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(Object key) {
        ValueReference<K, V> ref = this.mySoftKeyMap.get(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        RefHashMap.Key<K> softKey = this.mySoftKeyMap.createKey(key);
        ValueReference reference2 = new ValueReference(softKey, value, this.myQueue);
        ValueReference oldRef = this.mySoftKeyMap.putKey(softKey, reference2);
        return (V)SoftReference.dereference(oldRef);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueReference<K, V> ref = this.mySoftKeyMap.remove(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            SoftKeySoftValueHashMap.$$$reportNull$$$0(0);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.mySoftKeyMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.mySoftKeyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mySoftKeyMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        throw RefValueHashMapUtil.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(Object value) {
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set2 = this.mySoftKeyMap.keySet();
        if (set2 == null) {
            SoftKeySoftValueHashMap.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result2 = new ArrayList();
        Collection refs = this.mySoftKeyMap.values();
        for (ValueReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result2.add(value);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SoftKeySoftValueHashMap.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/SoftKeySoftValueHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/SoftKeySoftValueHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ValueReference<K, V>
    extends java.lang.ref.SoftReference<V> {
        private final RefHashMap.Key<K> key;

        private ValueReference(RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
            super(referent, q);
            this.key = key;
        }
    }
}

