/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.SoftHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;

public final class SoftArrayHashMap<T, V>
implements Cloneable {
    private Map<T, SoftArrayHashMap<T, V>> myContinuationMap;
    private Map<T, V> myValuesMap;
    private V myEmptyValue;
    private final HashingStrategy<T> myStrategy;

    public SoftArrayHashMap() {
        this(HashingStrategy.canonical());
    }

    private SoftArrayHashMap(@NotNull HashingStrategy<T> strategy) {
        if (strategy == null) {
            SoftArrayHashMap.$$$reportNull$$$0(0);
        }
        this.myStrategy = strategy;
    }

    private V get(T[] array, int index) {
        SoftArrayHashMap<T, V> map2;
        if (index == array.length - 1) {
            return this.myValuesMap != null ? (V)this.myValuesMap.get(array[index]) : null;
        }
        if (this.myContinuationMap != null && (map2 = this.myContinuationMap.get(array[index])) != null) {
            return super.get(array, index + 1);
        }
        return null;
    }

    public V get(T[] key) {
        if (key.length == 0) {
            return this.myEmptyValue;
        }
        return this.get(key, 0);
    }

    public boolean processLeafEntries(@NotNull BiPredicate<? super T, ? super V> processor) {
        if (processor == null) {
            SoftArrayHashMap.$$$reportNull$$$0(1);
        }
        if (this.myValuesMap != null) {
            for (Object object : this.myValuesMap.keySet()) {
                if (processor.test(object, this.myValuesMap.get(object))) continue;
                return false;
            }
        }
        if (this.myContinuationMap != null) {
            for (SoftArrayHashMap softArrayHashMap : this.myContinuationMap.values()) {
                if (softArrayHashMap.processLeafEntries(processor)) continue;
                return false;
            }
        }
        return true;
    }

    private void put(T[] array, int index, V value) {
        T key = array[index];
        if (index == array.length - 1) {
            if (this.myValuesMap == null) {
                this.myValuesMap = new SoftHashMap(this.myStrategy);
            }
            this.myValuesMap.put(key, value);
        } else {
            SoftArrayHashMap<T, V> softArrayHashMap;
            if (this.myContinuationMap == null) {
                this.myContinuationMap = new SoftHashMap<T, SoftArrayHashMap<T, V>>(this.myStrategy);
            }
            if ((softArrayHashMap = this.myContinuationMap.get(key)) == null) {
                softArrayHashMap = new SoftArrayHashMap<T, V>(this.myStrategy);
                this.myContinuationMap.put(key, softArrayHashMap);
            }
            super.put(array, index + 1, value);
        }
    }

    public void put(T[] key, V value) {
        if (key.length == 0) {
            this.myEmptyValue = value;
        } else {
            this.put(key, 0, value);
        }
    }

    public void clear() {
        this.myContinuationMap = null;
        this.myValuesMap = null;
        this.myEmptyValue = null;
    }

    public boolean containsKey(T[] path2) {
        return this.get(path2) != null;
    }

    public SoftArrayHashMap<T, V> clone() {
        SoftArrayHashMap<T, V> copy = new SoftArrayHashMap<T, V>(this.myStrategy);
        copy.myContinuationMap = this.copyMap(this.myContinuationMap);
        copy.myValuesMap = this.copyMap(this.myValuesMap);
        copy.myEmptyValue = this.myEmptyValue;
        return copy;
    }

    private <X> Map<T, X> copyMap(Map<T, X> map2) {
        SoftHashMap<T, X> copy = new SoftHashMap<T, X>(map2.size());
        copy.putAll(map2);
        return copy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/SoftArrayHashMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processLeafEntries";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

