/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.EDT;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SlowOperations {
    private static final Logger LOG = Logger.getInstance(SlowOperations.class);
    public static final String ACTION_UPDATE = "action.update";
    public static final String ACTION_PERFORM = "action.perform";
    public static final String RENDERING = "rendering";
    public static final String GENERIC = "generic";
    public static final String FAST_TRACK = "  fast track  ";
    public static final String RESET = "  reset  ";
    private static int ourAlwaysAllow = -1;
    @NotNull
    private static @NotNull FList<@NotNull String> ourStack = FList.emptyList();

    private SlowOperations() {
    }

    public static void assertSlowOperationsAreAllowed() {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        if (SlowOperations.isInsideActivity(FAST_TRACK)) {
            throw new ProcessCanceledException();
        }
        if (SlowOperations.isAlwaysAllowed()) {
            return;
        }
        if (!Registry.is("ide.slow.operations.assertion", true)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed() && !Registry.is("ide.slow.operations.assertion.write.action")) {
            return;
        }
        if (ourStack.isEmpty() && !Registry.is("ide.slow.operations.assertion.other", false)) {
            return;
        }
        for (String activity : ourStack) {
            if (RESET.equals(activity)) break;
            if (Registry.is("ide.slow.operations.assertion." + activity, true)) continue;
            return;
        }
        Throwable throwable = new Throwable();
        if (ThrowableInterner.intern(throwable) != throwable) {
            return;
        }
        LOG.error("Slow operations are prohibited on EDT. See SlowOperations.assertSlowOperationsAreAllowed javadoc.");
    }

    @ApiStatus.Internal
    public static boolean isInsideActivity(@NotNull String activityName) {
        if (activityName == null) {
            SlowOperations.$$$reportNull$$$0(0);
        }
        EDT.assertIsEdt();
        for (String activity : ourStack) {
            if (RESET.equals(activity)) break;
            if (activityName != activity) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean isAlwaysAllowed() {
        if (ourAlwaysAllow == 1) {
            return true;
        }
        if (ourAlwaysAllow == 0) {
            return false;
        }
        if (!LoadingState.APP_STARTED.isOccurred()) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        boolean result2 = System.getenv("TEAMCITY_VERSION") != null || application.isUnitTestMode() || application.isCommandLine() || !application.isEAP() && !application.isInternal();
        ourAlwaysAllow = result2 ? 1 : 0;
        return result2;
    }

    public static <T, E extends Throwable> T allowSlowOperations(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            SlowOperations.$$$reportNull$$$0(1);
        }
        try (AccessToken ignore = SlowOperations.allowSlowOperations(GENERIC);){
            T t = computable.compute();
            return t;
        }
    }

    public static <E extends Throwable> void allowSlowOperations(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            SlowOperations.$$$reportNull$$$0(2);
        }
        try (AccessToken ignore = SlowOperations.allowSlowOperations(GENERIC);){
            runnable.run();
        }
    }

    @NotNull
    public static AccessToken allowSlowOperations(@NotNull @NonNls String activityName) {
        if (activityName == null) {
            SlowOperations.$$$reportNull$$$0(3);
        }
        if (!EDT.isCurrentThreadEdt()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                SlowOperations.$$$reportNull$$$0(4);
            }
            return accessToken;
        }
        final FList<String> prev = ourStack;
        ourStack = prev.prepend(activityName);
        return new AccessToken(){

            @Override
            public void finish() {
                ourStack = prev;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SlowOperations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SlowOperations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "allowSlowOperations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsideActivity";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "allowSlowOperations";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

