/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.CacheKey;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.Icon;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageLoader {
    public static final int ALLOW_FLOAT_SCALING = 1;
    public static final int USE_CACHE = 2;
    public static final int USE_DARK = 4;
    public static final int USE_SVG = 8;
    public static final Component ourComponent = new Component(){};

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ImageLoader.class);
        if (logger == null) {
            ImageLoader.$$$reportNull$$$0(0);
        }
        return logger;
    }

    private static void addFileNameVariant(boolean retina, boolean isDark, boolean isSvg, String name2, String ext, float scale, @NotNull List<? super ImageDescriptor> list2) {
        float _scale;
        String _ext;
        if (list2 == null) {
            ImageLoader.$$$reportNull$$$0(1);
        }
        String string2 = _ext = isSvg ? "svg" : ext;
        float f = isSvg ? scale : (_scale = retina ? 2.0f : 1.0f);
        if (retina && isDark) {
            list2.add(new ImageDescriptor(name2 + "@2x_dark." + _ext, _scale, isSvg, true));
        }
        list2.add(new ImageDescriptor(name2 + (isDark ? "_dark" : "") + (retina ? "@2x" : "") + "." + _ext, _scale, isSvg, isDark));
        if (retina) {
            list2.add(new ImageDescriptor(name2 + (isDark ? "_dark" : "") + "." + _ext, isSvg ? scale : 1.0f, isSvg, isDark));
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static Image loadImage(@NotNull String path2, @NotNull List<? extends ImageFilter> filters, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, int flags, @NotNull ScaleContext scaleContext, boolean isUpScaleNeeded) {
        if (path2 == null) {
            ImageLoader.$$$reportNull$$$0(2);
        }
        if (filters == null) {
            ImageLoader.$$$reportNull$$$0(3);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(4);
        }
        long start2 = StartUpMeasurer.getCurrentTimeIfEnabled();
        List<ImageDescriptor> descriptors = ImageLoader.createImageDescriptorList(path2, flags, scaleContext);
        ImageCache imageCache = ImageCache.INSTANCE;
        boolean ioExceptionThrown = false;
        for (int i = 0; i < descriptors.size(); ++i) {
            ImageDescriptor descriptor = descriptors.get(i);
            try {
                Image image = ImageLoader.loadByDescriptor(descriptor, flags, resourceClass, classLoader, i == 0 ? imageCache.ioMissCache : null, imageCache, path2);
                if (image == null) continue;
                if (start2 != -1L) {
                    IconLoadMeasurer.addLoading(descriptor.isSvg, start2);
                }
                boolean isHiDpiNeeded = StartupUiUtil.isJreHiDPI(scaleContext);
                return ImageLoader.convertImage(image, filters, flags, scaleContext, isUpScaleNeeded, isHiDpiNeeded, descriptor.scale, descriptor.isSvg);
            }
            catch (IOException e) {
                ioExceptionThrown = true;
            }
        }
        if (ioExceptionThrown) {
            imageCache.ioMissCache.add(path2);
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static Image loadImageForStartUp(@NotNull String path2, @NotNull ClassLoader classLoader, int flags, @NotNull ScaleContext scaleContext, boolean isUpScaleNeeded) {
        if (path2 == null) {
            ImageLoader.$$$reportNull$$$0(5);
        }
        if (classLoader == null) {
            ImageLoader.$$$reportNull$$$0(6);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(7);
        }
        List<ImageDescriptor> descriptors = ImageLoader.createImageDescriptorList(path2, flags, scaleContext);
        boolean isHiDpiNeeded = StartupUiUtil.isJreHiDPI(scaleContext);
        for (ImageDescriptor descriptor : descriptors) {
            try {
                Image image = ImageLoader.loadByDescriptorWithoutCache(descriptor, null, classLoader);
                if (image == null) continue;
                return ImageLoader.convertImage(image, Collections.emptyList(), flags, scaleContext, isUpScaleNeeded, isHiDpiNeeded, descriptor.scale, descriptor.isSvg);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    @Nullable
    private static Image loadByDescriptor(@NotNull ImageDescriptor descriptor, int flags, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, @Nullable Set<String> ioMissCache, @NotNull ImageCache imageCache, @Nullable String ioMissCacheKey) throws IOException {
        Image image;
        if (descriptor == null) {
            ImageLoader.$$$reportNull$$$0(8);
        }
        if (imageCache == null) {
            ImageLoader.$$$reportNull$$$0(9);
        }
        CacheKey cacheKey = null;
        if ((flags & 2) == 2 && !SVGLoader.isColorRedefinitionContext()) {
            cacheKey = new CacheKey(descriptor.path, descriptor.isSvg ? (double)descriptor.scale : 0.0);
            image = (Image)imageCache.imageCache.get(cacheKey);
            if (image != null) {
                return image;
            }
            image = (Image)imageCache.largeImageCache.get(cacheKey);
            if (image != null) {
                return image;
            }
        }
        if (ioMissCache != null && ioMissCache.contains(ioMissCacheKey)) {
            return null;
        }
        image = ImageLoader.loadByDescriptorWithoutCache(descriptor, resourceClass, classLoader);
        if (image == null) {
            return null;
        }
        if (cacheKey != null) {
            if (4L * (long)image.getWidth(null) * (long)image.getHeight(null) <= ImageCache.CACHED_IMAGE_MAX_SIZE) {
                imageCache.imageCache.put(cacheKey, image);
            } else {
                imageCache.largeImageCache.put(cacheKey, image);
            }
        }
        return image;
    }

    @Nullable
    private static Image loadByDescriptorWithoutCache(@NotNull ImageDescriptor descriptor, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader) throws IOException {
        Image image;
        if (descriptor == null) {
            ImageLoader.$$$reportNull$$$0(10);
        }
        long start2 = StartUpMeasurer.getCurrentTimeIfEnabled();
        if (resourceClass == null && (classLoader == null || URLUtil.containsScheme(descriptor.path)) && !descriptor.path.startsWith("file://")) {
            URLConnection connection = new URL(descriptor.path).openConnection();
            if (connection instanceof HttpURLConnection) {
                connection.addRequestProperty("User-Agent", "IntelliJ");
            }
            try (InputStream stream = connection.getInputStream();){
                image = descriptor.isSvg ? SVGLoader.load(descriptor.path, stream, descriptor.scale, descriptor.isDark, null) : ImageLoader.loadPng(stream, descriptor.scale, null);
            }
            if (start2 != -1L) {
                IconLoadMeasurer.loadFromUrl.end(start2);
            }
        } else {
            image = descriptor.isSvg ? SVGLoader.loadFromClassResource(resourceClass, classLoader, descriptor.path, 0, descriptor.scale, descriptor.isDark, null) : ImageLoader.loadPngFromClassResource(descriptor.path, resourceClass, classLoader, descriptor.scale, null);
            if (start2 != -1L) {
                IconLoadMeasurer.loadFromResources.end(start2);
            }
        }
        return image;
    }

    static byte @Nullable [] getResourceData(@NotNull String path2, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader) throws IOException {
        boolean isAbsolute;
        byte[] data2;
        if (path2 == null) {
            ImageLoader.$$$reportNull$$$0(11);
        }
        assert (resourceClass != null || classLoader != null || path2.startsWith("file://"));
        if (classLoader != null && ((data2 = ResourceUtil.getResourceAsBytes((isAbsolute = path2.startsWith("/")) ? path2.substring(1) : path2, classLoader, true)) != null || isAbsolute)) {
            return data2;
        }
        if (resourceClass != null) {
            try (InputStream stream = resourceClass.getResourceAsStream(path2);){
                data2 = stream == null ? null : stream.readAllBytes();
                return data2;
            }
        }
        if (path2.startsWith("file:/")) {
            Path nioPath = Path.of(URI.create(path2));
            try {
                return Files.readAllBytes(nioPath);
            }
            catch (NoSuchFileException e) {
                return null;
            }
            catch (IOException e) {
                ImageLoader.getLogger().warn(e);
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static Image loadPngFromClassResource(String path2, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, float scale, @Nullable Dimension2DDouble originalUserSize) throws IOException {
        byte[] data2 = ImageLoader.getResourceData(path2, resourceClass, classLoader);
        if (data2 == null) {
            return null;
        }
        return ImageLoader.loadPng(new ByteArrayInputStream(data2), scale, originalUserSize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.Internal
    @NotNull
    public static Image loadFromStream(@NotNull InputStream stream, @Nullable String path2, float scale, @NotNull Dimension2DDouble originalUserSize, int flags) throws IOException {
        if (stream == null) {
            ImageLoader.$$$reportNull$$$0(12);
        }
        if (originalUserSize == null) {
            ImageLoader.$$$reportNull$$$0(13);
        }
        InputStream inputStream = stream;
        if ((flags & 8) == 8) {
            Image image = SVGLoader.load(path2, stream, scale, (flags & 4) == 4, originalUserSize);
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(14);
            }
            return image2;
        }
        BufferedImage bufferedImage = ImageLoader.loadPng(stream, scale, originalUserSize);
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            ImageLoader.$$$reportNull$$$0(15);
        }
        return bufferedImage2;
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static BufferedImage loadPng(@NotNull InputStream stream, float scale, @Nullable Dimension2DDouble originalUserSize) throws IOException {
        BufferedImage image;
        if (stream == null) {
            ImageLoader.$$$reportNull$$$0(16);
        }
        long start2 = StartUpMeasurer.getCurrentTimeIfEnabled();
        ImageReader reader = ImageIO.getImageReadersByFormatName("png").next();
        try (MemoryCacheImageInputStream imageInputStream = new MemoryCacheImageInputStream(stream);){
            reader.setInput(imageInputStream, true, true);
            image = reader.read(0, null);
        }
        finally {
            reader.dispose();
        }
        if (originalUserSize != null) {
            originalUserSize.setSize((float)image.getWidth() / scale, (float)image.getHeight() / scale);
        }
        if (start2 != -1L) {
            IconLoadMeasurer.pngDecoding.end(start2);
        }
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(17);
        }
        return bufferedImage;
    }

    @Nullable
    public static Image convertImage(@NotNull Image image, @NotNull List<? extends ImageFilter> filters, int flags, ScaleContext scaleContext, boolean isUpScaleNeeded, boolean isHiDpiNeeded, float imageScale, boolean isSvg) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(18);
        }
        if (filters == null) {
            ImageLoader.$$$reportNull$$$0(19);
        }
        if (isUpScaleNeeded && !isSvg) {
            float scale = ImageLoader.adjustScaleFactor((flags & 1) == 1, (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE));
            if (imageScale > 1.0f) {
                scale /= imageScale;
            }
            image = ImageLoader.scaleImage(image, scale);
        }
        if (!filters.isEmpty()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            for (ImageFilter imageFilter : filters) {
                if (imageFilter == null) continue;
                image = toolkit.createImage(new FilteredImageSource(ImageUtil.toBufferedImage(image, false).getSource(), imageFilter));
            }
        }
        if (isHiDpiNeeded) {
            image = new JBHiDPIScaledImage(image, scaleContext, 2);
        }
        return image;
    }

    @NotNull
    public static List<ImageDescriptor> getImageDescriptors(@NotNull String path2, int flags, @NotNull ScaleContext scaleContext) {
        if (path2 == null) {
            ImageLoader.$$$reportNull$$$0(20);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(21);
        }
        return ImageLoader.createImageDescriptorList(path2, flags, scaleContext);
    }

    @NotNull
    private static List<ImageDescriptor> createImageDescriptorList(@NotNull String path2, int flags, @NotNull ScaleContext scaleContext) {
        ArrayList<ImageDescriptor> list2;
        if (path2 == null) {
            ImageLoader.$$$reportNull$$$0(22);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(23);
        }
        float pixScale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        int i = path2.lastIndexOf(46);
        String name2 = i < 0 ? path2 : path2.substring(0, i);
        String ext = i < 0 || i == path2.length() - 1 ? "" : path2.substring(i + 1);
        float scale = ImageLoader.adjustScaleFactor((flags & 1) == 1, pixScale);
        if (!path2.startsWith("file:") && path2.contains("://")) {
            int qI = path2.lastIndexOf(63);
            boolean isSvg = StringUtilRt.endsWithIgnoreCase(qI == -1 ? path2 : path2.substring(0, qI), ".svg");
            list2 = Collections.singletonList(new ImageDescriptor(name2 + "." + ext, 1.0f, isSvg, true));
        } else {
            boolean isSvg = "svg".equalsIgnoreCase(ext);
            boolean isDark = (flags & 4) == 4;
            boolean retina = JBUIScale.isHiDPI(pixScale);
            list2 = new ArrayList();
            if (!isSvg && (flags & 8) == 8) {
                ImageLoader.addFileNameVariant(retina, isDark, true, name2, ext, scale, list2);
            }
            ImageLoader.addFileNameVariant(retina, isDark, isSvg, name2, ext, scale, list2);
            if (isDark) {
                ImageLoader.addFileNameVariant(retina, false, isSvg, name2, ext, scale, list2);
                if (!isSvg && (flags & 8) == 8) {
                    ImageLoader.addFileNameVariant(false, false, true, name2, ext, scale, list2);
                }
            }
        }
        ArrayList<ImageDescriptor> arrayList = list2;
        if (arrayList == null) {
            ImageLoader.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(25);
        }
        int flags = 11;
        if (StartupUiUtil.isUnderDarcula()) {
            flags |= 4;
        }
        String path2 = url.toString();
        return ImageLoader.loadImage(path2, Collections.emptyList(), null, null, flags, ScaleContext.create(), !path2.endsWith(".svg"));
    }

    @Nullable
    public static Image loadFromUrl(@NotNull String path2, @Nullable Class<?> aClass, int flags, @NotNull ScaleContext scaleContext) {
        if (path2 == null) {
            ImageLoader.$$$reportNull$$$0(26);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(27);
        }
        return ImageLoader.loadImage(path2, Collections.emptyList(), aClass, null, flags, scaleContext, !path2.endsWith(".svg"));
    }

    public static float adjustScaleFactor(boolean allowFloatScaling, float scale) {
        return allowFloatScaling ? scale : (JBUIScale.isHiDPI(scale) ? 2.0f : 1.0f);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, double scale) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(28);
        }
        if (scale == 1.0) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(29);
            }
            return image2;
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(scale);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(30);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            Image image3 = image;
            if (image3 == null) {
                ImageLoader.$$$reportNull$$$0(31);
            }
            return image3;
        }
        int width = (int)Math.round(scale * (double)w);
        int height = (int)Math.round(scale * (double)h);
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image, false), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(32);
        }
        return bufferedImage;
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetSize) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(33);
        }
        return ImageLoader.scaleImage(image, targetSize, targetSize);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetWidth, int targetHeight) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(34);
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(targetWidth, targetHeight);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(35);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0 || w == targetWidth && h == targetHeight) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(36);
            }
            return image2;
        }
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])null);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(37);
        }
        return bufferedImage;
    }

    @Deprecated
    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        Class<?> callerClass;
        if (s == null) {
            ImageLoader.$$$reportNull$$$0(38);
        }
        return (callerClass = ReflectionUtil.getGrandCallerClass()) == null ? null : ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path2, @NotNull Class<?> aClass) {
        if (path2 == null) {
            ImageLoader.$$$reportNull$$$0(39);
        }
        if (aClass == null) {
            ImageLoader.$$$reportNull$$$0(40);
        }
        ScaleContext scaleContext = ScaleContext.create();
        int flags = 11;
        if (StartupUiUtil.isUnderDarcula()) {
            flags |= 4;
        }
        return ImageLoader.loadImage(path2, Collections.emptyList(), aClass, null, flags, scaleContext, false);
    }

    public static Image loadFromBytes(byte @NotNull [] bytes) {
        if (bytes == null) {
            ImageLoader.$$$reportNull$$$0(41);
        }
        return ImageLoader.loadFromStream(new ByteArrayInputStream(bytes));
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        BufferedImage bufferedImage;
        block10: {
            if (inputStream == null) {
                ImageLoader.$$$reportNull$$$0(42);
            }
            ScaleContext scaleContext = ScaleContext.create();
            InputStream inputStream2 = inputStream;
            try {
                Dimension2DDouble originalUserSize = new Dimension2DDouble(0.0, 0.0);
                float scale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
                BufferedImage image = ImageLoader.loadPng(inputStream, scale, originalUserSize);
                if (StartupUiUtil.isJreHiDPI(scaleContext)) {
                    double userScale = scaleContext.getScale(DerivedScaleType.EFF_USR_SCALE);
                    image = new JBHiDPIScaledImage((Image)image, originalUserSize.getWidth() * userScale, originalUserSize.getHeight() * userScale, 2);
                }
                bufferedImage = image;
                if (inputStream2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ImageLoader.getLogger().error(e);
                    return null;
                }
            }
            inputStream2.close();
        }
        return bufferedImage;
    }

    @Nullable
    public static Image loadCustomIcon(@NotNull File file2) throws IOException {
        if (file2 == null) {
            ImageLoader.$$$reportNull$$$0(43);
        }
        ScaleContext scaleContext = ScaleContext.create();
        float scale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        ImageDescriptor imageDescriptor = new ImageDescriptor(file2.toURI().toURL().toString(), scale, StringUtilRt.endsWithIgnoreCase(file2.getPath(), ".svg"), file2.getPath().contains("_dark."));
        Image icon2 = ImageUtil.ensureHiDPI(ImageLoader.loadByDescriptor(imageDescriptor, 2, null, null, null, ImageCache.INSTANCE, null), scaleContext);
        if (icon2 == null) {
            return null;
        }
        int w = icon2.getWidth(null);
        int h = icon2.getHeight(null);
        if (w <= 0 || h <= 0) {
            ImageLoader.getLogger().error("negative image size: w=" + w + ", h=" + h + ", path=" + file2.getPath());
            return null;
        }
        if (w > EmptyIcon.ICON_18.getIconWidth() || h > EmptyIcon.ICON_18.getIconHeight()) {
            double s = (double)EmptyIcon.ICON_18.getIconWidth() / (double)Math.max(w, h);
            return ImageLoader.scaleImage(icon2, s);
        }
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ImageLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 20: 
            case 22: 
            case 26: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 4: 
            case 7: 
            case 21: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageCache";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalUserSize";
                break;
            }
            case 18: 
            case 28: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ImageLoader";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromStream";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPng";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageDescriptorList";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleImage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addFileNameVariant";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadImage";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadImageForStartUp";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadByDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadByDescriptorWithoutCache";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResourceData";
                break;
            }
            case 12: 
            case 13: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadPng";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertImage";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getImageDescriptors";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createImageDescriptorList";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
            case 28: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "scaleImage";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "loadFromResource";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "loadFromBytes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "loadCustomIcon";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Dimension2DDouble {
        private double myWidth;
        private double myHeight;

        public Dimension2DDouble(double width, double height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public void setSize(Dimension2DDouble size) {
            this.myWidth = size.myWidth;
            this.myHeight = size.myHeight;
        }

        public void setSize(double width, double height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public double getWidth() {
            return this.myWidth;
        }

        public double getHeight() {
            return this.myHeight;
        }
    }

    @ApiStatus.Internal
    public static final class ImageCache {
        public static final ImageCache INSTANCE = new ImageCache();
        private static final long CACHED_IMAGE_MAX_SIZE = (long)(SystemProperties.getFloatProperty("ide.cached.image.max.size", 1.5f) * 1024.0f * 1024.0f);
        private final Set<String> ioMissCache = Collections.newSetFromMap(new ConcurrentHashMap());
        private final ConcurrentMap<CacheKey, Image> imageCache = CollectionFactory.createConcurrentSoftValueMap();
        private final ConcurrentMap<CacheKey, Image> largeImageCache = CollectionFactory.createConcurrentWeakValueMap();

        private ImageCache() {
        }

        @ApiStatus.Internal
        public static boolean isIconTooLargeForCache(@NotNull Icon icon2) {
            if (icon2 == null) {
                ImageCache.$$$reportNull$$$0(0);
            }
            return 4L * (long)icon2.getIconWidth() * (long)icon2.getIconHeight() > CACHED_IMAGE_MAX_SIZE;
        }

        public void clearCache() {
            this.imageCache.clear();
            this.largeImageCache.clear();
            this.ioMissCache.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/util/ImageLoader$ImageCache", "isIconTooLargeForCache"));
        }
    }
}

