/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ExceptionUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\t"}, d2={"getErrorsAsString", "", "errors", "", "", "includeStackTrace", "", "throwIfNotEmpty", "", "intellij.platform.util.ex"})
public final class ErrorKt {
    public static final void throwIfNotEmpty(@NotNull List<? extends Throwable> errors) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        int size = errors.size();
        if (size == 1) {
            throw (Throwable)CollectionsKt.first(errors);
        }
        if (size != 0) {
            throw (Throwable)new CompoundRuntimeException(errors);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final CharSequence getErrorsAsString(@NotNull List<? extends Throwable> errors, boolean includeStackTrace) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        StringBuilder sb = new StringBuilder();
        sb.append(errors.size() + " errors:\n");
        int n = 0;
        int n2 = ((Collection)errors).size();
        while (n < n2) {
            String string2;
            void i;
            sb.append("[").append((int)(i + true)).append("]: ------------------------------\n");
            Throwable error = errors.get((int)i);
            if (includeStackTrace) {
                string2 = ExceptionUtil.getThrowableText(error);
            } else {
                String string3 = error.getMessage();
                string2 = string3;
                Intrinsics.checkNotNull((Object)string3);
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (includeStackTrace) E\u2026ror) else error.message!!");
            String line = string2;
            sb.append(line);
            if (!StringsKt.endsWith$default((CharSequence)line, (char)'\n', (boolean)false, (int)2, null)) {
                sb.append('\n');
            }
            ++i;
        }
        sb.append(StringsKt.repeat((CharSequence)"-", (int)5));
        sb.append("------------------------------\n");
        return sb;
    }

    public static /* synthetic */ CharSequence getErrorsAsString$default(List list2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ErrorKt.getErrorsAsString(list2, bl);
    }
}

