/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@ApiStatus.Experimental
public class EnvironmentRestorer {
    static final String RESERVED_ORIGINAL_VARIABLE_PREFIX = "INTELLIJ_ORIGINAL_ENV_";

    public static void restoreOverriddenVars(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentRestorer.$$$reportNull$$$0(0);
        }
        List<Pair> reserved = ContainerUtil.mapNotNull(envs.entrySet(), entry -> {
            if (((String)entry.getKey()).startsWith(RESERVED_ORIGINAL_VARIABLE_PREFIX)) {
                return new Pair<String, String>((String)entry.getKey(), (String)entry.getValue());
            }
            return null;
        });
        for (Pair pair : reserved) {
            String originalName = ((String)pair.first).substring(RESERVED_ORIGINAL_VARIABLE_PREFIX.length());
            if (originalName.length() == 0) {
                Logger.getInstance(EnvironmentRestorer.class).warn("the name of the reserved environment variable consists only of the prefix \"INTELLIJ_ORIGINAL_ENV_\". name=" + (String)pair.first + " value=" + (String)pair.second);
                continue;
            }
            envs.remove(pair.first);
            if (StringUtil.isNotEmpty((String)pair.second)) {
                envs.put(originalName, (String)pair.second);
                continue;
            }
            envs.remove(originalName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/util/EnvironmentRestorer", "restoreOverriddenVars"));
    }
}

