/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public final class TreeTestUtil {
    private final JTree tree;
    private boolean selection;
    private TreeVisitor visitor;
    private Predicate<? super TreePath> filter;
    private Function<Object, String> converter;

    public TreeTestUtil(@NotNull JTree tree) {
        if (tree == null) {
            TreeTestUtil.$$$reportNull$$$0(0);
        }
        this.visitor = path2 -> TreeVisitor.Action.CONTINUE;
        this.filter = path2 -> true;
        this.converter = node2 -> PlatformTestUtil.toString(node2, null);
        TreeTestUtil.assertTreeUI(tree);
        this.tree = tree;
    }

    public TreeTestUtil withSelection() {
        return this.setSelection(true);
    }

    public TreeTestUtil setSelection(boolean selection) {
        this.selection = selection;
        return this;
    }

    public TreeTestUtil setVisitor(@NotNull TreeVisitor visitor) {
        if (visitor == null) {
            TreeTestUtil.$$$reportNull$$$0(1);
        }
        this.visitor = visitor;
        return this;
    }

    public TreeTestUtil setFilter(@NotNull Predicate<? super TreePath> filter2) {
        if (filter2 == null) {
            TreeTestUtil.$$$reportNull$$$0(2);
        }
        this.filter = filter2;
        return this;
    }

    public TreeTestUtil setConverter(@NotNull Function<Object, String> converter) {
        if (converter == null) {
            TreeTestUtil.$$$reportNull$$$0(3);
        }
        this.converter = converter;
        return this;
    }

    public TreeTestUtil expandAll() {
        PlatformTestUtil.expandAll(this.tree);
        return this;
    }

    public void assertStructure(@NonNls String expected) {
        PlatformTestUtil.waitWhileBusy(this.tree);
        Assert.assertEquals((Object)expected, (Object)this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TreeUtil.visitVisibleRows((JTree)this.tree, path2 -> {
            TreeVisitor.Action action2 = this.visitor.visit(path2);
            if (this.filter.test(path2)) {
                boolean selected;
                int count2 = path2.getPathCount();
                for (int i = 1; i < count2; ++i) {
                    sb.append(' ');
                }
                Object component2 = path2.getLastPathComponent();
                if (!this.tree.getModel().isLeaf(component2)) {
                    sb.append(this.tree.isExpanded(path2) ? (char)'-' : (char)'+');
                }
                boolean bl = selected = this.selection && this.tree.isPathSelected(path2);
                if (selected) {
                    sb.append('[');
                }
                sb.append(this.converter.apply(TreeUtil.getUserObject((Object)component2)));
                if (selected) {
                    sb.append(']');
                }
                sb.append('\n');
            }
            return action2;
        });
        return sb.toString();
    }

    @NotNull
    public static DefaultMutableTreeNode node(@NotNull Object object, Object ... children2) {
        if (object == null) {
            TreeTestUtil.$$$reportNull$$$0(4);
        }
        if (object instanceof DefaultMutableTreeNode && ArrayUtil.isEmpty(children2)) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode == null) {
                TreeTestUtil.$$$reportNull$$$0(5);
            }
            return defaultMutableTreeNode;
        }
        if (object instanceof TreeNode) {
            throw new IllegalArgumentException("do not use a tree node as a node content");
        }
        DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(object);
        for (Object child : children2) {
            node2.add(TreeTestUtil.node(child, new Object[0]));
        }
        DefaultMutableTreeNode defaultMutableTreeNode = node2;
        if (defaultMutableTreeNode == null) {
            TreeTestUtil.$$$reportNull$$$0(6);
        }
        return defaultMutableTreeNode;
    }

    public static void assertTreeUI(@NotNull JTree tree) {
        if (tree == null) {
            TreeTestUtil.$$$reportNull$$$0(7);
        }
        Assert.assertTrue((boolean)(tree.getUI() instanceof BasicTreeUI));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/TreeTestUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/TreeTestUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setConverter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "node";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertTreeUI";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

