/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.svg.ImageValue;
import com.intellij.ui.svg.SvgCacheManager;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.xxh3.Xxh3;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"IMAGE_KEY_SIZE", "", "ZERO_POINT", "Ljava/awt/Point;", "createImage", "Ljava/awt/image/BufferedImage;", "w", "h", "dataBuffer", "Ljava/awt/image/DataBufferInt;", "getCacheKey", "", "themeDigest", "imageBytes", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "writeImage", "Lcom/intellij/ui/svg/ImageValue;", "image", "intellij.platform.util.ui"})
public final class SvgCacheManagerKt {
    private static final int IMAGE_KEY_SIZE = 11;
    private static final Point ZERO_POINT = new Point(0, 0);

    private static final Logger getLogger() {
        Logger logger = Logger.getInstance(SvgCacheManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(SvgCacheManager::class.java)");
        return logger;
    }

    private static final byte[] getCacheKey(byte[] themeDigest, byte[] imageBytes) {
        long contentDigest = Xxh3.hashLongs((long[])new long[]{Xxh3.hash((byte[])imageBytes), Xxh3.hash((byte[])themeDigest)});
        ByteBuffer buffer = ByteBuffer.allocate(11);
        buffer.put((byte)(imageBytes.length >>> 16));
        buffer.put((byte)(imageBytes.length >>> 8));
        buffer.put((byte)imageBytes.length);
        buffer.putLong(contentDigest);
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.array()");
        return byArray;
    }

    private static final BufferedImage createImage(int w, int h, DataBufferInt dataBuffer) {
        ColorModel colorModel = ColorModel.getRGBdefault();
        if (colorModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.image.DirectColorModel");
        }
        DirectColorModel colorModel2 = (DirectColorModel)colorModel;
        WritableRaster raster = Raster.createPackedRaster(dataBuffer, w, h, w, colorModel2.getMasks(), ZERO_POINT);
        return new BufferedImage(colorModel2, raster, false, null);
    }

    private static final ImageValue writeImage(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage convertedImage = new BufferedImage(w, h, 2);
        Graphics2D g = convertedImage.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        WritableRaster writableRaster = convertedImage.getRaster();
        Intrinsics.checkNotNullExpressionValue((Object)writableRaster, (String)"convertedImage.raster");
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        if (dataBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.image.DataBufferInt");
        }
        DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
        return new ImageValue(dataBufferInt.getData(), w, h);
    }

    public static final /* synthetic */ Logger access$getLogger() {
        return SvgCacheManagerKt.getLogger();
    }

    public static final /* synthetic */ byte[] access$getCacheKey(byte[] themeDigest, byte[] imageBytes) {
        return SvgCacheManagerKt.getCacheKey(themeDigest, imageBytes);
    }

    public static final /* synthetic */ ImageValue access$writeImage(BufferedImage image) {
        return SvgCacheManagerKt.writeImage(image);
    }

    public static final /* synthetic */ BufferedImage access$createImage(int w, int h, DataBufferInt dataBuffer) {
        return SvgCacheManagerKt.createImage(w, h, dataBuffer);
    }
}

