/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.Scale;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScaleContext
extends UserScaleContext {
    protected Scale sysScale;
    @Nullable
    protected WeakReference<Component> compRef;

    protected ScaleContext() {
        this.sysScale = ScaleType.SYS_SCALE.of(JBUIScale.sysScale());
        this.pixScale = this.derivePixScale();
    }

    protected ScaleContext(@NotNull Scale scale) {
        if (scale == null) {
            ScaleContext.$$$reportNull$$$0(0);
        }
        this();
        this.setScale(scale);
    }

    @NotNull
    public static ScaleContext createIdentity() {
        return ScaleContext.create(ScaleType.USR_SCALE.of(1.0), ScaleType.SYS_SCALE.of(1.0));
    }

    @NotNull
    public static ScaleContext create(@Nullable UserScaleContext ctx) {
        ScaleContext c = ScaleContext.create();
        c.update(ctx);
        ScaleContext scaleContext = c;
        if (scaleContext == null) {
            ScaleContext.$$$reportNull$$$0(1);
        }
        return scaleContext;
    }

    @NotNull
    public static ScaleContext create(@Nullable Component comp) {
        ScaleContext ctx = new ScaleContext(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(comp)));
        if (comp != null) {
            ctx.compRef = new WeakReference<Component>(comp);
        }
        ScaleContext scaleContext = ctx;
        if (scaleContext == null) {
            ScaleContext.$$$reportNull$$$0(2);
        }
        return scaleContext;
    }

    @NotNull
    public static ScaleContext create(@Nullable GraphicsConfiguration gc) {
        return new ScaleContext(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(gc)));
    }

    @NotNull
    public static ScaleContext create(Graphics2D g) {
        return new ScaleContext(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(g)));
    }

    @NotNull
    public static ScaleContext create(@NotNull Scale scale) {
        if (scale == null) {
            ScaleContext.$$$reportNull$$$0(3);
        }
        return new ScaleContext(scale);
    }

    @NotNull
    public static ScaleContext create(Scale ... scales) {
        if (scales == null) {
            ScaleContext.$$$reportNull$$$0(4);
        }
        ScaleContext ctx = ScaleContext.create();
        for (Scale s : scales) {
            ctx.setScale(s);
        }
        ScaleContext scaleContext = ctx;
        if (scaleContext == null) {
            ScaleContext.$$$reportNull$$$0(5);
        }
        return scaleContext;
    }

    @NotNull
    public static ScaleContext create() {
        return new ScaleContext();
    }

    @Override
    protected double derivePixScale() {
        return this.getScale(DerivedScaleType.DEV_SCALE) * super.derivePixScale();
    }

    @Override
    public double getScale(@NotNull ScaleType type) {
        if (type == null) {
            ScaleContext.$$$reportNull$$$0(6);
        }
        if (type == ScaleType.SYS_SCALE) {
            return this.sysScale.value;
        }
        return super.getScale(type);
    }

    @Override
    @NotNull
    protected Scale getScaleObject(@NotNull ScaleType type) {
        if (type == null) {
            ScaleContext.$$$reportNull$$$0(7);
        }
        if (type == ScaleType.SYS_SCALE) {
            Scale scale = this.sysScale;
            if (scale == null) {
                ScaleContext.$$$reportNull$$$0(8);
            }
            return scale;
        }
        Scale scale = super.getScaleObject(type);
        if (scale == null) {
            ScaleContext.$$$reportNull$$$0(9);
        }
        return scale;
    }

    @Override
    public double getScale(@NotNull DerivedScaleType type) {
        if (type == null) {
            ScaleContext.$$$reportNull$$$0(10);
        }
        switch (type) {
            case DEV_SCALE: {
                return JreHiDpiUtil.isJreHiDPIEnabled() ? this.sysScale.value : 1.0;
            }
            case EFF_USR_SCALE: {
                return this.usrScale.value * this.objScale.value;
            }
            case PIX_SCALE: {
                return this.pixScale;
            }
        }
        return 1.0;
    }

    @Override
    public boolean update() {
        Component component2;
        boolean updated = this.setScale(ScaleType.USR_SCALE.of(JBUIScale.scale(1.0f)));
        if (this.compRef != null && (component2 = (Component)this.compRef.get()) != null) {
            updated = this.setScale(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(component2.getGraphicsConfiguration()))) || updated;
        }
        return this.onUpdated(updated);
    }

    @Override
    public boolean setScale(@NotNull Scale scale) {
        if (scale == null) {
            ScaleContext.$$$reportNull$$$0(11);
        }
        if (this.isScaleOverridden(scale)) {
            return false;
        }
        if (scale.type == ScaleType.SYS_SCALE) {
            boolean updated = !this.sysScale.equals(scale);
            this.sysScale = scale;
            return this.onUpdated(updated);
        }
        return super.setScale(scale);
    }

    @Override
    protected <T extends UserScaleContext> boolean updateAll(@NotNull T scaleContext) {
        if (scaleContext == null) {
            ScaleContext.$$$reportNull$$$0(12);
        }
        boolean updated = super.updateAll(scaleContext);
        if (!(scaleContext instanceof ScaleContext)) {
            return updated;
        }
        ScaleContext context2 = (ScaleContext)scaleContext;
        if (this.compRef != null) {
            this.compRef.clear();
        }
        this.compRef = context2.compRef;
        return this.setScale(context2.sysScale) || updated;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof ScaleContext) {
            ScaleContext that = (ScaleContext)obj;
            return that.sysScale.value == this.sysScale.value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.sysScale.value) * 31 + super.hashCode();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.compRef != null) {
            this.compRef.clear();
        }
    }

    @Override
    @NotNull
    public <T extends UserScaleContext> T copy() {
        ScaleContext ctx = ScaleContext.createIdentity();
        ctx.updateAll(this);
        ScaleContext scaleContext = ctx;
        if (scaleContext == null) {
            ScaleContext.$$$reportNull$$$0(13);
        }
        return (T)scaleContext;
    }

    @Override
    public String toString() {
        return this.usrScale + ", " + this.sysScale + ", " + this.objScale + ", " + this.pixScale;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scale";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/scale/ScaleContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scales";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/scale/ScaleContext";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScaleObject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getScale";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScaleObject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setScale";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Cache<D>
    extends UserScaleContext.Cache<D, ScaleContext> {
        public Cache(@NotNull Function<? super ScaleContext, ? extends D> dataProvider) {
            if (dataProvider == null) {
                Cache.$$$reportNull$$$0(0);
            }
            super(dataProvider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/ui/scale/ScaleContext$Cache", "<init>"));
        }
    }
}

