/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CaptionPanel;
import com.intellij.ui.EngravedLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicHTML;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TitlePanel
extends CaptionPanel {
    private final JLabel myLabel;
    private final Icon myRegular;
    private final Icon myInactive;
    private boolean obeyPreferredWidth;
    private boolean isPopup = false;
    private boolean useHeaderInsets = false;

    public TitlePanel() {
        this(null, null);
    }

    public TitlePanel(Icon regular, Icon inactive) {
        this.myRegular = regular;
        this.myInactive = inactive;
        this.myLabel = new EngravedLabel();
        this.myLabel.setForeground(JBColor.foreground());
        this.myLabel.setHorizontalAlignment(0);
        this.myLabel.setVerticalAlignment(0);
        this.myLabel.setBorder(JBUI.Borders.empty(1, 10, 2, 10));
        this.add((Component)this.myLabel, "Center");
        this.setActive(false);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.myLabel.setIcon(active ? this.myRegular : this.myInactive);
        if (this.isPopup) {
            this.myLabel.setForeground(JBUI.CurrentTheme.Popup.headerForeground(active));
        } else {
            this.myLabel.setForeground(active ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground());
        }
    }

    public void setText(@Nls String titleText) {
        this.obeyPreferredWidth = BasicHTML.isHTMLString(titleText);
        this.myLabel.setText(titleText);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, this.getPreferredSize().height);
    }

    @Override
    public Dimension getPreferredSize() {
        String text2 = this.myLabel.getText();
        if (text2 == null || text2.trim().isEmpty()) {
            return JBUI.emptySize();
        }
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.height = this.useHeaderInsets ? this.myLabel.getPreferredSize().height : JBUI.CurrentTheme.Popup.headerHeight(this.containsSettingsControls());
        int maxWidth = JBUIScale.scale(350);
        if (!this.obeyPreferredWidth && preferredSize.width > maxWidth) {
            return new Dimension(maxWidth, preferredSize.height);
        }
        return preferredSize;
    }

    @NotNull
    public JLabel getLabel() {
        JLabel jLabel = this.myLabel;
        if (jLabel == null) {
            TitlePanel.$$$reportNull$$$0(0);
        }
        return jLabel;
    }

    @ApiStatus.Internal
    public void obeyPreferredWidth(boolean obeyWidth) {
        this.obeyPreferredWidth = obeyWidth;
    }

    @ApiStatus.Internal
    public void setPopupTitle(boolean isExperimentalUI) {
        this.isPopup = true;
        if (isExperimentalUI) {
            this.myLabel.setFont(this.myLabel.getFont().deriveFont(1));
            this.useHeaderInsets = true;
            this.myLabel.setBorder(new EmptyBorder(JBUI.CurrentTheme.Popup.headerInsets()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TitlePanel", "getLabel"));
    }
}

